/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.core.spi.IAgentService;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.p2.P2Exception;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileCreator;
import org.eclipse.oomph.p2.internal.core.AgentManagerElementImpl;
import org.eclipse.oomph.p2.internal.core.AgentManagerImpl;
import org.eclipse.oomph.p2.internal.core.BundlePoolImpl;
import org.eclipse.oomph.p2.internal.core.CachingRepositoryManager;
import org.eclipse.oomph.p2.internal.core.CachingTransport;
import org.eclipse.oomph.p2.internal.core.LazyProfileRegistry;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.p2.internal.core.PersistentMap;
import org.eclipse.oomph.p2.internal.core.ProfileCreatorImpl;
import org.eclipse.oomph.p2.internal.core.ProfileImpl;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentImpl
extends AgentManagerElementImpl
implements Agent {
    public static final String ENGINE_PATH = "org.eclipse.equinox.p2.engine";
    private final AgentManagerImpl agentManager;
    private final File location;
    private final PersistentMap<BundlePool> bundlePoolMap;
    private final PersistentMap<Profile> profileMap;
    private IProvisioningAgent provisioningAgent;
    private IProfileRegistry profileRegistry;
    private IMetadataRepositoryManager metadataRepositoryManager;
    private IArtifactRepositoryManager artifactRepositoryManager;
    private IEngine engine;
    private IPlanner planner;
    private Transport originalTransport;
    private IMetadataRepositoryManager originalMetadataRepositoryManager;
    private IArtifactRepositoryManager originalArtifactRepositoryManager;

    public AgentImpl(AgentManagerImpl agentManager, File location) {
        this.agentManager = agentManager;
        this.location = location;
        this.bundlePoolMap = new PersistentMap<BundlePool>(new File(location, "pools.info")){

            @Override
            protected BundlePool createElement(String key, String extraInfo) {
                return new BundlePoolImpl(AgentImpl.this, new File(key));
            }

            @Override
            protected void initializeFirstTime() {
                IProfileRegistry profileRegistry = AgentImpl.this.getProfileRegistry();
                IProfile[] iProfileArray = profileRegistry.getProfiles();
                int n = iProfileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProfile delegate = iProfileArray[n2];
                    String cache = delegate.getProperty("org.eclipse.equinox.p2.cache");
                    if (cache != null) {
                        this.addElement(cache, null);
                    }
                    ++n2;
                }
            }
        };
        this.profileMap = new PersistentMap<Profile>(new File(location, "profiles.info")){

            @Override
            protected Profile createElement(String profileID, String extraInfo) {
                List tokens = StringUtil.explode((String)extraInfo, (String)"|");
                int size = tokens.size();
                String type = size > 0 ? (String)tokens.get(0) : "";
                BundlePool bundlePool = size > 1 ? AgentImpl.this.getBundlePool((String)tokens.get(1)) : null;
                File installFolder = size > 2 ? AgentImpl.getFile((String)tokens.get(2)) : null;
                File referencer = size > 3 ? AgentImpl.getFile((String)tokens.get(3)) : null;
                return new ProfileImpl(AgentImpl.this, bundlePool, profileID, type, installFolder, referencer);
            }

            @Override
            protected void initializeFirstTime() {
                AgentImpl.this.fillProfileMap(this);
            }
        };
        this.bundlePoolMap.load();
        this.profileMap.load();
    }

    @Override
    public String getElementType() {
        return "agent";
    }

    public void dispose() {
        if (this.provisioningAgent != null) {
            if (this.originalTransport != null) {
                this.provisioningAgent.registerService(Transport.SERVICE_NAME, (Object)this.originalTransport);
            }
            if (this.originalMetadataRepositoryManager != null) {
                if (this.metadataRepositoryManager instanceof IAgentService) {
                    ((IAgentService)this.metadataRepositoryManager).stop();
                }
                this.provisioningAgent.registerService(IMetadataRepositoryManager.SERVICE_NAME, (Object)this.originalMetadataRepositoryManager);
            }
            if (this.originalArtifactRepositoryManager != null) {
                if (this.artifactRepositoryManager instanceof IAgentService) {
                    ((IAgentService)this.artifactRepositoryManager).stop();
                }
                this.provisioningAgent.registerService(IArtifactRepositoryManager.SERVICE_NAME, (Object)this.originalArtifactRepositoryManager);
            }
        }
    }

    @Override
    public AgentManager getAgentManager() {
        return this.agentManager;
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    @Override
    public boolean isValid() {
        return AgentImpl.isValid(this.location);
    }

    @Override
    public boolean isCurrent() {
        return this.agentManager.getCurrentAgent() == this;
    }

    @Override
    public boolean isUsed() {
        for (BundlePool bundlePool : this.getBundlePools()) {
            if (!bundlePool.isUsed()) continue;
            return true;
        }
        for (Profile profile : this.getProfiles()) {
            if (!profile.isUsed()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doDelete() {
        this.agentManager.deleteAgent(this);
    }

    public PersistentMap<BundlePool> getBundlePoolMap() {
        return this.bundlePoolMap;
    }

    @Override
    public Set<File> getBundlePoolLocations() {
        return AgentManagerImpl.getLocations(this.bundlePoolMap.getElementKeys());
    }

    @Override
    public Collection<BundlePool> getBundlePools() {
        return this.bundlePoolMap.getElements();
    }

    public BundlePool getBundlePool(String path) {
        return this.bundlePoolMap.getElement(path);
    }

    @Override
    public BundlePool getBundlePool(File location) {
        return this.bundlePoolMap.getElement(location.getAbsolutePath());
    }

    @Override
    public BundlePool addBundlePool(File location) {
        return this.bundlePoolMap.addElement(location.getAbsolutePath(), null);
    }

    public void deleteBundlePool(BundlePool bundlePool) {
        this.bundlePoolMap.removeElement(bundlePool.getLocation().getAbsolutePath());
    }

    @Override
    public void refreshBundlePools(IProgressMonitor monitor) {
        monitor.subTask("Refreshing " + this.getLocation() + " bundle pools");
        this.bundlePoolMap.refresh();
        monitor.done();
    }

    @Override
    public synchronized IProfileRegistry getProfileRegistry() {
        this.getProvisioningAgent();
        return this.profileRegistry;
    }

    public PersistentMap<Profile> getProfileMap() {
        return this.profileMap;
    }

    @Override
    public Set<String> getAllProfileIDs() {
        return this.profileMap.getElementKeys();
    }

    @Override
    public Collection<Profile> getAllProfiles() {
        return this.profileMap.getElements();
    }

    @Override
    public Set<String> getProfileIDs() {
        return this.getProfileIDs(null);
    }

    public Set<String> getProfileIDs(BundlePool bundlePool) {
        HashSet<String> ids = new HashSet<String>();
        for (Profile profile : this.getAllProfiles()) {
            if (profile.getBundlePool() != bundlePool) continue;
            ids.add(profile.getProfileId());
        }
        return ids;
    }

    @Override
    public Collection<Profile> getProfiles() {
        return this.getProfiles(null);
    }

    public Collection<Profile> getProfiles(BundlePool bundlePool) {
        Collection<Profile> profiles = this.getAllProfiles();
        Iterator<Profile> it = profiles.iterator();
        while (it.hasNext()) {
            Profile profile = it.next();
            if (profile.getBundlePool() == bundlePool) continue;
            it.remove();
        }
        return profiles;
    }

    @Override
    public Profile getCurrentProfile() {
        IProfile delegate = this.getProfileRegistry().getProfile("_SELF_");
        if (delegate != null) {
            String profileID = delegate.getProfileId();
            return this.getProfile(profileID);
        }
        return null;
    }

    @Override
    public Profile getProfile(String id) {
        Profile profile = this.profileMap.getElement(id);
        if (profile == null) {
            if (this.provisioningAgent == null) {
                this.getProvisioningAgent();
                profile = this.profileMap.getElement(id);
            }
        } else if (!profile.isValid()) {
            this.profileMap.removeElement(id);
            this.getProfileRegistry().removeProfile(id);
            profile = null;
        }
        return profile;
    }

    @Override
    public ProfileCreator addProfile(String id, String type) {
        return new ProfileCreatorImpl(this, id, type){
            private static final long serialVersionUID = 1L;

            protected Profile doCreateProfile() {
                return AgentImpl.this.createProfile(this);
            }
        };
    }

    public Profile createProfile(ProfileCreator creator) {
        if (creator.getEnvironments() == null) {
            creator.addOS(Platform.getOS());
            creator.addWS(Platform.getWS());
            creator.addArch(Platform.getOSArch());
            creator.addLanguage(Platform.getNL());
        }
        try {
            String profileID = creator.getProfileID();
            IProfile delegate = this.getProfileRegistry().addProfile(profileID, (Map)creator);
            String extraInfo = AgentImpl.getProfileExtraInfo(delegate);
            ProfileImpl profile = (ProfileImpl)this.profileMap.addElement(profileID, extraInfo);
            profile.setDelegate(delegate);
            return profile;
        }
        catch (ProvisionException ex) {
            throw new P2Exception((Throwable)ex);
        }
    }

    public void deleteProfile(Profile profile) {
        String profileID = profile.getProfileId();
        this.profileMap.removeElement(profileID);
        this.getProfileRegistry().removeProfile(profileID);
    }

    @Override
    public void refreshProfiles(IProgressMonitor monitor) {
        this.getProvisioningAgent();
        if (this.profileRegistry instanceof LazyProfileRegistry) {
            LazyProfileRegistry lazyProfileRegistry = (LazyProfileRegistry)this.profileRegistry;
            lazyProfileRegistry.resetProfiles();
            lazyProfileRegistry.getProfileMap(monitor);
        }
        this.fillProfileMap(this.profileMap);
        this.profileMap.refresh();
    }

    private void fillProfileMap(PersistentMap<Profile> profileMap) {
        IProfileRegistry profileRegistry = this.getProfileRegistry();
        IProfile[] iProfileArray = profileRegistry.getProfiles();
        int n = iProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProfile delegate = iProfileArray[n2];
            String key = delegate.getProfileId();
            String extraInfo = AgentImpl.getProfileExtraInfo(delegate);
            profileMap.addElement(key, extraInfo);
            ++n2;
        }
    }

    public void initializeProvisioningAgent(IProvisioningAgent provisioningAgent) {
        if (this.provisioningAgent == null) {
            this.profileRegistry = (IProfileRegistry)provisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
            this.metadataRepositoryManager = (IMetadataRepositoryManager)provisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            this.artifactRepositoryManager = (IArtifactRepositoryManager)provisioningAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            Transport transport = (Transport)provisioningAgent.getService(Transport.SERVICE_NAME);
            if (AgentImpl.cacheTransport(transport)) {
                this.originalTransport = transport;
                CachingTransport cachingTransport = new CachingTransport(transport, provisioningAgent);
                provisioningAgent.registerService(Transport.SERVICE_NAME, (Object)cachingTransport);
                this.originalMetadataRepositoryManager = this.metadataRepositoryManager;
                this.metadataRepositoryManager = new CachingRepositoryManager.Metadata(provisioningAgent, cachingTransport);
                provisioningAgent.registerService(IMetadataRepositoryManager.SERVICE_NAME, (Object)this.metadataRepositoryManager);
                this.originalArtifactRepositoryManager = this.artifactRepositoryManager;
                this.artifactRepositoryManager = new CachingRepositoryManager.Artifact(provisioningAgent, cachingTransport);
                provisioningAgent.registerService(IArtifactRepositoryManager.SERVICE_NAME, (Object)this.artifactRepositoryManager);
            }
            this.provisioningAgent = provisioningAgent;
        }
    }

    @Override
    public synchronized IProvisioningAgent getProvisioningAgent() {
        if (this.provisioningAgent == null) {
            File location = this.getLocation();
            this.initializeProvisioningAgent(AgentImpl.getOrCreateProvisioningAgent(location));
        }
        return this.provisioningAgent;
    }

    @Override
    public synchronized IMetadataRepositoryManager getMetadataRepositoryManager() {
        this.getProvisioningAgent();
        return this.metadataRepositoryManager;
    }

    @Override
    public synchronized IArtifactRepositoryManager getArtifactRepositoryManager() {
        this.getProvisioningAgent();
        return this.artifactRepositoryManager;
    }

    @Override
    public synchronized IEngine getEngine() {
        if (this.engine == null) {
            this.engine = (IEngine)this.getProvisioningAgent().getService(IEngine.SERVICE_NAME);
            if (this.engine == null) {
                throw new IllegalStateException("Engine could not be loaded");
            }
        }
        return this.engine;
    }

    @Override
    public synchronized IPlanner getPlanner() {
        if (this.planner == null) {
            this.planner = (IPlanner)this.getProvisioningAgent().getService(IPlanner.SERVICE_NAME);
            if (this.planner == null) {
                throw new IllegalStateException("Planner could not be loaded");
            }
        }
        return this.planner;
    }

    public String toString() {
        return this.getLocation().getAbsolutePath();
    }

    private static boolean cacheTransport(Transport transport) {
        if (PropertiesUtil.isProperty((String)"oomph.p2.disable.offline")) {
            return false;
        }
        if (transport instanceof CachingTransport) {
            return false;
        }
        return transport != null;
    }

    private static File getFile(String path) {
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        return new File(path);
    }

    public static boolean isValid(File location) {
        return new File(location, ENGINE_PATH).isDirectory();
    }

    public static String getProfileType(IProfile delegate) {
        String type = delegate.getProperty("org.eclipse.oomph.p2.profile.type");
        if (type == null) {
            if (delegate.getProperty("targlet.container.id") != null) {
                return "Targlet";
            }
            if (delegate.getProperty("org.eclipse.equinox.p2.installFolder") != null) {
                return "Installation";
            }
        }
        return type;
    }

    public static String getProfileExtraInfo(IProfile delegate) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(AgentImpl.getProfileType(delegate));
        tokens.add(delegate.getProperty("org.eclipse.equinox.p2.cache"));
        tokens.add(delegate.getProperty("org.eclipse.equinox.p2.installFolder"));
        tokens.add(delegate.getProperty("org.eclipse.oomph.p2.profile.referencer"));
        return StringUtil.implode(tokens, (char)'|');
    }

    public static IProvisioningAgent getOrCreateProvisioningAgent(File location) {
        IProvisioningAgent provisioningAgent;
        BundleContext context;
        block20: {
            context = P2CorePlugin.INSTANCE.getBundleContext();
            ServiceReference agentRef = null;
            provisioningAgent = null;
            try {
                try {
                    Collection agentRefs = null;
                    try {
                        agentRefs = context.getServiceReferences(IProvisioningAgent.class, "(locationURI=" + location.toURI() + ")");
                    }
                    catch (InvalidSyntaxException invalidSyntaxException) {}
                    if (agentRefs != null && !agentRefs.isEmpty()) {
                        agentRef = (ServiceReference)agentRefs.iterator().next();
                        provisioningAgent = (IProvisioningAgent)context.getService(agentRef);
                    }
                }
                catch (Exception exception) {
                    provisioningAgent = null;
                    if (agentRef != null) {
                        context.ungetService(agentRef);
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (agentRef != null) {
                    context.ungetService(agentRef);
                }
                throw throwable;
            }
            if (agentRef != null) {
                context.ungetService(agentRef);
            }
        }
        if (provisioningAgent == null) {
            location.mkdirs();
            ServiceReference providerRef = null;
            try {
                try {
                    providerRef = context.getServiceReference(IProvisioningAgentProvider.class);
                    if (providerRef != null) {
                        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)context.getService(providerRef);
                        provisioningAgent = provider.createAgent(location.toURI());
                    }
                }
                catch (ProvisionException ex) {
                    throw new P2Exception((Throwable)ex);
                }
            }
            finally {
                if (providerRef != null) {
                    context.ungetService(providerRef);
                }
            }
        }
        if (provisioningAgent == null) {
            throw new P2Exception("Provisioning agent could not be loaded from " + location);
        }
        return provisioningAgent;
    }
}

