/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash.revision;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.oomph.gitbash.UpdateCopyrightsHelper;
import org.eclipse.oomph.gitbash.revision.AbstractRevisionAction;
import org.eclipse.swt.widgets.Shell;

public class UpdateCommitCopyrightsAction
extends AbstractRevisionAction {
    protected void run(Shell shell, Repository repository, File workTree, RevObject revision) throws Exception {
        if (revision instanceof RevCommit) {
            RevCommit commit = (RevCommit)revision;
            RevCommit parent = commit.getParent(0);
            DiffFormatter diffFormatter = new DiffFormatter((OutputStream)System.out);
            ArrayList<File> inputFiles = new ArrayList<File>();
            try {
                diffFormatter.setRepository(repository);
                List entries = diffFormatter.scan((AnyObjectId)parent, (AnyObjectId)commit);
                if (entries != null) {
                    for (DiffEntry entry : entries) {
                        File file;
                        String path = entry.getNewPath();
                        if (path == null || path.length() == 0 || !(file = new File(workTree, path)).isFile()) continue;
                        inputFiles.add(file);
                    }
                }
            }
            finally {
                diffFormatter.close();
            }
            if (!inputFiles.isEmpty()) {
                UpdateCopyrightsHelper helper = new UpdateCopyrightsHelper();
                helper.run(shell, repository, inputFiles);
            }
        }
    }
}

