/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.manifests.handlers;

import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.oomph.manifests.Activator;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class CleanBuildHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window != null && (selection = this.getSelection(event)) != null && !selection.isEmpty()) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        Object[] array = selection.toArray();
                        int i = 0;
                        while (i < array.length) {
                            IProject project = (IProject)array[i];
                            if (project.isAccessible()) {
                                try {
                                    IMarker[] markers;
                                    IMarker[] iMarkerArray = markers = project.findMarkers(null, true, 2);
                                    int n = markers.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IMarker marker = iMarkerArray[n2];
                                        try {
                                            marker.delete();
                                        }
                                        catch (CoreException ex) {
                                            CleanBuildHandler.this.log(ex);
                                        }
                                        ++n2;
                                    }
                                }
                                catch (CoreException ex) {
                                    CleanBuildHandler.this.log(ex);
                                }
                            }
                            ++i;
                        }
                    }
                }, null, 1, null);
            }
            catch (CoreException ex) {
                this.log(ex);
            }
            BuildAction buildAction = new BuildAction((IShellProvider)window, 15);
            buildAction.selectionChanged(selection);
            buildAction.run();
        }
        return null;
    }

    private IStructuredSelection getSelection(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            HashSet<IProject> projects = new HashSet<IProject>();
            for (Object element : (IStructuredSelection)selection) {
                IResource resource;
                IProject project;
                IMarker marker;
                IAdaptable adaptable;
                if (element instanceof IAdaptable && (element = (adaptable = (IAdaptable)element).getAdapter(IResource.class)) == null && (marker = (IMarker)ObjectUtil.adapt((Object)adaptable, IMarker.class)) != null) {
                    element = marker.getResource();
                }
                if (element instanceof IProject) {
                    projects.add((IProject)element);
                    continue;
                }
                if (!(element instanceof IResource) || (project = (resource = (IResource)element).getProject()) == null) continue;
                projects.add(project);
            }
            if (projects.isEmpty()) {
                return null;
            }
            return new StructuredSelection(projects.toArray());
        }
        IEditorInput activeEditorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        if (activeEditorInput instanceof FileEditorInput) {
            IProject project = ((FileEditorInput)activeEditorInput).getFile().getProject();
            return new StructuredSelection((Object)project);
        }
        return null;
    }

    private void log(CoreException ex) {
        Activator.getDefault().getLog().log(ex.getStatus());
    }
}

