/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.ae;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.FlexContainer;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;
import org.eclipse.om2m.das.testsuite.ae.AbstractDASServiceTest;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.osgi.framework.ServiceRegistration;

public class DASServiceTest_IndirectDACIs
extends AbstractDASServiceTest {
    public DASServiceTest_IndirectDACIs(CseService pCseService) {
        super("DASService Indirect DACIs", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation dac = this.createDAS(this.getDasAE().getResourceID());
        if (dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create dac");
            return;
        }
        this.setExpectedNumberOfCall(1);
        ServiceRegistration<InterworkingService> interworkingServiceRegistration = this.registerInterworkingService(this);
        ArrayList<String> dacis = new ArrayList<String>();
        dacis.add(dac.getResourceID());
        FlexContainer parentFlexContainer = this.createFlexContainer(dacis);
        if (parentFlexContainer == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create parentFlexContainer");
            return;
        }
        FlexContainer childFlexContainer = new FlexContainer();
        childFlexContainer.setContainerDefinition("grege");
        childFlexContainer.setName("FlexContainer_" + UUID.randomUUID());
        RequestPrimitive childCreateRequest = new RequestPrimitive();
        childCreateRequest.setFrom("mama:mimi");
        childCreateRequest.setTo(parentFlexContainer.getResourceID());
        childCreateRequest.setOperation(Operation.CREATE);
        childCreateRequest.setRequestContentType("application/obj");
        childCreateRequest.setReturnContentType("application/obj");
        childCreateRequest.setResourceType(28);
        childCreateRequest.setContent((Object)childFlexContainer);
        ResponsePrimitive childCreateResponse = this.getCseService().doRequest(childCreateRequest);
        if (childCreateResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("childCreateResponse is null");
            return;
        }
        if (!ResponseStatusCode.CREATED.equals(childCreateResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create child FlexContainer, expecting " + ResponseStatusCode.CREATED + ", found=" + childCreateResponse.getResponseStatusCode());
        }
        FlexContainer createdChildFlexContainer = (FlexContainer)childCreateResponse.getContent();
        if (!this.checkCall(0, parentFlexContainer.getResourceID(), "mama:mimi", Operation.CREATE)) {
            return;
        }
        this.clearCalls();
        RequestPrimitive retrieveChildFlexContainerRequest = new RequestPrimitive();
        retrieveChildFlexContainerRequest.setFrom("sisi:sasa");
        retrieveChildFlexContainerRequest.setTo(createdChildFlexContainer.getResourceID());
        retrieveChildFlexContainerRequest.setOperation(Operation.RETRIEVE);
        retrieveChildFlexContainerRequest.setReturnContentType("application/obj");
        ResponsePrimitive retrieveChildFlexContainerResponse = this.getCseService().doRequest(retrieveChildFlexContainerRequest);
        if (retrieveChildFlexContainerResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveChildFlexContainerResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveChildFlexContainerResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve child FlexContainer, expecting " + ResponseStatusCode.OK + ", found " + retrieveChildFlexContainerResponse.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdChildFlexContainer.getResourceID(), "sisi:sasa", Operation.RETRIEVE)) {
            return;
        }
        this.clearCalls();
        FlexContainer grandSonFlexContainer = new FlexContainer();
        grandSonFlexContainer.setContainerDefinition("juju");
        grandSonFlexContainer.setName("FlexContainerGrandSon_" + UUID.randomUUID());
        RequestPrimitive createGrandSonRequest = new RequestPrimitive();
        createGrandSonRequest.setOperation(Operation.CREATE);
        createGrandSonRequest.setFrom("juju:jaja");
        createGrandSonRequest.setTo(createdChildFlexContainer.getResourceID());
        createGrandSonRequest.setRequestContentType("application/obj");
        createGrandSonRequest.setReturnContentType("application/obj");
        createGrandSonRequest.setResourceType(28);
        createGrandSonRequest.setContent((Object)grandSonFlexContainer);
        ResponsePrimitive createGrandSonResponse = this.getCseService().doRequest(createGrandSonRequest);
        if (createGrandSonResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("createGrandSonResponse is null");
            return;
        }
        if (!ResponseStatusCode.CREATED.equals(createGrandSonResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create grandSon, expecting " + ResponseStatusCode.CREATED + ", found=" + createGrandSonResponse.getResponseStatusCode());
            return;
        }
        FlexContainer createdGrandSonFlexContainer = (FlexContainer)createGrandSonResponse.getContent();
        if (!this.checkCall(0, createdChildFlexContainer.getResourceID(), "juju:jaja", Operation.CREATE)) {
            return;
        }
        this.clearCalls();
        RequestPrimitive retrieveGrandSonFlexContainerRequest = new RequestPrimitive();
        retrieveGrandSonFlexContainerRequest.setTo(createdGrandSonFlexContainer.getResourceID());
        retrieveGrandSonFlexContainerRequest.setReturnContentType("application/obj");
        retrieveGrandSonFlexContainerRequest.setOperation(Operation.RETRIEVE);
        retrieveGrandSonFlexContainerRequest.setFrom("xixi:xoxo");
        ResponsePrimitive retrieveGrandSonFlexContainerResponse = this.getCseService().doRequest(retrieveGrandSonFlexContainerRequest);
        if (retrieveGrandSonFlexContainerResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveGrandSonFlexContainerResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveGrandSonFlexContainerResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve grandSonFlexContainer, expecting " + ResponseStatusCode.OK + ", found " + retrieveGrandSonFlexContainerResponse.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdGrandSonFlexContainer.getResourceID(), "xixi:xoxo", Operation.RETRIEVE)) {
            return;
        }
        this.unregisterInterworkingService(interworkingServiceRegistration);
        this.setState(Test.State.OK);
    }
}

