/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.AccessControl;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.AccessControlRule;
import org.eclipse.om2m.commons.resource.MgmtObj;
import org.eclipse.om2m.commons.resource.Node;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.SetOfAcrs;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.service.CseService;

public class CseUtil {
    private static final Log logger = LogFactory.getLog(CseUtil.class);
    static CseService cseService;

    public static ResponsePrimitive sendCreateApplicationEntityRequest(AE ae, String resourceLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceLocation);
        request.setOperation(Operation.CREATE);
        request.setResourceType(2);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setContent((Object)ae);
        return cseService.doRequest(request);
    }

    public static ResponsePrimitive sendUpdateApplicationAnncEntityRequest(AEAnnc aeAnnc, String resourceLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceLocation);
        request.setOperation(Operation.UPDATE);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setContent((Object)aeAnnc);
        return cseService.doRequest(request);
    }

    public static ResponsePrimitive sendCreateSubscriptionRequest(Subscription subscription, String resourceLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceLocation);
        request.setOperation(Operation.CREATE);
        request.setResourceType(23);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setContent((Object)subscription);
        return cseService.doRequest(request);
    }

    public static ResponsePrimitive sendCreateFlexContainerRequest(AbstractFlexContainer flexContainer, String resourceLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceLocation);
        request.setOperation(Operation.CREATE);
        request.setResourceType(28);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setContent((Object)flexContainer);
        return cseService.doRequest(request);
    }

    public static ResponsePrimitive sendUpdateFlexContainerRequest(AbstractFlexContainer flexContainer) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setOperation(Operation.UPDATE);
        request.setTo(flexContainer.getResourceID());
        request.setResourceType(28);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setContent((Object)flexContainer);
        return cseService.doRequest(request);
    }

    public static ResponsePrimitive sendCreateDefaultACP(String acpLocation, String acpName, List<String> labels) {
        AccessControlPolicy acp = new AccessControlPolicy();
        acp.setName(acpName);
        acp.getLabels().addAll(labels);
        SetOfAcrs setOfAcs = new SetOfAcrs();
        acp.setPrivileges(setOfAcs);
        AccessControlRule acr = new AccessControlRule();
        acr.setAccessControlOperations(AccessControl.ALL);
        acr.getAccessControlOriginators().add(Constants.ADMIN_REQUESTING_ENTITY);
        setOfAcs.getAccessControlRule().add(acr);
        acp.setSelfPrivileges(new SetOfAcrs());
        AccessControlRule acrSP = new AccessControlRule();
        acrSP.setAccessControlOperations(AccessControl.ALL);
        acrSP.getAccessControlOriginators().add(Constants.ADMIN_REQUESTING_ENTITY);
        acp.getSelfPrivileges().getAccessControlRule().add(acrSP);
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(acpLocation);
        request.setOperation(Operation.CREATE);
        request.setResourceType(1);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setContent((Object)acp);
        return cseService.doRequest(request);
    }

    public static ResponsePrimitive sendCreateNodeRequest(Node node, String baseLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(baseLocation);
        request.setOperation(Operation.CREATE);
        request.setResourceType(14);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setContent((Object)node);
        ResponsePrimitive resp = cseService.doRequest(request);
        if (!resp.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            return resp;
        }
        Node createdNode = (Node)resp.getContent();
        for (MgmtObj mgmtObj : node.getMgmtObjs()) {
            request = new RequestPrimitive();
            request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
            request.setTo(createdNode.getResourceID());
            request.setOperation(Operation.CREATE);
            request.setResourceType(13);
            request.setRequestContentType("application/obj");
            request.setReturnContentType("application/obj");
            request.setContent((Object)mgmtObj);
            cseService.doRequest(request);
        }
        return resp;
    }

    public static ResponsePrimitive sendInternalNotifyFlexContainerRequest(AbstractFlexContainer flexContainer, String resourceLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceLocation);
        request.setOperation(Operation.INTERNAL_NOTIFY);
        request.setRequestContentType("application/obj");
        request.setResourceType(28);
        request.setReturnContentType("application/obj");
        request.setContent((Object)flexContainer);
        return cseService.doRequest(request);
    }

    public static ResponsePrimitive sendRetrieveRequest(String uri) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(uri);
        request.setOperation(Operation.RETRIEVE);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        return cseService.doRequest(request);
    }

    public static ResponsePrimitive sendDeleteRequest(String resourceLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceLocation);
        request.setOperation(Operation.DELETE);
        return cseService.doRequest(request);
    }
}

