/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite;

import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.DiscoveryResultType;
import org.eclipse.om2m.commons.constants.FilterUsage;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.FilterCriteria;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.service.CseService;

public class CSEUtil {
    public static ResponsePrimitive retrieveEntity(CseService cseService, String flexContainerLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setOperation(Operation.RETRIEVE);
        request.setTo(flexContainerLocation);
        return cseService.doRequest(request);
    }

    public static ResponsePrimitive updateFlexContainerEntity(CseService cseService, String flexContainerLocation, AbstractFlexContainer flexContainer) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setOperation(Operation.UPDATE);
        request.setContent((Object)flexContainer);
        request.setTo(flexContainerLocation);
        return cseService.doRequest(request);
    }

    public static ResponsePrimitive discovery(CseService cseService, List<String> labels, String to) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setOperation(Operation.RETRIEVE);
        request.setDiscoveryResultType(DiscoveryResultType.HIERARCHICAL);
        FilterCriteria filterCriteria = new FilterCriteria();
        filterCriteria.getLabels().addAll(labels);
        filterCriteria.setFilterUsage(FilterUsage.DISCOVERY_CRITERIA);
        request.setFilterCriteria(filterCriteria);
        request.setTo(to);
        return cseService.doRequest(request);
    }

    public static ResponsePrimitive createSubscription(CseService cseService, Subscription subscription, String subscriptionLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setOperation(Operation.CREATE);
        request.setContent((Object)subscription);
        request.setTo(subscriptionLocation);
        request.setResourceType(23);
        return cseService.doRequest(request);
    }

    public static ResponsePrimitive deleteResource(CseService cseService, String resourceUrl) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setOperation(Operation.DELETE);
        request.setTo(resourceUrl);
        return cseService.doRequest(request);
    }
}

