/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.CustomAttributeEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.FlexContainer;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.commons.resource.flexcontainerspec.FlexContainerFactory;
import org.eclipse.om2m.core.entitymapper.ContainerMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;
import org.eclipse.om2m.core.flexcontainer.FlexContainerSelector;
import org.eclipse.om2m.flexcontainer.service.FlexContainerService;

public class FlexContainerMapper
extends EntityMapper<FlexContainerEntity, AbstractFlexContainer> {
    @Override
    protected AbstractFlexContainer createResource() {
        return new FlexContainer();
    }

    @Override
    protected AbstractFlexContainer createResource(FlexContainerEntity entity) {
        return FlexContainerFactory.getSpecializationFlexContainer((String)entity.getShortName());
    }

    @Override
    protected void mapAttributes(FlexContainerEntity entity, AbstractFlexContainer resource, int level, int offset) {
        if (level < 0) {
            return;
        }
        EntityMapperFactory.getAnnounceableSubordonateEntity_AnnounceableResourceMapper().mapAttributes((AnnounceableSubordinateEntity)entity, (AnnounceableResource)resource, level, offset);
        resource.setCreator(entity.getCreator());
        resource.setOntologyRef(entity.getOntologyRef());
        resource.setStateTag(entity.getStateTag());
        resource.setContainerDefinition(entity.getContainerDefinition());
        resource.setNodeLink(entity.getNodeLink());
        resource.setLongName(entity.getLongName());
        resource.setShortName(entity.getShortName());
        FlexContainerService fcs = FlexContainerSelector.getFlexContainerService(entity.getResourceID());
        if (fcs == null) {
            resource.getCustomAttributes().clear();
            for (CustomAttributeEntity cae : entity.getCustomAttributes()) {
                CustomAttribute ca = new CustomAttribute();
                ca.setShortName(cae.getName());
                ca.setType(cae.getType());
                ca.setValue(cae.getValue());
                resource.getCustomAttributes().add(ca);
            }
        } else {
            HashMap<String, CustomAttributeEntity> attributes = new HashMap<String, CustomAttributeEntity>();
            for (CustomAttributeEntity cae : entity.getCustomAttributes()) {
                attributes.put(cae.getName(), cae);
            }
            ArrayList names = new ArrayList(attributes.keySet());
            resource.getCustomAttributes().clear();
            for (Map.Entry entry : fcs.getCustomAttributeValues(names).entrySet()) {
                String name = (String)entry.getKey();
                CustomAttributeEntity cae = (CustomAttributeEntity)attributes.get(name);
                CustomAttribute ca = new CustomAttribute();
                ca.setShortName(name);
                ca.setType(cae.getType());
                ca.setValue((String)entry.getValue());
                resource.getCustomAttributes().add(ca);
            }
        }
    }

    @Override
    protected List<ChildResourceRef> getChildResourceRef(FlexContainerEntity entity, int level, int offset) {
        ChildResourceRef child;
        ArrayList<ChildResourceRef> childRefs = new ArrayList<ChildResourceRef>();
        if (level == 0) {
            return childRefs;
        }
        for (FlexContainerEntity fcnt : entity.getChildFlexContainers()) {
            child = new ChildResourceRef();
            child.setResourceName(fcnt.getName());
            child.setType(28);
            child.setValue(fcnt.getResourceID());
            child.setSpid(fcnt.getContainerDefinition());
            childRefs.add(child);
            childRefs.addAll(new FlexContainerMapper().getChildResourceRef(fcnt, level - 1, offset - 1));
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(23);
            child.setValue(sub.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new SubscriptionMapper().getChildResourceRef(sub, level - 1, offset - 1));
        }
        for (ContainerEntity childCont : entity.getChildContainers()) {
            child = new ChildResourceRef();
            child.setResourceName(childCont.getName());
            child.setType(3);
            child.setValue(childCont.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new ContainerMapper().getChildResourceRef(childCont, level - 1, offset - 1));
        }
        return childRefs;
    }

    @Override
    protected void mapChildResourceRef(FlexContainerEntity entity, AbstractFlexContainer resource, int level, int offset) {
        resource.getChildResource().addAll(this.getChildResourceRef(entity, level, offset));
    }

    @Override
    protected void mapChildResources(FlexContainerEntity entity, AbstractFlexContainer resource, int level, int offset) {
        if (level == 0) {
            return;
        }
        for (FlexContainerEntity cin : entity.getChildFlexContainers()) {
            AbstractFlexContainer flexContainerRes = (AbstractFlexContainer)new FlexContainerMapper().mapEntityToResource(cin, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getFlexContainerOrContainerOrSubscription().add(flexContainerRes);
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getFlexContainerOrContainerOrSubscription().add(subRes);
        }
        for (ContainerEntity childCont : entity.getChildContainers()) {
            Container cnt = (Container)new ContainerMapper().mapEntityToResource(childCont, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getFlexContainerOrContainerOrSubscription().add(cnt);
        }
        resource.finalizeSerialization();
    }
}

