/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.MappedSuperclass;
import org.eclipse.om2m.commons.entities.LabelEntity;

@MappedSuperclass
public class ResourceEntity {
    @Id
    @Column(name="ri")
    protected String resourceID;
    @Column(name="ty")
    protected BigInteger resourceType;
    @Column(name="pi")
    protected String parentID;
    @Column(name="ct")
    protected String creationTime;
    @Column(name="lt")
    protected String lastModifiedTime;
    @ManyToMany(targetEntity=LabelEntity.class, fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    protected List<LabelEntity> labelsEntities;
    @Column(name="rn")
    protected String name;
    @Column(name="huri")
    protected String hierarchicalURI;

    public BigInteger getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(BigInteger value) {
        this.resourceType = value;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String value) {
        this.resourceID = value;
    }

    public String getParentID() {
        return this.parentID;
    }

    public void setParentID(String value) {
        this.parentID = value;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(String value) {
        this.creationTime = value;
    }

    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(String value) {
        this.lastModifiedTime = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getHierarchicalURI() {
        return this.hierarchicalURI;
    }

    public void setHierarchicalURI(String hierarchicalURI) {
        this.hierarchicalURI = hierarchicalURI;
    }

    public List<LabelEntity> getLabelsEntities() {
        if (this.labelsEntities == null) {
            this.labelsEntities = new ArrayList<LabelEntity>();
        }
        return this.labelsEntities;
    }

    public void setLabelsEntities(List<LabelEntity> labelsEntities) {
        this.labelsEntities = labelsEntities;
    }

    public void setLabelsEntitiesFromSring(List<String> labelsStrings) {
        this.getLabelsEntities().clear();
        for (String s : labelsStrings) {
            boolean found = false;
            for (LabelEntity label : this.getLabelsEntities()) {
                if (!s.equals(label.getLabel())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.getLabelsEntities().add(new LabelEntity(s));
        }
    }

    public void setResourceType(int value) {
        this.resourceType = BigInteger.valueOf(value);
    }
}

