/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.utils.DateConverter;

public class Util {
    private Util() {
    }

    public static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block15: {
            BufferedReader br = null;
            sb = new StringBuilder();
            try {
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(is));
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                        sb.append("\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public static class DateUtil {
        private static final Log LOGGER = LogFactory.getLog(DateUtil.class);

        private DateUtil() {
        }

        public static String now() {
            String dateFormat = System.getProperty("org.eclipse.om2m.date.format", "yyyyMMdd'T'HHmmss");
            return new SimpleDateFormat(dateFormat).format(new Date()).toString();
        }

        public static boolean checkExpirationTime(String expirationTime) {
            String dateFormat = System.getProperty("org.eclipse.om2m.date.format", "yyyyMMdd'T'HHmmss");
            SimpleDateFormat df = new SimpleDateFormat(dateFormat);
            try {
                Date expDate = df.parse(expirationTime);
                return expDate.compareTo(new Date()) > 0;
            }
            catch (ParseException e) {
                LOGGER.error((Object)"Invalid XMLGregorianCalendar Format", (Throwable)e);
                return false;
            }
        }

        public static String getNewExpirationTime(long addedSeconds) {
            long addedMilSeconds = addedSeconds * 1000L;
            Date newDate = new Date(new Date().getTime() + addedMilSeconds);
            return DateConverter.toXMLGregorianCalendar(newDate).toString();
        }

        public static String getNewDelayTolerance(long addedSeconds) {
            long addedMilSeconds = addedSeconds * 1000L;
            Date newDate = new Date(new Date().getTime() + addedMilSeconds);
            return DateConverter.toXMLGregorianCalendar(newDate).toString();
        }

        public static String getDefaultExpirationTime() {
            String dateFormat = System.getProperty("org.eclipse.om2m.date.format", "yyyyMMdd'T'HHmmss");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(1, 1);
            return new SimpleDateFormat(dateFormat).format(cal.getTime());
        }
    }
}

