/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class AirQualitySensor
extends Module {
    private BooleanDataPoint monitoringEnabled;
    private IntegerDataPoint sensorPM1;
    private IntegerDataPoint sensorPM2;
    private IntegerDataPoint sensorPM10;
    private IntegerDataPoint sensorOdor;
    private IntegerDataPoint sensorHumidity;
    private IntegerDataPoint co2;
    private IntegerDataPoint co;
    private IntegerDataPoint ch2o;
    private IntegerDataPoint voc;

    public AirQualitySensor(String name, Domain domain) {
        super(name, domain, (Identifiers)ModuleType.airQualitySensor);
    }

    public AirQualitySensor(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain);
        IntegerDataPoint dp;
        BooleanDataPoint bdp = (BooleanDataPoint)dps.get(DatapointType.monitoringEnabled.getShortName());
        if (bdp != null) {
            this.setMonitoringEnabled(bdp);
        }
        if ((dp = (IntegerDataPoint)dps.get(DatapointType.sensorPM1.getShortName())) != null) {
            this.setSensorPM1(dp);
        }
        if ((dp = (IntegerDataPoint)dps.get(DatapointType.sensorPM2.getShortName())) != null) {
            this.setSensorPM2(dp);
        }
        if ((dp = (IntegerDataPoint)dps.get(DatapointType.sensorPM10.getShortName())) != null) {
            this.setSensorPM10(dp);
        }
        if ((dp = (IntegerDataPoint)dps.get(DatapointType.sensorOdor.getShortName())) != null) {
            this.setSensorOdor(dp);
        }
        if ((dp = (IntegerDataPoint)dps.get(DatapointType.sensorHumidity.getShortName())) != null) {
            this.setSensorHumidity(dp);
        }
        if ((dp = (IntegerDataPoint)dps.get(DatapointType.co.getShortName())) != null) {
            this.setCo(dp);
        }
        if ((dp = (IntegerDataPoint)dps.get(DatapointType.co2.getShortName())) != null) {
            this.setCo2(dp);
        }
        if ((dp = (IntegerDataPoint)dps.get(DatapointType.ch2o.getShortName())) != null) {
            this.setCh2o(dp);
        }
        if ((dp = (IntegerDataPoint)dps.get(DatapointType.voc.getShortName())) != null) {
            this.setVoc(dp);
        }
    }

    public void setMonitoringEnabled(BooleanDataPoint sv) {
        this.monitoringEnabled = sv;
        this.monitoringEnabled.setWritable(true);
        this.monitoringEnabled.setOptional(true);
        this.monitoringEnabled.setDoc("The current status of monitoring. \"True\" indicates enabled, and \"False\" indicates not enabled.");
        this.addDataPoint((DataPoint)this.monitoringEnabled);
    }

    public boolean getMonitoringEnabled() throws DataPointException, AccessException {
        if (this.monitoringEnabled == null) {
            throw new DataPointException("Not implemented");
        }
        return (Boolean)this.monitoringEnabled.getValue();
    }

    public void setMonitoringEnabled(boolean b) throws DataPointException, AccessException {
        if (this.monitoringEnabled == null) {
            throw new DataPointException("Not implemented");
        }
        this.monitoringEnabled.setValue((Object)b);
    }

    public void setSensorPM1(IntegerDataPoint sv) {
        this.sensorPM1 = sv;
        this.sensorPM1.setWritable(false);
        this.sensorPM1.setOptional(true);
        this.sensorPM1.setDoc("The concentration of particle matter under 1\u339b.. The minimum value is 0, and the maximum value is 1000.");
        this.addDataPoint((DataPoint)this.sensorPM1);
    }

    public int getSensorPM1() throws DataPointException, AccessException {
        if (this.sensorPM1 == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.sensorPM1.getValue();
    }

    public void setSensorPM2(IntegerDataPoint sv) {
        this.sensorPM2 = sv;
        this.sensorPM2.setWritable(false);
        this.sensorPM2.setOptional(true);
        this.sensorPM2.setDoc("The concentration of particle matter under 2.5\u339b. The minimum value is 0, and the maximum value is 1000.");
        this.addDataPoint((DataPoint)this.sensorPM2);
    }

    public int getSensorPM2() throws DataPointException, AccessException {
        if (this.sensorPM2 == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.sensorPM2.getValue();
    }

    public void setSensorPM10(IntegerDataPoint sv) {
        this.sensorPM10 = sv;
        this.sensorPM10.setWritable(false);
        this.sensorPM10.setOptional(true);
        this.sensorPM10.setDoc("The concentration of particle matter under 10\u339b. The minimum value is 0, and the maximum value is 1000.");
        this.addDataPoint((DataPoint)this.sensorPM10);
    }

    public int getSensorPM10() throws DataPointException, AccessException {
        if (this.sensorPM10 == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.sensorPM10.getValue();
    }

    public void setSensorOdor(IntegerDataPoint sv) {
        this.sensorOdor = sv;
        this.sensorOdor.setWritable(false);
        this.sensorOdor.setOptional(true);
        this.sensorOdor.setDoc("The concentration of odor that reflects air pollution. The minimum value is 0, and the maximum valu is 1000.");
        this.addDataPoint((DataPoint)this.sensorOdor);
    }

    public int getSensorOdor() throws DataPointException, AccessException {
        if (this.sensorOdor == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.sensorOdor.getValue();
    }

    public void setSensorHumidity(IntegerDataPoint sv) {
        this.sensorHumidity = sv;
        this.sensorHumidity.setWritable(false);
        this.sensorHumidity.setOptional(true);
        this.sensorHumidity.setDoc("The measured humidity. The minimum value is 0, and the maximum value is 100.");
        this.addDataPoint((DataPoint)this.sensorHumidity);
    }

    public int getSensorHumidity() throws DataPointException, AccessException {
        if (this.sensorHumidity == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.sensorHumidity.getValue();
    }

    public void setCo2(IntegerDataPoint sv) {
        this.co2 = sv;
        this.co2.setWritable(false);
        this.co2.setOptional(true);
        this.co2.setDoc("This value indicates the CO2 level in ppm (parts per million).");
        this.addDataPoint((DataPoint)this.co2);
    }

    public int getCo2() throws DataPointException, AccessException {
        if (this.co2 == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.co2.getValue();
    }

    public void setCo(IntegerDataPoint sv) {
        this.co = sv;
        this.co.setWritable(false);
        this.co.setOptional(true);
        this.co.setDoc("This value indicates the CO level in ppm.");
        this.addDataPoint((DataPoint)this.co);
    }

    public int getCo() throws DataPointException, AccessException {
        if (this.co == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.co.getValue();
    }

    public void setCh2o(IntegerDataPoint sv) {
        this.ch2o = sv;
        this.ch2o.setWritable(false);
        this.ch2o.setOptional(true);
        this.ch2o.setDoc("This value indicates the CH2O level in ppm.");
        this.addDataPoint((DataPoint)this.ch2o);
    }

    public int getCh2o() throws DataPointException, AccessException {
        if (this.ch2o == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.ch2o.getValue();
    }

    public void setVoc(IntegerDataPoint sv) {
        this.voc = sv;
        this.voc.setWritable(false);
        this.voc.setOptional(true);
        this.voc.setDoc("This value indicates the VOC (Volatile Organic Compounds) value in ppm.");
        this.addDataPoint((DataPoint)this.voc);
    }

    public int getVoc() throws DataPointException, AccessException {
        if (this.voc == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.voc.getValue();
    }
}

