/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.datapoints;

import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.types.DataType;
import org.eclipse.om2m.sdt.utils.Activator;

public abstract class ValuedDataPoint<T>
extends DataPoint {
    public ValuedDataPoint(Identifiers name, DataType type) {
        super(name, type);
    }

    public T getValue() throws DataPointException, AccessException {
        if (!this.isReadable()) {
            throw new DataPointException("Not readable");
        }
        if (!Activator.isGrantedReadAccess(this)) {
            throw new AccessException("No read access allowed");
        }
        return this.doGetValue();
    }

    public String toStringValue() throws DataPointException, AccessException, Exception {
        return this.getDataType().getTypeChoice().toString(this.getValue());
    }

    public void setValue(T value) throws DataPointException, AccessException {
        if (!this.isWritable()) {
            throw new DataPointException("Not writable");
        }
        if (!Activator.isGrantedWriteAccess(this)) {
            throw new AccessException("No write access allowed");
        }
        this.doSetValue(value);
    }

    protected abstract T doGetValue() throws DataPointException;

    protected void doSetValue(T value) throws DataPointException {
    }
}

