/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.hue.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.hue.api.Group;
import org.eclipse.om2m.hue.api.HueBridgeDevice;
import org.eclipse.om2m.hue.api.HueLightDevice;
import org.eclipse.om2m.hue.api.types.AlertMode;
import org.eclipse.om2m.hue.api.types.HueException;
import org.eclipse.om2m.hue.api.types.LightEffect;
import org.eclipse.om2m.hue.api.types.LightState;
import org.eclipse.om2m.hue.api.types.UnknownHueGatewayException;
import org.eclipse.om2m.hue.impl.HueDeviceImpl;
import org.eclipse.om2m.hue.impl.HueLightDeviceImpl;
import org.eclipse.om2m.hue.impl.PendingStateChangeRequest;
import org.eclipse.om2m.hue.impl.controller.Controller;
import org.eclipse.om2m.hue.impl.controller.Light;
import org.eclipse.om2m.hue.impl.controller.LightGroup;

public class HueBridgeDeviceImpl
extends HueDeviceImpl
implements HueBridgeDevice {
    private static Log Logger = LogFactory.getLog(HueBridgeDeviceImpl.class);
    private String location;
    private boolean controllerAvailable;
    private PendingStateChangeRequest request;
    private String userName;
    private Controller controller;
    private List<HueLightDevice> lights;

    public HueBridgeDeviceImpl(String location, String description, Optional<String> userId) {
        super(description);
        Logger.info((Object)("HueBridgeDeviceImpl installation. User name: " + userId.get()));
        this.location = location;
        this.lights = new ArrayList<HueLightDevice>();
        this.controllerAvailable = false;
        this.controller = null;
        this.userName = userId.get();
        String IP = "";
        try {
            IP = new URL((String)this.getProperties().get("UPnP.presentationURL")).getHost();
        }
        catch (MalformedURLException e) {
            Logger.warn((Object)"", (Throwable)e);
        }
        try {
            Logger.info((Object)("Connecting with Hue bridge at: " + IP));
            this.controller = new Controller(IP, this.userName);
            this.getLights();
            this.controllerAvailable = true;
            this.userName = this.controller.getUserName();
            if (this.request != null) {
                this.setStateToGroup(this.request.getLightState(), this.request.getRequestGroup());
            }
        }
        catch (HueException e) {
            Logger.warn((Object)"", (Throwable)e);
        }
        catch (UnknownHueGatewayException e) {
            Logger.warn((Object)"", (Throwable)e);
        }
        this.properties.put("export.api.Read", "getUDN,getLights");
        this.properties.put("export.api.Action", "setWakeUp,setMeal,setNight,setHomeCinema,setParty,setOn,setOff");
    }

    public String getUDN() {
        return (String)this.properties.get("UPnP.device.UDN");
    }

    public List<HueLightDevice> getLights() throws HueException, UnknownHueGatewayException {
        this.lights.clear();
        for (Light light : this.controller.getLights()) {
            if (!light.isReachable()) continue;
            this.lights.add(new HueLightDeviceImpl(this, light));
        }
        return this.lights;
    }

    public void setWakeUp(int group) throws HueException {
        LightState s = new LightState(true);
        s.setSat(0);
        s.setBri(100);
        s.setAlert(AlertMode.NONE);
        s.setEffect(LightEffect.NONE);
        this.setStateToGroup(s, group);
    }

    public void setMeal(int group) throws HueException {
        LightState s = new LightState(true);
        s.setSat(255);
        s.setBri(100);
        s.setHue(13000);
        s.setAlert(AlertMode.NONE);
        s.setEffect(LightEffect.NONE);
        this.setStateToGroup(s, group);
    }

    public void setNight(int group) throws HueException {
        LightState s = new LightState(false);
        s.setAlert(AlertMode.NONE);
        s.setEffect(LightEffect.NONE);
        this.setStateToGroup(s, group);
    }

    public void setHomeCinema(int group) throws HueException {
        LightState s = new LightState(true);
        s.setBri(10);
        s.setSat(255);
        s.setHue(63000);
        s.setEffect(LightEffect.NONE);
        s.setAlert(AlertMode.NONE);
        this.setStateToGroup(s, group);
    }

    public void setParty(int group) throws HueException {
        LightState s = new LightState(true);
        s.setBri(50);
        s.setSat(255);
        s.setEffect(LightEffect.COLORLOOP);
        s.setAlert(AlertMode.NONE);
        this.setStateToGroup(s, group);
    }

    public void setOnOff(int group, boolean on) throws HueException {
        LightState s = new LightState(on);
        if (on) {
            s.setBri(255);
            s.setSat(0);
        }
        s.setEffect(LightEffect.NONE);
        s.setAlert(AlertMode.NONE);
        this.setStateToGroup(s, group);
    }

    private void setStateToGroup(LightState state, int group) throws HueException {
        if (!this.controllerAvailable) {
            this.request = new PendingStateChangeRequest(group, state);
            return;
        }
        try {
            LightGroup lg;
            LightState offState = new LightState(false);
            offState.setEffect(LightEffect.NONE);
            offState.setAlert(AlertMode.NONE);
            LightGroup all = this.controller.getGroup(Group.getGroup((int)0));
            if (all != null) {
                all.setState(offState);
            }
            if ((lg = this.controller.getGroup(Group.getGroup((int)group))) != null) {
                lg.setState(state);
            }
            this.request = null;
        }
        catch (UnknownHueGatewayException unknownHueGatewayException) {
            this.request = new PendingStateChangeRequest(group, state);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isBridgeConnected() {
        return this.controllerAvailable;
    }

    public void stopPairingProcess() {
        this.controller.setPairWithBridge(false);
    }

    public String getUserName() {
        return this.userName;
    }
}

