/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.datapoints.StringDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class Barometer
extends Module {
    private FloatDataPoint atmosphericPressure;
    private StringDataPoint unit;
    private IntegerDataPoint minPressureThreshhold;
    private IntegerDataPoint maxPressureThreshhold;

    public Barometer(String name, Domain domain, FloatDataPoint atmosphericPressure) {
        super(name, domain, (Identifiers)ModuleType.barometer);
        if (atmosphericPressure == null || !atmosphericPressure.getShortName().equals(DatapointType.atmosphericPressure.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong atmosphericPressure datapoint: " + atmosphericPressure);
        }
        this.atmosphericPressure = atmosphericPressure;
        this.atmosphericPressure.setWritable(false);
        this.atmosphericPressure.getDataType().setUnitOfMeasure("Mbar");
        this.atmosphericPressure.setDoc("Current Atmospheric Pressure In Mbar");
        this.addDataPoint((DataPoint)this.atmosphericPressure);
    }

    public Barometer(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (FloatDataPoint)dps.get(DatapointType.atmosphericPressure.getShortName()));
        StringDataPoint sdp;
        IntegerDataPoint idp = (IntegerDataPoint)dps.get(DatapointType.minPressureThreshhold.getShortName());
        if (idp != null) {
            this.setMinPressureThreshhold(idp);
        }
        if ((idp = (IntegerDataPoint)dps.get(DatapointType.maxPressureThreshhold.getShortName())) != null) {
            this.setMaxPressureThreshhold(idp);
        }
        if ((sdp = (StringDataPoint)dps.get(DatapointType.unit.getShortName())) != null) {
            this.setUnit(sdp);
        }
    }

    public float getAtmosphericPressure() throws DataPointException, AccessException {
        return ((Float)this.atmosphericPressure.getValue()).floatValue();
    }

    private void setMinPressureThreshhold(IntegerDataPoint dp) {
        this.minPressureThreshhold = dp;
        this.minPressureThreshhold.setOptional(true);
        this.minPressureThreshhold.setWritable(true);
        this.minPressureThreshhold.setDoc("The min threshhold to trigger the alarm.");
        this.addDataPoint((DataPoint)this.minPressureThreshhold);
    }

    public int getMinPressureThreshhold() throws DataPointException, AccessException {
        if (this.minPressureThreshhold == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.minPressureThreshhold.getValue();
    }

    public void setMinPressureThreshhold(int v) throws DataPointException, AccessException {
        if (this.minPressureThreshhold == null) {
            throw new DataPointException("Not implemented");
        }
        this.minPressureThreshhold.setValue((Object)v);
    }

    private void setMaxPressureThreshhold(IntegerDataPoint dp) {
        this.maxPressureThreshhold = dp;
        this.maxPressureThreshhold.setOptional(true);
        this.maxPressureThreshhold.setWritable(true);
        this.maxPressureThreshhold.setDoc("The max threshhold to trigger the alarm.");
        this.addDataPoint((DataPoint)this.maxPressureThreshhold);
    }

    public int getMaxPressureThreshhold() throws DataPointException, AccessException {
        if (this.maxPressureThreshhold == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.maxPressureThreshhold.getValue();
    }

    public void setMaxPressureThreshhold(int v) throws DataPointException, AccessException {
        if (this.maxPressureThreshhold == null) {
            throw new DataPointException("Not implemented");
        }
        this.maxPressureThreshhold.setValue((Object)v);
    }

    private void setUnit(StringDataPoint dp) {
        this.unit = dp;
        this.unit.setOptional(true);
        this.unit.setWritable(false);
        this.unit.setDoc("The unit used for atmospheric pressure. The default unit is hectopascal (hPa).");
        this.addDataPoint((DataPoint)this.unit);
    }

    public String getUnit() throws DataPointException, AccessException {
        if (this.unit == null) {
            throw new DataPointException("Not implemented");
        }
        return (String)this.unit.getValue();
    }
}

