/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.devices;

import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.modules.BinarySwitch;
import org.eclipse.om2m.sdt.home.modules.Boiler;
import org.eclipse.om2m.sdt.home.modules.Clock;
import org.eclipse.om2m.sdt.home.modules.FaultDetection;
import org.eclipse.om2m.sdt.home.modules.HotWaterSupply;
import org.eclipse.om2m.sdt.home.modules.RunState;
import org.eclipse.om2m.sdt.home.types.DeviceType;

public class WaterHeater
extends GenericDevice {
    private FaultDetection faultDetection;
    private BinarySwitch binarySwitch;
    private RunState runState;
    private Clock clock;
    private Boiler boiler;
    private HotWaterSupply hotWaterSupply;

    public WaterHeater(String id, String serial, Domain domain) {
        super(id, serial, DeviceType.deviceWaterHeater, domain);
    }

    public void addModule(Module module) {
        if (module instanceof BinarySwitch) {
            this.addModule((BinarySwitch)module);
        } else if (module instanceof FaultDetection) {
            this.addModule((FaultDetection)module);
        } else if (module instanceof RunState) {
            this.addModule((RunState)module);
        } else if (module instanceof Clock) {
            this.addModule((Clock)module);
        } else if (module instanceof Boiler) {
            this.addModule((Boiler)module);
        } else if (module instanceof HotWaterSupply) {
            this.addModule((HotWaterSupply)module);
        } else {
            super.addModule(module);
        }
    }

    public void addModule(FaultDetection faultDetection) {
        this.faultDetection = faultDetection;
        super.addModule((Module)faultDetection);
    }

    public void addModule(BinarySwitch binarySwitch) {
        this.binarySwitch = binarySwitch;
        super.addModule((Module)binarySwitch);
    }

    public void addModule(RunState runState) {
        this.runState = runState;
        super.addModule((Module)runState);
    }

    public void addModule(Clock clock) {
        this.clock = clock;
        super.addModule((Module)clock);
    }

    public void addModule(Boiler boiler) {
        this.boiler = boiler;
        super.addModule((Module)boiler);
    }

    public void addModule(HotWaterSupply hotWaterSupply) {
        this.hotWaterSupply = hotWaterSupply;
        super.addModule((Module)hotWaterSupply);
    }

    public FaultDetection getFaultDetection() {
        return this.faultDetection;
    }

    public BinarySwitch getBinarySwitch() {
        return this.binarySwitch;
    }

    public RunState getRunState() {
        return this.runState;
    }

    public Clock getClock() {
        return this.clock;
    }

    public Boiler getBoiler() {
        return this.boiler;
    }

    public HotWaterSupply getHotWaterSupply() {
        return this.hotWaterSupply;
    }
}

