/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample;

import java.math.BigInteger;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.ipe.sample.controller.SampleController;

public class RequestSender {
    private RequestSender() {
    }

    public static ResponsePrimitive createResource(String targetId, Resource resource, int resourceType) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTargetId(targetId);
        request.setResourceType(BigInteger.valueOf(resourceType));
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setContent((Object)resource);
        request.setOperation(Operation.CREATE);
        return SampleController.CSE.doRequest(request);
    }

    public static ResponsePrimitive createAE(AE resource) {
        return RequestSender.createResource("/" + Constants.CSE_ID, (Resource)resource, 2);
    }

    public static ResponsePrimitive createContainer(String targetId, Container resource) {
        return RequestSender.createResource(targetId, (Resource)resource, 3);
    }

    public static ResponsePrimitive createContentInstance(String targetId, ContentInstance resource) {
        return RequestSender.createResource(targetId, (Resource)resource, 4);
    }

    public static ResponsePrimitive getRequest(String targetId) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTargetId(targetId);
        request.setReturnContentType("application/obj");
        request.setOperation(Operation.RETRIEVE);
        request.setRequestContentType("application/obj");
        return SampleController.CSE.doRequest(request);
    }
}

