/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.redirector;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.Om2mException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.comm.RestClient;
import org.eclipse.om2m.core.controller.AEController;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.interworking.IpeSelector;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class Redirector {
    private static Log LOGGER = LogFactory.getLog(Redirector.class);

    public static ResponsePrimitive retarget(RequestPrimitive request) {
        if (request.getTo() == null) {
            if (request.getTargetId() == null) {
                throw new BadRequestException("No To/TargetId parameter provided");
            }
            request.setTo(request.getTargetId());
        } else if (request.getTargetId() == null) {
            request.setTargetId(request.getTo());
        }
        String remoteCseId = "";
        ResponsePrimitive response = new ResponsePrimitive(request);
        try {
            remoteCseId = "/" + request.getTargetId().split("/")[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.debug((Object)"Remote cse not found", (Throwable)e);
            throw new ResourceNotFoundException("Remote cse not found", (Throwable)e);
        }
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        DAO dao = dbs.getDAOFactory().getRemoteCSEbyCseIdDAO();
        RemoteCSEEntity csrEntity = (RemoteCSEEntity)dao.find(transaction, (Object)remoteCseId);
        if (csrEntity != null) {
            LOGGER.info((Object)("RemoteCSE found: " + csrEntity.getRemoteCseId()));
            response = Redirector.sendRedirectorRequest(request, csrEntity, transaction);
        } else {
            if (!Constants.CSE_TYPE.equalsIgnoreCase("in-cse")) {
                LOGGER.info((Object)("Unknow CSE, sending request to registrar CSE: " + Constants.REMOTE_CSE_ID));
                csrEntity = (RemoteCSEEntity)dao.find(transaction, (Object)("/" + Constants.REMOTE_CSE_ID));
                if (csrEntity != null) {
                    response = Redirector.sendRedirectorRequest(request, csrEntity, transaction);
                }
            }
            if (response == null) {
                throw new ResourceNotFoundException("RemoteCse with cseId " + remoteCseId + " has not been found");
            }
        }
        transaction.close();
        return response;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ResponsePrimitive sendRedirectorRequest(RequestPrimitive request, RemoteCSEEntity csrEntity, DBTransaction transaction) {
        if (!csrEntity.isRequestReachability()) {
            throw new Om2mException("Remote Cse is not request reachable", ResponseStatusCode.TARGET_NOT_REACHABLE);
        }
        DBService dbs = PersistenceService.getInstance().getDbService();
        String url = "";
        if (csrEntity.getPointOfAccess().isEmpty()) {
            throw new Om2mException("The point of access parameter is missing", ResponseStatusCode.TARGET_NOT_REACHABLE);
        }
        boolean done = false;
        int i = 0;
        while (!done & i < csrEntity.getPointOfAccess().size()) {
            ResponsePrimitive response;
            block13: {
                url = (String)csrEntity.getPointOfAccess().get(i);
                if (url.endsWith("/")) {
                    LOGGER.debug((Object)("Removing / at the end of poa: " + url));
                    url = url.substring(0, url.length() - 1);
                }
                if (url.startsWith("mqtt://")) {
                    url = String.valueOf(url) + request.getTo();
                    Pattern mqttUriPattern = Pattern.compile("(mqtt://[^:/]*(:[0-9]{1,5})?)(/.*)");
                    Matcher matcher = mqttUriPattern.matcher(url);
                    if (matcher.matches()) {
                        request.setMqttResponseExpected(true);
                        request.setMqttTopic("/oneM2M/req/" + Constants.CSE_ID + "/" + csrEntity.getRemoteCseId().replaceAll("/", "") + "/xml");
                        request.setMqttUri(matcher.group(1));
                        break block13;
                    } else {
                        LOGGER.warn((Object)("Incorrect MQTT URI specified in remoteCSE: " + url));
                        ++i;
                        continue;
                    }
                }
                url = request.getTo().startsWith("//") ? String.valueOf(url) + request.getTo().replaceFirst("//", "/_/") : (request.getTo().startsWith("/") ? String.valueOf(url) + request.getTo().replaceFirst("/", "/~/") : String.valueOf(url) + "/" + request.getTo());
            }
            request.setTo(url);
            String initialRequestContentType = request.getRequestContentType();
            String initialReturnContentType = request.getReturnContentType();
            if ("application/obj".equals(initialRequestContentType)) {
                request.setRequestContentType("application/xml");
                if (Operation.CREATE.equals(request.getOperation()) || Operation.UPDATE.equals(request.getOperation())) {
                    String xmlPayload = DataMapperSelector.getDataMapperList().get("application/xml").objToString(request.getContent());
                    request.setContent((Object)xmlPayload);
                }
            }
            if ("application/obj".equals(initialReturnContentType)) {
                request.setReturnContentType("application/xml");
            }
            if (!(response = RestClient.sendRequest(request)).getResponseStatusCode().equals(ResponseStatusCode.TARGET_NOT_REACHABLE)) {
                done = true;
                if (i > 0) {
                    String poa = (String)csrEntity.getPointOfAccess().get(i);
                    csrEntity.getPointOfAccess().remove(i);
                    csrEntity.getPointOfAccess().add(0, poa);
                    dbs.getDAOFactory().getRemoteCSEDAO().update(transaction, (Object)csrEntity);
                    transaction.commit();
                }
                if (response.getContent() != null && "application/obj".equals(initialReturnContentType)) {
                    Object resource = DataMapperSelector.getDataMapperList().get("application/xml").stringToObj((String)response.getContent());
                    response.setContent(resource);
                }
                return response;
            }
            ++i;
        }
        ResponsePrimitive response = new ResponsePrimitive(request);
        response.setResponseStatusCode(ResponseStatusCode.TARGET_NOT_REACHABLE);
        response.setContent((Object)"Target is not reachable");
        response.setContentType("text/plain");
        return response;
    }

    public static ResponsePrimitive retargetNotify(RequestPrimitive request) {
        if (request.getTo() == null) {
            if (request.getTargetId() == null) {
                throw new BadRequestException("No To/TargetId parameter provided");
            }
            request.setTo(request.getTargetId());
        } else if (request.getTargetId() == null) {
            request.setTargetId(request.getTo());
        }
        ResponsePrimitive response = new ResponsePrimitive(request);
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction dbt = dbs.getDbTransaction();
        dbt.open();
        AeEntity ae = (AeEntity)dbs.getDAOFactory().getAeDAO().find(dbt, (Object)request.getTargetId());
        if (ae == null) {
            dbt.close();
            throw new ResourceNotFoundException("AE resource " + request.getTargetId() + " not found.");
        }
        if (!request.getFrom().equals("/" + Constants.CSE_ID)) {
            new AEController().checkACP(ae.getAccessControlPolicies(), request.getFrom(), Operation.NOTIFY);
        }
        if (ae.getPointOfAccess().isEmpty() || !ae.isRequestReachability()) {
            throw new Om2mException("AE has no point of access", ResponseStatusCode.TARGET_NOT_REACHABLE);
        }
        boolean done = false;
        int i = 0;
        while (!done && i < ae.getPointOfAccess().size()) {
            String poa = (String)ae.getPointOfAccess().get(i);
            if (IpeSelector.getInterworkingList().containsKey(poa)) {
                try {
                    LOGGER.info((Object)("Sending notification to IPE: " + poa));
                    response = IpeSelector.getInterworkingList().get(poa).doExecute(request);
                }
                catch (Om2mException om2mE) {
                    LOGGER.info((Object)("Om2m exception caught in Redirector: " + om2mE.getMessage()));
                    throw om2mE;
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Exception caught in IPE execution", (Throwable)e);
                    throw new Om2mException("IPE Internal Error", (Throwable)e, ResponseStatusCode.INTERNAL_SERVER_ERROR);
                }
                done = true;
            } else {
                request.setTo(poa);
                if (poa.startsWith("mqtt://")) {
                    Pattern mqttUriPattern = Pattern.compile("(mqtt://[^:/]*(:[0-9]{1,5})?)(/.*)?");
                    Matcher matcher = mqttUriPattern.matcher(poa);
                    if (matcher.matches()) {
                        String topic = matcher.group(3);
                        String aeId = ae.getAeid();
                        if (topic != null) {
                            request.setMqttTopic(topic);
                            request.setMqttResponseExpected(false);
                        } else {
                            request.setMqttTopic("/oneM2M/req/" + Constants.CSE_ID + "/" + aeId + "/xml");
                            request.setMqttResponseExpected(true);
                        }
                        request.setMqttUri(matcher.group(1));
                    } else {
                        LOGGER.warn((Object)("POA is incorrect for MQTT: " + poa));
                        ++i;
                        continue;
                    }
                }
                if (!(response = RestClient.sendRequest(request)).getResponseStatusCode().equals(ResponseStatusCode.TARGET_NOT_REACHABLE)) {
                    done = true;
                    if (i > 0) {
                        ae.getPointOfAccess().remove(i);
                        ae.getPointOfAccess().add(0, poa);
                        dbs.getDAOFactory().getAeDAO().update(dbt, (Object)ae);
                        dbt.commit();
                    }
                }
            }
            ++i;
        }
        dbt.close();
        return response;
    }
}

