/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.ae;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.constants.SecurityInfoType;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AccessControlRule;
import org.eclipse.om2m.commons.resource.DynAuthDasRequest;
import org.eclipse.om2m.commons.resource.DynAuthDasResponse;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.SecurityInfo;
import org.eclipse.om2m.commons.resource.SetOfAcrs;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Activator;
import org.eclipse.om2m.das.testsuite.Test;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractDASServiceTest
extends Test
implements InterworkingService {
    private String poa;
    private int expectedNumberOfCall = 1;
    private List<Call> calls = new ArrayList<Call>();
    private List<ServiceRegistration<InterworkingService>> registeredInterworkingServices = new ArrayList<ServiceRegistration<InterworkingService>>();
    private AE dasAe;

    protected AbstractDASServiceTest(String pName, CseService pCseService) {
        super(pName, pCseService);
        this.createDasAE();
    }

    @Override
    public abstract void performTest();

    @Override
    public void cleanUp() {
        for (ServiceRegistration<InterworkingService> sr : this.registeredInterworkingServices) {
            this.unregisterInterworkingService(sr);
        }
        this.deleteDasAE();
    }

    public String getAPOCPath() {
        return (String)this.dasAe.getPointOfAccess().get(0);
    }

    public ResponsePrimitive doExecute(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        if (!Operation.NOTIFY.equals(request.getOperation())) {
            response.setResponseStatusCode(ResponseStatusCode.OPERATION_NOT_ALLOWED);
            return response;
        }
        SecurityInfo securityInfo = null;
        try {
            securityInfo = (SecurityInfo)request.getContent();
            if (securityInfo == null) {
                response.setResponseStatusCode(ResponseStatusCode.CONTENTS_UNACCEPTABLE);
                return response;
            }
        }
        catch (ClassCastException e) {
            response.setResponseStatusCode(ResponseStatusCode.CONTENTS_UNACCEPTABLE);
            return response;
        }
        if (!SecurityInfoType.DYNAMIC_AUTHORIZATION_REQUEST.equals(securityInfo.getSecurityInfoType())) {
            response.setResponseStatusCode(ResponseStatusCode.CONTENTS_UNACCEPTABLE);
            return response;
        }
        DynAuthDasRequest dasRequest = securityInfo.getDasRequest();
        if (dasRequest == null) {
            response.setResponseStatusCode(ResponseStatusCode.ACCESS_DENIED);
            return response;
        }
        int nbCall = this.getNumberOfCall();
        Call call = new Call(dasRequest);
        this.addCall(call);
        if (nbCall > this.expectedNumberOfCall) {
            response.setResponseStatusCode(ResponseStatusCode.ACCESS_DENIED);
            return response;
        }
        SecurityInfo responseSecurityInfo = new SecurityInfo();
        responseSecurityInfo.setSecurityInfoType(SecurityInfoType.DYNAMIC_AUTHORIZATION_RESPONSE);
        responseSecurityInfo.setDasResponse(new DynAuthDasResponse());
        responseSecurityInfo.getDasResponse().setDynamicACPInfo(new DynAuthDasResponse.DynamicACPInfo());
        responseSecurityInfo.getDasResponse().getDynamicACPInfo().setGrantedPrivileges(new SetOfAcrs());
        AccessControlRule acr = new AccessControlRule();
        acr.setAccessControlOperations(dasRequest.getOperation());
        acr.getAccessControlOriginators().add(dasRequest.getOriginator());
        responseSecurityInfo.getDasResponse().getDynamicACPInfo().getGrantedPrivileges().getAccessControlRule().add(acr);
        response.setContent((Object)responseSecurityInfo);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumberOfCall() {
        int nbOfCall = 0;
        List<Call> list = this.calls;
        synchronized (list) {
            nbOfCall = this.calls.size();
        }
        return nbOfCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCall(Call call) {
        List<Call> list = this.calls;
        synchronized (list) {
            this.calls.add(call);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCalls() {
        List<Call> list = this.calls;
        synchronized (list) {
            this.calls.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Call> getCalls() {
        ArrayList<Call> toBeReturned = new ArrayList<Call>();
        List<Call> list = this.calls;
        synchronized (list) {
            toBeReturned.addAll(this.calls);
        }
        return toBeReturned;
    }

    protected boolean checkCall(int callIndex, String expectedResourceId, String expectedFrom, BigInteger expectedOperation) {
        if (this.getNumberOfCall() != this.getExpectedNumberOfCall()) {
            this.setMessage("expect 1 call, found " + this.getNumberOfCall());
            this.setState(Test.State.KO);
            return false;
        }
        List<Call> receivedCalls = this.getCalls();
        Call call = receivedCalls.get(callIndex);
        if (call.getDynAuthRequest() == null) {
            this.setMessage("request is null");
            this.setState(Test.State.KO);
            return false;
        }
        if (!call.getDynAuthRequest().getTargetedResourceID().equals(expectedResourceId)) {
            this.setState(Test.State.KO);
            this.setMessage("bad targetId, expecting " + expectedResourceId + ", found " + call.getDynAuthRequest().getTargetedResourceID());
            return false;
        }
        if (!call.getDynAuthRequest().getOriginator().equals(expectedFrom)) {
            this.setState(Test.State.KO);
            this.setMessage("bad caller credentials, expecting:" + expectedFrom + ", found " + call.getDynAuthRequest().getOriginator());
            return false;
        }
        if (!expectedOperation.equals(call.getDynAuthRequest().getOperation())) {
            this.setState(Test.State.KO);
            this.setMessage("bad operation, expecting:" + Operation.RETRIEVE + ", found " + call.getDynAuthRequest().getOperation());
            return false;
        }
        if (call.getDynAuthRequest().getTargetedResourceID() == null) {
            this.setState(Test.State.KO);
            this.setMessage("resourceEntity is null");
            return false;
        }
        if (!expectedResourceId.equals(call.getDynAuthRequest().getTargetedResourceID())) {
            this.setState(Test.State.KO);
            this.setMessage("bad resourceEntity id, expecting " + expectedResourceId + ", found:" + call.getDynAuthRequest().getTargetedResourceID());
            return false;
        }
        return true;
    }

    protected int getExpectedNumberOfCall() {
        return this.expectedNumberOfCall;
    }

    protected void setExpectedNumberOfCall(int expectedNumberOfCall) {
        this.expectedNumberOfCall = expectedNumberOfCall;
    }

    protected ServiceRegistration<InterworkingService> registerInterworkingService(InterworkingService service) {
        ServiceRegistration sr = Activator.getBundleContext().registerService(InterworkingService.class, (Object)service, null);
        return sr;
    }

    protected void unregisterInterworkingService(ServiceRegistration<InterworkingService> serviceRegistration) {
        if (serviceRegistration != null) {
            try {
                serviceRegistration.unregister();
                serviceRegistration = null;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.registeredInterworkingServices.remove(serviceRegistration);
        }
    }

    private void createDasAE() {
        if (this.dasAe == null) {
            this.dasAe = this.createAe();
        }
    }

    private void deleteDasAE() {
        if (this.dasAe != null) {
            this.deleteEntity(this.dasAe.getResourceID());
            this.dasAe = null;
        }
    }

    protected AE getDasAE() {
        return this.dasAe;
    }

    protected class Call {
        private final DynAuthDasRequest requestPrimitive;

        public Call(DynAuthDasRequest pRequest) {
            this.requestPrimitive = pRequest;
        }

        public DynAuthDasRequest getDynAuthRequest() {
            return this.requestPrimitive;
        }
    }
}

