/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.DeviceLightFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class LightDeviceFlexContainerTest
extends FlexContainerTestSuite {
    public LightDeviceFlexContainerTest(CseService pCseService) {
        super(pCseService);
    }

    @Override
    protected String getTestSuiteName() {
        return "LightDeviceFlexContainerTest";
    }

    public void testCreateAndRetrieveLightDevice() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "LightDeviceFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        DeviceLightFlexContainer flexContainer = new DeviceLightFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OntologyRef");
        CustomAttribute serialNumberCA = new CustomAttribute();
        serialNumberCA.setCustomAttributeName("pDSNm");
        serialNumberCA.setCustomAttributeValue("sn1");
        flexContainer.getCustomAttributes().add(serialNumberCA);
        CustomAttribute locationCA = new CustomAttribute();
        locationCA.setCustomAttributeName("proLn");
        locationCA.setCustomAttributeValue("kitchen");
        flexContainer.getCustomAttributes().add(locationCA);
        CustomAttribute deviceManufacturerCA = new CustomAttribute();
        deviceManufacturerCA.setCustomAttributeName("prDMr");
        deviceManufacturerCA.setCustomAttributeValue("Orange");
        flexContainer.getCustomAttributes().add(deviceManufacturerCA);
        CustomAttribute protocolCA = new CustomAttribute();
        protocolCA.setCustomAttributeName("proPl");
        protocolCA.setCustomAttributeValue("ZigBee");
        flexContainer.getCustomAttributes().add(protocolCA);
        CustomAttribute deviceModelCA = new CustomAttribute();
        deviceModelCA.setCustomAttributeName("pDMNe");
        deviceModelCA.setCustomAttributeValue("Model1");
        flexContainer.getCustomAttributes().add(deviceModelCA);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        DeviceLightFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateAndRetrieveLightDevice", TestReport.Status.KO, "unable to create LightDevice FlexContainer:" + response.getContent(), null);
            return;
        }
        createdFlexContainer = (DeviceLightFlexContainer)response.getContent();
        if (!flexContainerName.equals(createdFlexContainer.getName())) {
            this.createTestReport("testCreateAndRetrieveLightDevice", TestReport.Status.KO, "invalid name.Expecting: " + flexContainerName + ", found:" + createdFlexContainer.getName(), null);
            return;
        }
        try {
            this.checkFlexContainerCreator((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerCustomAttribute((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerDefinition((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerOntologyRef((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveLightDevice", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testCreateAndRetrieveLightDevice", TestReport.Status.KO, "unable to retrieve LightDevice FlexContainer:" + response.getContent(), null);
            return;
        }
        DeviceLightFlexContainer retrievedFlexContainer = (DeviceLightFlexContainer)response.getContent();
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveLightDevice", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        this.createTestReport("testCreateAndRetrieveLightDevice", TestReport.Status.OK, null, null);
    }

    public void testDeleteLightDeviceFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "LightDeviceFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        DeviceLightFlexContainer flexContainer = new DeviceLightFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OntologyRef");
        CustomAttribute serialNumberCA = new CustomAttribute();
        serialNumberCA.setCustomAttributeName("pDSNm");
        serialNumberCA.setCustomAttributeValue("sn1");
        flexContainer.getCustomAttributes().add(serialNumberCA);
        CustomAttribute locationCA = new CustomAttribute();
        locationCA.setCustomAttributeName("proLn");
        locationCA.setCustomAttributeValue("kitchen");
        flexContainer.getCustomAttributes().add(locationCA);
        CustomAttribute deviceManufacturerCA = new CustomAttribute();
        deviceManufacturerCA.setCustomAttributeName("prDMr");
        deviceManufacturerCA.setCustomAttributeValue("Orange");
        flexContainer.getCustomAttributes().add(deviceManufacturerCA);
        CustomAttribute protocolCA = new CustomAttribute();
        protocolCA.setCustomAttributeName("proPl");
        protocolCA.setCustomAttributeValue("ZigBee");
        flexContainer.getCustomAttributes().add(protocolCA);
        CustomAttribute deviceModelCA = new CustomAttribute();
        deviceModelCA.setCustomAttributeName("pDMNe");
        deviceModelCA.setCustomAttributeValue("Model1");
        flexContainer.getCustomAttributes().add(deviceModelCA);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testDeleteLightDeviceFlexContainer", TestReport.Status.KO, "unable to create LightDevice FlexContainer:" + response.getContent(), null);
            return;
        }
        response = this.sendDeleteRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
            this.createTestReport("testDeleteLightDeviceFlexContainer", TestReport.Status.KO, "unable to delete LightDevice FlexContainer:" + response.getContent(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.NOT_FOUND)) {
            this.createTestReport("testDeleteLightDeviceFlexContainer", TestReport.Status.KO, "Expecting:" + ResponseStatusCode.NOT_FOUND + ", received:" + response.getResponseStatusCode(), null);
            return;
        }
        this.createTestReport("testDeleteLightDeviceFlexContainer", TestReport.Status.OK, null, null);
    }
}

