/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class EnergyConsumption
extends Module {
    private FloatDataPoint power;
    private IntegerDataPoint roundingEnergyConsumption;
    private IntegerDataPoint significantDigits;
    private FloatDataPoint absoluteEnergyConsumption;
    private FloatDataPoint voltage;
    private FloatDataPoint current;
    private FloatDataPoint frequency;
    private IntegerDataPoint multiplyingFactors;

    public EnergyConsumption(String name, Domain domain, FloatDataPoint power) {
        super(name, domain, (Identifiers)ModuleType.energyConsumption);
        if (power == null || !power.getShortDefinitionType().equals(DatapointType.power.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong power datapoint: " + power);
        }
        this.power = power;
        this.power.setWritable(false);
        this.power.setDoc("The power of the device; The common unit is Watt (W).");
        this.addDataPoint((DataPoint)this.power);
    }

    public EnergyConsumption(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (FloatDataPoint)dps.get(DatapointType.power.getShortName()));
        FloatDataPoint frequency;
        FloatDataPoint current;
        FloatDataPoint voltage;
        FloatDataPoint absoluteEnergyConsumption;
        IntegerDataPoint multiplyingFactors;
        IntegerDataPoint significantDigits;
        IntegerDataPoint roundingEnergyConsumption = (IntegerDataPoint)dps.get(DatapointType.roundingEnergyConsumption.getShortName());
        if (roundingEnergyConsumption != null) {
            this.setRoundingEnergyConsumption(roundingEnergyConsumption);
        }
        if ((significantDigits = (IntegerDataPoint)dps.get(DatapointType.significantDigits.getShortName())) != null) {
            this.setSignificantDigits(significantDigits);
        }
        if ((multiplyingFactors = (IntegerDataPoint)dps.get(DatapointType.multiplyingFactors.getShortName())) != null) {
            this.setMultiplyingFactors(multiplyingFactors);
        }
        if ((absoluteEnergyConsumption = (FloatDataPoint)dps.get(DatapointType.absoluteEnergyConsumption.getShortName())) != null) {
            this.setAbsoluteEnergyConsumption(absoluteEnergyConsumption);
        }
        if ((voltage = (FloatDataPoint)dps.get(DatapointType.voltage.getShortName())) != null) {
            this.setVoltage(voltage);
        }
        if ((current = (FloatDataPoint)dps.get(DatapointType.current.getShortName())) != null) {
            this.setCurrent(current);
        }
        if ((frequency = (FloatDataPoint)dps.get(DatapointType.frequency.getShortName())) != null) {
            this.setFrequency(frequency);
        }
    }

    public float getPower() throws DataPointException, AccessException {
        return ((Float)this.power.getValue()).floatValue();
    }

    public void setMultiplyingFactors(IntegerDataPoint dp) {
        this.multiplyingFactors = dp;
        this.multiplyingFactors.setOptional(true);
        this.multiplyingFactors.setWritable(true);
        this.multiplyingFactors.setDoc("The unit for data (multiplying factors) Ex. 1kWh, 0.1kWh, 0.01kWh etc.");
        this.addDataPoint((DataPoint)this.multiplyingFactors);
    }

    public Integer getMultiplyingFactors() throws DataPointException, AccessException {
        if (this.multiplyingFactors == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.multiplyingFactors.getValue();
    }

    public void setMultiplyingFactors(Integer s) throws DataPointException, AccessException {
        if (this.multiplyingFactors == null) {
            throw new DataPointException("Not implemented");
        }
        this.multiplyingFactors.setValue((Object)s);
    }

    public void setAbsoluteEnergyConsumption(FloatDataPoint dp) {
        this.absoluteEnergyConsumption = dp;
        this.absoluteEnergyConsumption.setOptional(true);
        this.absoluteEnergyConsumption.setWritable(false);
        this.absoluteEnergyConsumption.setDoc("The absolute energy consumption, reflecting the real measurement of accumulative energy; The common unit is Watt-hour (Wh).");
        this.addDataPoint((DataPoint)this.absoluteEnergyConsumption);
    }

    public float getAbsoluteEnergyConsumption() throws DataPointException, AccessException {
        if (this.absoluteEnergyConsumption == null) {
            throw new DataPointException("Not implemented");
        }
        return ((Float)this.absoluteEnergyConsumption.getValue()).floatValue();
    }

    public void setVoltage(FloatDataPoint dp) {
        this.voltage = dp;
        this.voltage.setOptional(true);
        this.voltage.setWritable(false);
        this.voltage.setDoc("The voltage of the device; The common unit is Voltage (V).");
        this.addDataPoint((DataPoint)this.voltage);
    }

    public float getVoltage() throws DataPointException, AccessException {
        if (this.voltage == null) {
            throw new DataPointException("Not implemented");
        }
        return ((Float)this.voltage.getValue()).floatValue();
    }

    public void setCurrent(FloatDataPoint dp) {
        this.current = dp;
        this.current.setOptional(true);
        this.current.setWritable(false);
        this.current.setDoc("The current of the device; The common unit is Current (A).");
        this.addDataPoint((DataPoint)this.current);
    }

    public float getCurrent() throws DataPointException, AccessException {
        if (this.current == null) {
            throw new DataPointException("Not implemented");
        }
        return ((Float)this.current.getValue()).floatValue();
    }

    public void setFrequency(FloatDataPoint dp) {
        this.frequency = dp;
        this.frequency.setOptional(true);
        this.frequency.setWritable(false);
        this.frequency.setDoc("The frequency of the device; The common unit is Hertz (Hz).");
        this.addDataPoint((DataPoint)this.frequency);
    }

    public float getFrequency() throws DataPointException, AccessException {
        if (this.frequency == null) {
            throw new DataPointException("Not implemented");
        }
        return ((Float)this.current.getValue()).floatValue();
    }

    public void setRoundingEnergyConsumption(IntegerDataPoint dp) {
        this.roundingEnergyConsumption = dp;
        this.roundingEnergyConsumption.setOptional(true);
        this.roundingEnergyConsumption.setWritable(false);
        this.roundingEnergyConsumption.setDoc("This energy consumption data can be calculated by using significantDigits and units.");
        this.addDataPoint((DataPoint)this.roundingEnergyConsumption);
    }

    public int getRoundingEnergyConsumption() throws DataPointException, AccessException {
        if (this.roundingEnergyConsumption == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.roundingEnergyConsumption.getValue();
    }

    public void setSignificantDigits(IntegerDataPoint dp) {
        this.significantDigits = dp;
        this.significantDigits.setOptional(true);
        this.significantDigits.setWritable(true);
        this.significantDigits.setDoc("The number of effective digits for data.");
        this.addDataPoint((DataPoint)this.significantDigits);
    }

    public int getSignificantDigits() throws DataPointException, AccessException {
        if (this.significantDigits == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.significantDigits.getValue();
    }

    public void setSignificantDigits(int b) throws DataPointException, AccessException {
        if (this.significantDigits == null) {
            throw new DataPointException("Not implemented");
        }
        if (b < 0) {
            throw new DataPointException("Negative value");
        }
        this.significantDigits.setValue((Object)b);
    }
}

