/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.PollingChannelEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ScheduleEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.PollingChannel;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.AcpMapper;
import org.eclipse.om2m.core.entitymapper.AeMapper;
import org.eclipse.om2m.core.entitymapper.ContainerMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.GroupMapper;
import org.eclipse.om2m.core.entitymapper.PollingChannelMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class RemoteCSEMapper
extends EntityMapper<RemoteCSEEntity, RemoteCSE> {
    @Override
    protected RemoteCSE createResource() {
        return new RemoteCSE();
    }

    @Override
    protected void mapAttributes(RemoteCSEEntity csrEntity, RemoteCSE csr) {
        csr.setCSEBase(csrEntity.getRemoteCseUri());
        csr.setCSEID(csrEntity.getRemoteCseId());
        csr.setCseType(csrEntity.getCseType());
        csr.setExpirationTime(csrEntity.getExpirationTime());
        csr.setM2MExtID(csrEntity.getM2mExtId());
        csr.setNodeLink(csrEntity.getNodeLink());
        csr.setRequestReachability(Boolean.valueOf(csrEntity.isRequestReachability()));
        csr.setTriggerRecipientID(csrEntity.getTriggerRecipientID());
        if (!csrEntity.getAnnouncedAttribute().isEmpty()) {
            csr.getAnnouncedAttribute().addAll(csrEntity.getAnnouncedAttribute());
        }
        if (!csrEntity.getAnnounceTo().isEmpty()) {
            csr.getAnnounceTo().addAll(csrEntity.getAnnounceTo());
        }
        if (!csrEntity.getPointOfAccess().isEmpty()) {
            csr.getPointOfAccess().addAll(csrEntity.getPointOfAccess());
        }
        for (AccessControlPolicyEntity acp : csrEntity.getAccessControlPolicies()) {
            csr.getAccessControlPolicyIDs().add(acp.getResourceID());
        }
    }

    @Override
    protected void mapChildResourceRef(RemoteCSEEntity csrEntity, RemoteCSE csr) {
        ChildResourceRef child;
        for (SubscriptionEntity sub : csrEntity.getSubscriptions()) {
            child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(23);
            child.setValue(sub.getResourceID());
            csr.getChildResource().add(child);
        }
        for (AeEntity ae : csrEntity.getChildAes()) {
            child = new ChildResourceRef();
            child.setResourceName(ae.getName());
            child.setType(2);
            child.setValue(ae.getResourceID());
            csr.getChildResource().add(child);
        }
        for (AccessControlPolicyEntity acp : csrEntity.getChildAcps()) {
            child = new ChildResourceRef();
            child.setResourceName(acp.getName());
            child.setType(1);
            child.setValue(acp.getResourceID());
            csr.getChildResource().add(child);
        }
        for (ContainerEntity container : csrEntity.getChildCnt()) {
            child = new ChildResourceRef();
            child.setResourceName(container.getName());
            child.setType(3);
            child.setValue(container.getResourceID());
            csr.getChildResource().add(child);
        }
        for (GroupEntity group : csrEntity.getChildGrps()) {
            child = new ChildResourceRef();
            child.setResourceName(group.getName());
            child.setType(9);
            child.setValue(group.getResourceID());
            csr.getChildResource().add(child);
        }
        for (PollingChannelEntity pollEntity : csrEntity.getPollingChannels()) {
            child = new ChildResourceRef();
            child.setResourceName(pollEntity.getName());
            child.setValue(pollEntity.getResourceID());
            child.setType(15);
            csr.getChildResource().add(child);
        }
        ScheduleEntity sch = csrEntity.getLinkedSchedule();
        if (sch != null) {
            ChildResourceRef child2 = new ChildResourceRef();
            child2.setResourceName(sch.getName());
            child2.setValue(sch.getResourceID());
            child2.setType(18);
            csr.getChildResource().add(child2);
        }
    }

    @Override
    protected void mapChildResources(RemoteCSEEntity csrEntity, RemoteCSE csr) {
        for (SubscriptionEntity sub : csrEntity.getSubscriptions()) {
            Subscription chSub = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES);
            csr.getAEOrContainerOrGroup().add(chSub);
        }
        for (AeEntity ae : csrEntity.getChildAes()) {
            AE chAe = (AE)new AeMapper().mapEntityToResource(ae, ResultContent.ATTRIBUTES);
            csr.getAEOrContainerOrGroup().add(chAe);
        }
        for (AccessControlPolicyEntity acp : csrEntity.getChildAcps()) {
            AccessControlPolicy chAcp = (AccessControlPolicy)new AcpMapper().mapEntityToResource(acp, ResultContent.ATTRIBUTES);
            csr.getAEOrContainerOrGroup().add(chAcp);
        }
        for (ContainerEntity container : csrEntity.getChildCnt()) {
            Container chCnt = (Container)new ContainerMapper().mapEntityToResource(container, ResultContent.ATTRIBUTES);
            csr.getAEOrContainerOrGroup().add(chCnt);
        }
        for (GroupEntity grp : csrEntity.getChildGrps()) {
            Group chGrp = (Group)new GroupMapper().mapEntityToResource(grp, ResultContent.ATTRIBUTES);
            csr.getAEOrContainerOrGroup().add(chGrp);
        }
        for (PollingChannelEntity pollEntity : csrEntity.getPollingChannels()) {
            PollingChannel chPch = (PollingChannel)new PollingChannelMapper().mapEntityToResource(pollEntity, ResultContent.ATTRIBUTES);
            csr.getAEOrContainerOrGroup().add(chPch);
        }
        ScheduleEntity sch = csrEntity.getLinkedSchedule();
    }
}

