/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.math.BigInteger;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.LabelEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;

public abstract class EntityMapper<E extends ResourceEntity, R extends Resource> {
    private void mapGenericAttributes(E entity, R resource) {
        resource.setCreationTime(entity.getCreationTime());
        resource.setLastModifiedTime(entity.getLastModifiedTime());
        resource.setName(entity.getName());
        resource.setParentID(entity.getParentID());
        resource.setResourceID(entity.getResourceID());
        resource.setResourceType(entity.getResourceType());
        for (LabelEntity lbl : entity.getLabelsEntities()) {
            resource.getLabels().add(lbl.getLabel());
        }
    }

    public R mapEntityToResource(E entity, RequestPrimitive request) {
        BigInteger resultContent = request.getResultContent();
        if (resultContent == null) {
            resultContent = ResultContent.ATTRIBUTES;
        } else if (request.getOperation().equals(Operation.CREATE)) {
            resultContent = ResultContent.ATTRIBUTES;
        }
        return this.mapEntityToResource(entity, resultContent);
    }

    public R mapEntityToResource(E entity, BigInteger resultContent) {
        R result = this.createResource();
        if (resultContent.equals(ResultContent.ATTRIBUTES) || resultContent.equals(ResultContent.ATTRIBUTES_AND_CHILD_REF) || resultContent.equals(ResultContent.ATTRIBUTES_AND_CHILD_RES) || resultContent.equals(ResultContent.HIERARCHICAL_ADRESS) || resultContent.equals(ResultContent.HIERARCHICAL_AND_ATTRIBUTES)) {
            this.mapGenericAttributes(entity, result);
            this.mapAttributes(entity, result);
        }
        if (resultContent.equals(ResultContent.ATTRIBUTES_AND_CHILD_REF) || resultContent.equals(ResultContent.CHILD_REF)) {
            this.mapChildResourceRef(entity, result);
        }
        if (resultContent.equals(ResultContent.ATTRIBUTES_AND_CHILD_RES)) {
            this.mapChildResources(entity, result);
        }
        return result;
    }

    protected abstract void mapAttributes(E var1, R var2);

    protected abstract void mapChildResourceRef(E var1, R var2);

    protected abstract void mapChildResources(E var1, R var2);

    protected abstract R createResource();
}

