/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.List;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.ContentInstanceEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.OperationNotAllowed;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.urimapper.UriMapper;

public class LatestOldestController
extends Controller {
    private SortingPolicy policy;

    public LatestOldestController(SortingPolicy policy) {
        this.policy = policy;
    }

    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        throw new OperationNotAllowed("Create on " + this.policy.toString() + " is not allowed");
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        ContainerEntity containerEntity = (ContainerEntity)this.dbs.getDAOFactory().getContainerDAO().find(this.transaction, (Object)request.getTargetId());
        if (containerEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        List acpList = containerEntity.getAccessControlPolicies();
        this.checkACP(acpList, request.getFrom(), request.getOperation());
        ContentInstanceEntity cinEntity = null;
        if (containerEntity.getChildContentInstances().isEmpty()) {
            throw new ResourceNotFoundException("Resource not found");
        }
        switch (this.policy) {
            case LATEST: {
                cinEntity = (ContentInstanceEntity)containerEntity.getChildContentInstances().get(containerEntity.getChildContentInstances().size() - 1);
                break;
            }
            case OLDEST: {
                cinEntity = (ContentInstanceEntity)containerEntity.getChildContentInstances().get(0);
                break;
            }
        }
        ContentInstance cin = EntityMapperFactory.getContentInstanceMapper().mapEntityToResource(cinEntity, request);
        response.setContent((Object)cin);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        throw new OperationNotAllowed("Update on " + (Object)((Object)this.policy) + " is not allowed");
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        ContainerEntity containerEntity = (ContainerEntity)this.dbs.getDAOFactory().getContainerDAO().find(this.transaction, (Object)request.getTargetId());
        if (containerEntity == null) {
            throw new ResourceNotFoundException();
        }
        List acpList = containerEntity.getAccessControlPolicies();
        this.checkACP(acpList, request.getFrom(), request.getOperation());
        if (containerEntity.getChildContentInstances().isEmpty()) {
            throw new ResourceNotFoundException();
        }
        ContentInstanceEntity cinEntity = null;
        switch (this.policy) {
            case LATEST: {
                cinEntity = (ContentInstanceEntity)containerEntity.getChildContentInstances().get(containerEntity.getChildContentInstances().size() - 1);
                break;
            }
            case OLDEST: {
                cinEntity = (ContentInstanceEntity)containerEntity.getChildContentInstances().get(0);
                break;
            }
        }
        UriMapper.deleteUri(cinEntity.getHierarchicalURI());
        Notifier.notifyDeletion(null, (ResourceEntity)cinEntity);
        this.dbs.getDAOFactory().getContentInstanceDAO().delete(this.transaction, (Object)cinEntity);
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }

    public static enum SortingPolicy {
        LATEST,
        OLDEST;

    }
}

