/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.cm;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.cm.ConfigurationPermissionCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationPermission
extends BasicPermission {
    static final long serialVersionUID = 5716868734811965383L;
    public static final String CONFIGURE = "configure";
    public static final String TARGET = "target";
    private static final int ACTION_CONFIGURE = 1;
    private static final int ACTION_TARGET = 2;
    private static final int ACTION_ALL = 3;
    static final int ACTION_NONE = 0;
    transient int action_mask;
    private volatile String actions = null;
    private transient List<String> substrings;

    public ConfigurationPermission(String name, String actions) {
        this(name, ConfigurationPermission.parseActions(actions));
    }

    ConfigurationPermission(String name, int mask) {
        super(name);
        this.setTransients(mask);
    }

    private void setTransients(int mask) {
        if (mask == 0 || (mask & 3) != mask) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = mask;
        this.substrings = ConfigurationPermission.parseSubstring(this.getName());
    }

    /*
     * Unable to fully structure code
     */
    private static int parseActions(String actions) {
        seencomma = false;
        mask = 0;
        if (actions == null) {
            return mask;
        }
        a = actions.toCharArray();
        i = a.length - 1;
        if (i >= 0) ** GOTO lbl33
        return mask;
        {
            --i;
            do {
                if (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) continue block4;
                if (!(i < 5 || a[i - 5] != 't' && a[i - 5] != 'T' || a[i - 4] != 'a' && a[i - 4] != 'A' || a[i - 3] != 'r' && a[i - 3] != 'R' || a[i - 2] != 'g' && a[i - 2] != 'G' || a[i - 1] != 'e' && a[i - 1] != 'E' || a[i] != 't' && a[i] != 'T')) {
                    matchlen = 6;
                    mask |= 2;
                } else if (!(i < 8 || a[i - 8] != 'c' && a[i - 8] != 'C' || a[i - 7] != 'o' && a[i - 7] != 'O' || a[i - 6] != 'n' && a[i - 6] != 'N' || a[i - 5] != 'f' && a[i - 5] != 'F' || a[i - 4] != 'i' && a[i - 4] != 'I' || a[i - 3] != 'g' && a[i - 3] != 'G' || a[i - 2] != 'u' && a[i - 2] != 'U' || a[i - 1] != 'r' && a[i - 1] != 'R' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 9;
                    mask |= 1;
                } else {
                    throw new IllegalArgumentException("invalid actions: " + actions);
                }
                seencomma = false;
                while (i >= matchlen && !seencomma) {
                    switch (a[i - matchlen]) {
                        case ',': {
                            seencomma = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + actions);
                        }
                    }
                    --i;
                }
                i -= matchlen;
lbl33:
                // 2 sources

            } while (i != -1);
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid actions: " + actions);
        }
        return mask;
    }

    private static List<String> parseSubstring(String name) {
        int size;
        if (name.indexOf(42) < 0) {
            return null;
        }
        char[] chars = name.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length);
        ArrayList<String> sub = new ArrayList<String>(10);
        int pos = 0;
        while (pos < chars.length) {
            char c = chars[pos];
            switch (c) {
                case '*': {
                    if (sb.length() > 0) {
                        sub.add(sb.toString());
                    }
                    sb.setLength(0);
                    sub.add(null);
                    break;
                }
                case '\\': {
                    if (++pos < chars.length) {
                        c = chars[pos];
                    }
                }
                default: {
                    sb.append(c);
                }
            }
            ++pos;
        }
        if (sb.length() > 0) {
            sub.add(sb.toString());
        }
        if ((size = sub.size()) == 0) {
            return null;
        }
        if (size == 1 && sub.get(0) != null) {
            return null;
        }
        return sub;
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof ConfigurationPermission)) {
            return false;
        }
        ConfigurationPermission requested = (ConfigurationPermission)p;
        return this.implies0(requested, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean implies0(ConfigurationPermission requested, int effective) {
        int desired = requested.action_mask;
        if (((effective |= this.action_mask) & desired) != desired) {
            return false;
        }
        String requestedName = requested.getName();
        if (this.substrings == null) {
            return this.getName().equals(requestedName);
        }
        int i = 0;
        int pos = 0;
        int size = this.substrings.size();
        while (i < size) {
            String substr = this.substrings.get(i);
            if (i + 1 < size) {
                if (substr == null) {
                    String substr2 = this.substrings.get(i + 1);
                    if (substr2 != null) {
                        int index = requestedName.indexOf(substr2, pos);
                        if (index == -1) {
                            return false;
                        }
                        pos = index + substr2.length();
                        if (i + 2 < size) {
                            ++i;
                        }
                    }
                } else {
                    int len = substr.length();
                    if (!requestedName.regionMatches(pos, substr, 0, len)) return false;
                    pos += len;
                }
            } else {
                if (substr != null) return requestedName.endsWith(substr);
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConfigurationPermission)) {
            return false;
        }
        ConfigurationPermission cp = (ConfigurationPermission)obj;
        return this.action_mask == cp.action_mask && this.getName().equals(cp.getName());
    }

    @Override
    public int hashCode() {
        int h = 527 + this.getName().hashCode();
        h = 31 * h + this.getActions().hashCode();
        return h;
    }

    @Override
    public String getActions() {
        String result = this.actions;
        if (result == null) {
            StringBuffer sb = new StringBuffer();
            boolean comma = false;
            int mask = this.action_mask;
            if ((mask & 1) == 1) {
                sb.append(CONFIGURE);
                comma = true;
            }
            if ((mask & 2) == 2) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(TARGET);
            }
            this.actions = result = sb.toString();
        }
        return result;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new ConfigurationPermissionCollection();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setTransients(ConfigurationPermission.parseActions(this.actions));
    }
}

