/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.eclipselink.internal;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.persistence.eclipselink.internal.DAOFactoryImpl;
import org.eclipse.om2m.persistence.eclipselink.internal.DBTransactionJPAImpl;
import org.eclipse.om2m.persistence.eclipselink.internal.util.DBUtilManagerImpl;
import org.eclipse.om2m.persistence.service.DAOFactory;
import org.eclipse.om2m.persistence.service.DBConstants;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;
import org.eclipse.om2m.persistence.service.util.DBUtilManager;

public class DBServiceJPAImpl
implements DBService {
    private static final Log LOGGER = LogFactory.getLog(DBServiceJPAImpl.class);
    private EntityManagerFactory emf;
    private DAOFactoryImpl daoFactory = new DAOFactoryImpl();
    private static DBServiceJPAImpl dbService = new DBServiceJPAImpl();

    private DBServiceJPAImpl() {
    }

    public static DBServiceJPAImpl getInstance() {
        return dbService;
    }

    public void init() {
        LOGGER.info((Object)"Initializing Database...");
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("javax.persistence.jdbc.driver", DBConstants.DB_DRIVER);
            properties.put("javax.persistence.jdbc.url", DBConstants.DB_URL);
            properties.put("javax.persistence.jdbc.user", DBConstants.DB_USER);
            properties.put("javax.persistence.jdbc.password", DBConstants.DB_PASSWORD);
            properties.put("eclipselink.cache.shared.default", DBConstants.DB_CACHE);
            if (DBConstants.DB_VERBOSE) {
                properties.put("eclipselink.logging.level", "FINE");
            } else {
                properties.put("eclipselink.logging.level", "SEVERE");
            }
            if (DBConstants.DB_RESET) {
                properties.put("eclipselink.ddl-generation", "drop-and-create-tables");
            } else {
                properties.put("eclipselink.ddl-generation", "create-or-extend-tables");
            }
            LOGGER.info((Object)"Creating new EntityManagerFactory...");
            this.emf = Persistence.createEntityManagerFactory((String)"om2mdb", properties);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error in creation of EntityManagerFactory", (Throwable)e);
        }
        if (this.emf != null) {
            LOGGER.info((Object)"DataBase initialized.");
            EntityManager em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.close();
        } else {
            LOGGER.error((Object)"ERROR initializing Database: EntityManagerFactory is null!");
        }
    }

    public void close() {
        if (this.emf != null) {
            this.emf.close();
        }
    }

    public static EntityManager createEntityManager() {
        return DBServiceJPAImpl.getInstance().emf.createEntityManager();
    }

    public DBTransaction getDbTransaction() {
        return new DBTransactionJPAImpl();
    }

    public DAOFactory getDAOFactory() {
        return this.daoFactory;
    }

    public DBUtilManager getDBUtilManager() {
        return new DBUtilManagerImpl();
    }
}

