/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.entities.ScheduleEntity;

@Entity(name="SUB")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class SubscriptionEntity
extends ResourceEntity {
    @Column(name="et")
    protected String expirationTime;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="SUB_ACP_JOIN", joinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> linkedAcps;
    @Column(name="exc")
    protected BigInteger expirationCounter;
    @Column(name="nu", nullable=false)
    protected List<String> notificationURI;
    protected String groupID;
    @Column(name="nfu")
    protected String notificationForwardingURI;
    protected BigInteger preSubscriptionNotify;
    protected BigInteger pendingNotification;
    protected BigInteger notificationStoragePriority;
    protected Boolean latestNotify;
    protected BigInteger notificationContentType;
    protected String notificationEventCat;
    @Column(name="cr")
    protected String creator;
    protected String subscriberURI;
    @ManyToOne(targetEntity=AeEntity.class, fetch=FetchType.LAZY)
    @JoinTable(name="AE_SUB_JOIN", inverseJoinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected AeEntity parentAe;
    @ManyToOne(targetEntity=ContainerEntity.class, fetch=FetchType.LAZY)
    @JoinTable(name="CNT_SUB_JOIN", inverseJoinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected ContainerEntity parentCnt;
    @ManyToOne(targetEntity=CSEBaseEntity.class, fetch=FetchType.LAZY)
    @JoinTable(name="CSB_SUB_JOIN", inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCsb;
    @ManyToOne(targetEntity=GroupEntity.class, fetch=FetchType.LAZY)
    @JoinTable(name="GRP_SUB_JOIN", inverseJoinColumns={@JoinColumn(name="grp_id", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected GroupEntity parentGrp;
    @ManyToOne(targetEntity=RemoteCSEEntity.class, fetch=FetchType.LAZY)
    @JoinTable(name="CSR_SUB_JOIN", inverseJoinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected RemoteCSEEntity parentCsr;
    @ManyToOne(targetEntity=AccessControlPolicyEntity.class, fetch=FetchType.LAZY)
    @JoinTable(name="ACP_SUB_JOIN", inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected AccessControlPolicyEntity parentAcp;
    @ManyToOne(targetEntity=ScheduleEntity.class, fetch=FetchType.LAZY)
    @JoinTable(name="SCH_SUB_JOIN", inverseJoinColumns={@JoinColumn(name="SCH_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected ScheduleEntity parentSch;
    @ManyToOne(targetEntity=NodeEntity.class, fetch=FetchType.LAZY)
    @JoinTable(name="NOD_SUB_JOIN", inverseJoinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected ScheduleEntity parentNode;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=AreaNwkInfoEntity.class)
    @JoinTable(name="ANI_SUB_JOIN", inverseJoinColumns={@JoinColumn(name="ANI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected AreaNwkInfoEntity parentAni;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=AreaNwkDeviceInfoEntity.class)
    @JoinTable(name="ANDI_SUB_JOIN", inverseJoinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected AreaNwkDeviceInfoEntity parentAndi;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, targetEntity=ScheduleEntity.class)
    @JoinColumn(name="sch_id")
    protected ScheduleEntity childSchedule;

    public String getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(String expirationTime) {
        this.expirationTime = expirationTime;
    }

    public List<AccessControlPolicyEntity> getAcpList() {
        if (this.linkedAcps == null) {
            this.linkedAcps = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.linkedAcps;
    }

    public void setAcpList(List<AccessControlPolicyEntity> acpList) {
        this.linkedAcps = acpList;
    }

    public BigInteger getExpirationCounter() {
        return this.expirationCounter;
    }

    public void setExpirationCounter(BigInteger expirationCounter) {
        this.expirationCounter = expirationCounter;
    }

    public List<String> getNotificationURI() {
        if (this.notificationURI == null) {
            this.notificationURI = new ArrayList<String>();
        }
        return this.notificationURI;
    }

    public void setNotificationURI(List<String> notificationURI) {
        this.notificationURI = notificationURI;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public String getNotificationForwardingURI() {
        return this.notificationForwardingURI;
    }

    public void setNotificationForwardingURI(String notificationForwardingURI) {
        this.notificationForwardingURI = notificationForwardingURI;
    }

    public BigInteger getPreSubscriptionNotify() {
        return this.preSubscriptionNotify;
    }

    public void setPreSubscriptionNotify(BigInteger preSubscriptionNotify) {
        this.preSubscriptionNotify = preSubscriptionNotify;
    }

    public BigInteger getPendingNotification() {
        return this.pendingNotification;
    }

    public void setPendingNotification(BigInteger pendingNotification) {
        this.pendingNotification = pendingNotification;
    }

    public BigInteger getNotificationStoragePriority() {
        return this.notificationStoragePriority;
    }

    public void setNotificationStoragePriority(BigInteger notificationStoragePriority) {
        this.notificationStoragePriority = notificationStoragePriority;
    }

    public Boolean getLatestNotify() {
        return this.latestNotify;
    }

    public void setLatestNotify(Boolean latestNotify) {
        this.latestNotify = latestNotify;
    }

    public BigInteger getNotificationContentType() {
        return this.notificationContentType;
    }

    public void setNotificationContentType(BigInteger notificationContentType) {
        this.notificationContentType = notificationContentType;
    }

    public String getNotificationEventCat() {
        return this.notificationEventCat;
    }

    public void setNotificationEventCat(String notificationEventCat) {
        this.notificationEventCat = notificationEventCat;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getSubscriberURI() {
        return this.subscriberURI;
    }

    public void setSubscriberURI(String subscriberURI) {
        this.subscriberURI = subscriberURI;
    }

    public AeEntity getParentAe() {
        return this.parentAe;
    }

    public void setParentAe(AeEntity parentAe) {
        this.parentAe = parentAe;
    }

    public ContainerEntity getParentCnt() {
        return this.parentCnt;
    }

    public void setParentCnt(ContainerEntity parentCnt) {
        this.parentCnt = parentCnt;
    }

    public CSEBaseEntity getParentCsb() {
        return this.parentCsb;
    }

    public void setParentCsb(CSEBaseEntity parentCsb) {
        this.parentCsb = parentCsb;
    }

    public GroupEntity getParentGrp() {
        return this.parentGrp;
    }

    public void setParentGrp(GroupEntity parentGrp) {
        this.parentGrp = parentGrp;
    }

    public RemoteCSEEntity getParentCsr() {
        return this.parentCsr;
    }

    public void setParentCsr(RemoteCSEEntity parentCsr) {
        this.parentCsr = parentCsr;
    }

    public AccessControlPolicyEntity getParentAcp() {
        return this.parentAcp;
    }

    public void setParentAcp(AccessControlPolicyEntity parentAcp) {
        this.parentAcp = parentAcp;
    }

    public ScheduleEntity getParentSch() {
        return this.parentSch;
    }

    public void setParentSch(ScheduleEntity parentSch) {
        this.parentSch = parentSch;
    }

    public AreaNwkInfoEntity getParentAni() {
        return this.parentAni;
    }

    public void setParentAni(AreaNwkInfoEntity parentAni) {
        this.parentAni = parentAni;
    }

    public AreaNwkDeviceInfoEntity getParentAndi() {
        return this.parentAndi;
    }

    public void setParentAndi(AreaNwkDeviceInfoEntity parentAndi) {
        this.parentAndi = parentAndi;
    }

    public ScheduleEntity getChildSchedule() {
        return this.childSchedule;
    }

    public void setcChildSchedule(ScheduleEntity linkedSchedule) {
        this.childSchedule = linkedSchedule;
    }

    public void setParentEntity(ResourceEntity parentEntity) {
        int rt = parentEntity.getResourceType().intValue();
        switch (rt) {
            case 1: {
                this.parentAcp = (AccessControlPolicyEntity)parentEntity;
                break;
            }
            case 2: {
                this.parentAe = (AeEntity)parentEntity;
                break;
            }
            case 3: {
                this.parentCnt = (ContainerEntity)parentEntity;
                break;
            }
            case 5: {
                this.parentCsb = (CSEBaseEntity)parentEntity;
                break;
            }
            case 9: {
                this.parentGrp = (GroupEntity)parentEntity;
                break;
            }
            case 16: {
                this.parentCsr = (RemoteCSEEntity)parentEntity;
                break;
            }
            case 18: {
                this.parentSch = (ScheduleEntity)parentEntity;
                break;
            }
        }
    }
}

