/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.Date;
import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.Base64Binary;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.ContentInstances;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.DateConverter;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.router.Router;

public class ContentInstanceController
extends Controller {
    public static Object lock = new Object();

    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        ResponseConfirm errorResponse = new ResponseConfirm();
        ContentInstance contentInstance = new ContentInstance();
        ContentInstances contentInstances = DAOFactory.getContentInstancesDAO().find(requestIndication.getTargetID(), em);
        if (contentInstances == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        Container container = DAOFactory.getContainerDAO().find(requestIndication.getTargetID().split("/contentInstances")[0], em);
        errorResponse = this.checkAccessRight(container.getAccessRightID(), requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        try {
            contentInstance = (ContentInstance)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            contentInstance = null;
        }
        if (contentInstance == null) {
            contentInstance = new ContentInstance();
            Base64Binary content = new Base64Binary();
            content.setContentType("application/xml");
            content.setValue(requestIndication.getRepresentation().getBytes());
            contentInstance.setContent(content);
        }
        if (contentInstance.getHref() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " Href CREATE is Not Permitted"));
        }
        if (contentInstance.getContentSize() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " ContentSize CREATE is Not Permitted"));
        }
        if (contentInstance.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " CreationTime CREATE is Not Permitted"));
        }
        if (contentInstance.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " LastModifiedTime CREATE is Not Permitted"));
        }
        if (contentInstance.getContent() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " Content CREATE is Mandatory"));
        }
        if (contentInstance.getId() != null && !contentInstance.getId().matches("^[A-Za-z0-9_-]*$")) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Id should match the following regexpr: ^[A-Za-z0-9_-]*$"));
        }
        if (contentInstance.getId() == null || contentInstance.getId().isEmpty() || DAOFactory.getContentInstanceDAO().find(String.valueOf(requestIndication.getTargetID()) + "/" + contentInstance.getId(), em) != null) {
            contentInstance.setId(ContentInstanceController.generateId("CI_", ""));
        }
        contentInstance.setUri(String.valueOf(requestIndication.getTargetID()) + "/" + contentInstance.getId());
        contentInstance.setHref(contentInstance.getUri());
        contentInstance.setContentSize(Long.valueOf(contentInstance.getContent().getValue().length));
        if (contentInstance.getDelayTolerance() == null) {
            contentInstance.setDelayTolerance(this.getNewDelayTolerance(12000L));
        }
        contentInstance.setCreationTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        contentInstance.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        Notifier.notify(StatusCode.STATUS_CREATED, (Resource)contentInstance);
        DAOFactory.getContentInstanceDAO().create(contentInstance, em);
        contentInstances.setCurrentNrOfInstances(Long.valueOf(contentInstances.getCurrentNrOfInstances() + 1L));
        contentInstances.setCurrentByteSize(Long.valueOf(contentInstances.getCurrentByteSize() + contentInstance.getContentSize()));
        DAOFactory.getContentInstancesDAO().update(contentInstances, em);
        if (contentInstances.getCurrentNrOfInstances() > container.getMaxNrOfInstances() - 1L) {
            final String oldestCI = String.valueOf(requestIndication.getTargetID()) + "/oldest";
            new Thread(){

                @Override
                public void run() {
                    Router.readWriteLock.readLock().lock();
                    EntityManager em = DBAccess.createEntityManager();
                    em.getTransaction().begin();
                    ContentInstance contentInstanceOldest = DAOFactory.getContentInstanceDAO().find(oldestCI, em);
                    DAOFactory.getContentInstanceDAO().delete(contentInstanceOldest, em);
                    em.getTransaction().commit();
                    em.close();
                    Router.readWriteLock.readLock().unlock();
                }
            }.start();
        }
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_CREATED, (Resource)contentInstance);
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Container container = DAOFactory.getContainerDAO().find(requestIndication.getTargetID().split("/contentInstances")[0], em);
        errorResponse = this.checkAccessRight(container.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        ContentInstance contentInstance = DAOFactory.getContentInstanceDAO().find(requestIndication.getTargetID(), em);
        em.close();
        if (contentInstance == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)contentInstance);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_METHOD_NOT_ALLOWED, String.valueOf(requestIndication.getMethod()) + " Method is not allowed"));
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        ContentInstance contentInstance = DAOFactory.getContentInstanceDAO().find(requestIndication.getTargetID(), em);
        if (contentInstance == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        Container container = DAOFactory.getContainerDAO().find(requestIndication.getTargetID().split("/contentInstances")[0], em);
        errorResponse = this.checkAccessRight(container.getAccessRightID(), requestIndication.getRequestingEntity(), "DELETE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        Notifier.notify(StatusCode.STATUS_DELETED, (Resource)contentInstance);
        DAOFactory.getContentInstanceDAO().delete(contentInstance, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK);
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not yet Implemented"));
    }
}

