/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.comm.coap;

import ch.ethz.inf.vs.californium.coap.CoAP;
import ch.ethz.inf.vs.californium.coap.OptionSet;
import ch.ethz.inf.vs.californium.coap.Request;
import ch.ethz.inf.vs.californium.coap.Response;
import ch.ethz.inf.vs.californium.network.Exchange;
import ch.ethz.inf.vs.californium.server.MessageDeliverer;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.core.service.SclService;

class CoapMessageDeliverer
implements MessageDeliverer {
    private static Log LOGGER = LogFactory.getLog(CoapMessageDeliverer.class);
    private static SclService scl;
    private static String context;
    Request req;
    Response resp;

    static {
        context = System.getProperty("org.eclipse.om2m.sclBaseContext", "/om2m");
    }

    CoapMessageDeliverer() {
    }

    public void deliverRequest(Exchange exchange) {
        this.req = exchange.getRequest();
        try {
            this.resp = this.service(this.req);
            LOGGER.info((Object)("the response= " + this.resp));
        }
        catch (SocketException e) {
            LOGGER.error((Object)"the service failed! ", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"IOexception", (Throwable)e);
        }
        LOGGER.info((Object)("request = " + this.req));
        exchange.sendResponse(this.resp);
    }

    public void deliverResponse(Exchange rqst, Response rspns) {
        rqst.sendResponse(rspns);
        LOGGER.info((Object)("response= " + rspns));
    }

    public Response service(Request request) throws SocketException, IOException {
        int mid = request.getMID();
        byte[] token = request.getToken();
        RequestIndication requestIndication = new RequestIndication();
        ResponseConfirm responseConfirm = new ResponseConfirm();
        OptionSet options = request.getOptions();
        URI uri = null;
        try {
            uri = new URI(request.getURI());
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"URI Syntax error", (Throwable)e);
        }
        String targetID = "";
        if (uri.getPath().split(String.valueOf(context) + "/")[1] != null) {
            targetID = uri.getPath().split(context)[1];
        }
        String base = "";
        String representation = request.getPayloadString();
        requestIndication.setBase(base);
        requestIndication.setTargetID(targetID);
        requestIndication.setRepresentation(representation);
        CoAP.Code code = request.getCode();
        String coapMethod = null;
        switch (code) {
            case GET: {
                coapMethod = "RETRIEVE";
                break;
            }
            case POST: {
                if (request.getPayloadString().isEmpty()) {
                    coapMethod = "EXECUTE";
                    break;
                }
                coapMethod = "CREATE";
                break;
            }
            case PUT: {
                coapMethod = "UPDATE";
                break;
            }
            case DELETE: {
                coapMethod = "DELETE";
            }
        }
        requestIndication.setMethod(coapMethod);
        String queryString = options.getURIQueryString();
        Map<String, List<String>> parameters = CoapMessageDeliverer.getParamsFromQuery(queryString);
        if (options.getURIQueryString() != null) {
            requestIndication.setParameters(parameters);
        }
        if (parameters.containsKey("Authorization")) {
            requestIndication.setRequestingEntity(parameters.get("Authorization").get(0));
        }
        if (parameters.containsKey("authorization")) {
            requestIndication.setRequestingEntity(parameters.get("authorization").get(0));
        }
        if (scl != null) {
            responseConfirm = scl.doRequest(requestIndication);
            LOGGER.info((Object)"check point: requestIndication sent and waiting for responseConfirm");
        } else {
            responseConfirm = new ResponseConfirm(StatusCode.STATUS_SERVICE_UNAVAILABLE, "SCL service not installed");
        }
        boolean isEmptyResponse = false;
        if (responseConfirm.getRepresentation() == null || responseConfirm.getRepresentation().isEmpty()) {
            isEmptyResponse = true;
        }
        double statusCode = CoapMessageDeliverer.getCoapStatusCode(responseConfirm.getStatusCode(), isEmptyResponse);
        LOGGER.info((Object)("check point : The code is " + statusCode));
        CoAP.ResponseCode resCode = CoAP.ResponseCode.VALID;
        switch (responseConfirm.getStatusCode()) {
            case STATUS_OK: {
                resCode = CoAP.ResponseCode.CHANGED;
                break;
            }
            case STATUS_DELETED: {
                resCode = CoAP.ResponseCode.DELETED;
                break;
            }
            case STATUS_BAD_REQUEST: {
                resCode = CoAP.ResponseCode.BAD_REQUEST;
                break;
            }
            case STATUS_CREATED: {
                resCode = CoAP.ResponseCode.CREATED;
                break;
            }
            case STATUS_NOT_FOUND: {
                resCode = CoAP.ResponseCode.NOT_FOUND;
                break;
            }
            case STATUS_FORBIDDEN: {
                resCode = CoAP.ResponseCode.FORBIDDEN;
                break;
            }
            case STATUS_METHOD_NOT_ALLOWED: {
                resCode = CoAP.ResponseCode.METHOD_NOT_ALLOWED;
                break;
            }
            case STATUS_UNSUPPORTED_MEDIA_TYPE: {
                resCode = CoAP.ResponseCode.UNSUPPORTED_CONTENT_FORMAT;
                break;
            }
            case STATUS_PERMISSION_DENIED: {
                resCode = CoAP.ResponseCode.UNAUTHORIZED;
                break;
            }
            case STATUS_INTERNAL_SERVER_ERROR: {
                resCode = CoAP.ResponseCode.INTERNAL_SERVER_ERROR;
                break;
            }
            case STATUS_NOT_IMPLEMENTED: {
                resCode = CoAP.ResponseCode.NOT_IMPLEMENTED;
                break;
            }
            case STATUS_AUTHORIZATION_NOT_ADDED: {
                resCode = CoAP.ResponseCode.UNAUTHORIZED;
                break;
            }
            default: {
                resCode = CoAP.ResponseCode.SERVICE_UNAVAILABLE;
            }
        }
        LOGGER.info((Object)("the responseConfirm: " + responseConfirm));
        Response response = new Response(resCode);
        if (responseConfirm.getRepresentation() != null && statusCode != 2.01) {
            response.setPayload(responseConfirm.getRepresentation());
        }
        response.setMID(mid);
        if (token != null) {
            response.setToken(token);
        }
        if (request.getType().equals((Object)CoAP.Type.CON)) {
            CoAP.Type coapType = CoAP.Type.ACK;
            response.setType(coapType);
        }
        LOGGER.info((Object)"CoAP Response parameters set");
        return response;
    }

    public static Map<String, List<String>> getParamsFromQuery(String query) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        if (query != null) {
            String[] pairs;
            String[] stringArray = pairs = query.split("[&]");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] param = pair.split("[=]");
                String key = null;
                String value = null;
                if (param.length > 0) {
                    key = param[0];
                }
                if (param.length > 1) {
                    value = param[1];
                }
                if (parameters.containsKey(key)) {
                    ((List)parameters.get(key)).add(value);
                } else {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(value);
                    parameters.put(key, values);
                }
                ++n2;
            }
        }
        return parameters;
    }

    public static double getCoapStatusCode(StatusCode statusCode, boolean isEmptyBody) {
        LOGGER.info((Object)("The received code is " + statusCode));
        switch (statusCode) {
            case STATUS_OK: {
                double result = isEmptyBody ? 2.04 : 2.0;
                return result;
            }
            case STATUS_CREATED: {
                return 2.01;
            }
            case STATUS_ACCEPTED: {
                return 2.02;
            }
            case STATUS_BAD_REQUEST: {
                return 4.0;
            }
            case STATUS_EXPIRED: {
                return 4.0;
            }
            case STATUS_NOT_ACCEPTABLE: {
                return 4.0;
            }
            case STATUS_REQUEST_TIMEOUT: {
                return 4.0;
            }
            case STATUS_CONFLICT: {
                return 4.0;
            }
            case STATUS_PERMISSION_DENIED: {
                return 4.01;
            }
            case STATUS_AUTHORIZATION_NOT_ADDED: {
                return 4.01;
            }
            case STATUS_FORBIDDEN: {
                return 4.03;
            }
            case STATUS_NOT_FOUND: {
                return 4.04;
            }
            case STATUS_METHOD_NOT_ALLOWED: {
                return 4.05;
            }
            case STATUS_UNSUPPORTED_MEDIA_TYPE: {
                return 4.15;
            }
            case STATUS_INTERNAL_SERVER_ERROR: {
                return 5.0;
            }
            case STATUS_NOT_IMPLEMENTED: {
                return 5.01;
            }
            case STATUS_BAD_GATEWAY: {
                return 5.02;
            }
            case STATUS_SERVICE_UNAVAILABLE: {
                return 5.03;
            }
            case STATUS_GATEWAY_TIMEOUT: {
                return 5.04;
            }
        }
        return 6.0;
    }

    public static SclService getScl() {
        return scl;
    }

    public static void setScl(SclService scl) {
        CoapMessageDeliverer.scl = scl;
    }
}

