/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.om2m.commons.resource.Application;
import org.eclipse.om2m.commons.resource.ApplicationAnnc;
import org.eclipse.om2m.commons.resource.Applications;
import org.eclipse.om2m.commons.resource.MgmtObjs;
import org.eclipse.om2m.commons.resource.ReferenceToNamedResource;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBUtil;

public class ApplicationsDAO
extends DAO<Applications> {
    @Override
    public void create(Applications resource, EntityManager em) {
    }

    @Override
    public Applications find(String uri, EntityManager em) {
        Applications applications = new Applications();
        applications.setUri(uri);
        applications.getApplicationCollection().getNamedReference().clear();
        applications.getApplicationAnncCollection().getNamedReference().clear();
        String q = DBUtil.generateLikeRequest("APPLICATION", uri);
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (Application a : result) {
            ReferenceToNamedResource ref = new ReferenceToNamedResource();
            ref.setId(a.getAppId());
            ref.setValue(a.getUri());
            applications.getApplicationCollection().getNamedReference().add(ref);
        }
        String q2 = DBUtil.generateLikeRequest("APPLICATIONANNC", uri);
        Query query2 = em.createQuery(q2);
        List resultAppAnnc = query2.getResultList();
        for (ApplicationAnnc a : resultAppAnnc) {
            ReferenceToNamedResource ref = new ReferenceToNamedResource();
            ref.setId(a.getId());
            ref.setValue(a.getUri());
            applications.getApplicationAnncCollection().getNamedReference().add(ref);
        }
        return applications;
    }

    @Override
    public void update(Applications resource, EntityManager em) {
    }

    @Override
    public void delete(Applications resource, EntityManager em) {
        Subscriptions subscriptions = new Subscriptions();
        subscriptions.setUri(resource.getSubscriptionsReference());
        DAOFactory.getSubscriptionsDAO().delete(subscriptions, em);
        MgmtObjs mgmtObjs = new MgmtObjs();
        mgmtObjs.setUri(resource.getMgmtObjsReference());
        mgmtObjs.setSubscriptionsReference(String.valueOf(mgmtObjs.getUri()) + "/subscriptions");
        DAOFactory.getMgmtObjsDAO().delete(mgmtObjs, em);
        String q = DBUtil.generateLikeRequest("APPLICATION", resource.getUri());
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (Application a : result) {
            a.setContainersReference(String.valueOf(a.getUri()) + "/containers");
            a.setGroupsReference(String.valueOf(a.getUri()) + "/groups");
            a.setAccessRightsReference(String.valueOf(a.getUri()) + "/accessRights");
            a.setSubscriptionsReference(String.valueOf(a.getUri()) + "/subscriptions");
            a.setNotificationChannelsReference(String.valueOf(a.getUri()) + "/notificationChannels");
            DAOFactory.getApplicationDAO().delete(a, em);
        }
        String q2 = DBUtil.generateLikeRequest("APPLICATIONANNC", resource.getUri());
        Query query2 = em.createQuery(q2);
        List resultAppAnnc = query2.getResultList();
        for (ApplicationAnnc a : resultAppAnnc) {
            a.setContainersReference(String.valueOf(a.getUri()) + "/containers");
            a.setGroupsReference(String.valueOf(a.getUri()) + "/groups");
            a.setAccessRightsReference(String.valueOf(a.getUri()) + "/accessRights");
            DAOFactory.getApplicationAnncDAO().delete(a, em);
        }
    }
}

