/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.AttachedDevices;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;

public class AttachedDevicesController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_METHOD_NOT_ALLOWED, String.valueOf(requestIndication.getMethod()) + " Method is not allowed"));
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        String accessRightID = this.getAccessRightId(requestIndication.getTargetID(), em);
        if (accessRightID == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(accessRightID, requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        AttachedDevices attachedDevices = DAOFactory.getAttachedDevicesDAO().find(requestIndication.getTargetID(), em);
        attachedDevices.setAccessRightID(accessRightID);
        attachedDevices.setSubscriptionsReference(String.valueOf(attachedDevices.getUri()) + "/subscriptions");
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)attachedDevices);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        return new ResponseConfirm(StatusCode.STATUS_NOT_IMPLEMENTED);
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_METHOD_NOT_ALLOWED, String.valueOf(requestIndication.getMethod()) + " Method is not allowed"));
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not yet Implemented"));
    }
}

