/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.announcer;

import java.util.ArrayList;
import java.util.HashSet;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.resource.AccessRightAnnc;
import org.eclipse.om2m.commons.resource.AnnounceTo;
import org.eclipse.om2m.commons.resource.AnyURIList;
import org.eclipse.om2m.commons.resource.ApplicationAnnc;
import org.eclipse.om2m.commons.resource.ContainerAnnc;
import org.eclipse.om2m.commons.resource.GroupAnnc;
import org.eclipse.om2m.commons.resource.Scl;
import org.eclipse.om2m.commons.resource.SearchStrings;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.comm.RestClient;
import org.eclipse.om2m.core.constants.Constants;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;

public class Announcer {
    private static Log LOGGER = LogFactory.getLog(Announcer.class);

    public AnnounceTo announce(AnnounceTo announceTo, String uri, SearchStrings searchStrings, String requestingEntity) {
        if (!announceTo.getSclList().getReference().isEmpty()) {
            String resourceId = uri.split("/")[uri.split("/").length - 1];
            String parentUri = uri.split("/" + resourceId)[0];
            String parentId = parentUri.split("/")[parentUri.split("/").length - 1];
            ArrayList uniqueReferencesList = new ArrayList(new HashSet(announceTo.getSclList().getReference()));
            final AnyURIList sclnewList = new AnyURIList();
            final String decodedRequestingEntity = requestingEntity;
            String partialPath = null;
            String representation = null;
            if ("applications".equalsIgnoreCase(parentId)) {
                ApplicationAnnc applicationAnnc = new ApplicationAnnc();
                applicationAnnc.setLink(uri);
                applicationAnnc.setId(String.valueOf(resourceId) + "Annc");
                applicationAnnc.setSearchStrings(searchStrings);
                representation = XmlMapper.getInstance().objectToXml((Object)applicationAnnc);
                partialPath = "/scls/" + Constants.SCL_ID + "/applications";
            }
            if ("containers".equalsIgnoreCase(parentId)) {
                ContainerAnnc containerAnnc = new ContainerAnnc();
                containerAnnc.setLink(uri);
                containerAnnc.setId(String.valueOf(resourceId) + "Annc");
                containerAnnc.setSearchStrings(searchStrings);
                representation = XmlMapper.getInstance().objectToXml((Object)containerAnnc);
                partialPath = (String.valueOf(Constants.SCL_ID) + "/containers").equalsIgnoreCase(parentUri) ? "/scls/" + Constants.SCL_ID + "/containers" : "/scls/" + uri.split("/containers")[0] + "Annc" + "/containers";
            }
            if ("accessRights".equalsIgnoreCase(parentId)) {
                AccessRightAnnc accessRightAnnc = new AccessRightAnnc();
                accessRightAnnc.setLink(uri);
                accessRightAnnc.setId(String.valueOf(resourceId) + "Annc");
                accessRightAnnc.setSearchStrings(searchStrings);
                representation = XmlMapper.getInstance().objectToXml((Object)accessRightAnnc);
                partialPath = (String.valueOf(Constants.SCL_ID) + "/accessRights").equalsIgnoreCase(parentUri) ? "/scls/" + Constants.SCL_ID + "/accessRights" : "/scls/" + uri.split("/accessRights")[0] + "Annc" + "/accessRights";
            }
            if ("groups".equalsIgnoreCase(parentId)) {
                GroupAnnc groupAnnc = new GroupAnnc();
                groupAnnc.setLink(uri);
                groupAnnc.setId(String.valueOf(resourceId) + "Annc");
                groupAnnc.setSearchStrings(searchStrings);
                representation = XmlMapper.getInstance().objectToXml((Object)groupAnnc);
                partialPath = (String.valueOf(Constants.SCL_ID) + "/groups").equalsIgnoreCase(parentUri) ? "/scls/" + Constants.SCL_ID + "/groups" : "/scls/" + uri.split("/groups")[0] + "Annc" + "/groups";
            }
            final String resourceAnncRepresentation = representation;
            int i = uniqueReferencesList.size() - 1;
            while (i >= 0) {
                final String hostingScl = (String)uniqueReferencesList.get(i);
                String hostingSclURI = String.valueOf(Constants.SCL_ID) + "/scls" + "/" + hostingScl;
                EntityManager em = DBAccess.createEntityManager();
                em.getTransaction().begin();
                final Scl scl = DAOFactory.getSclDAO().find(hostingSclURI, em);
                em.close();
                if (scl != null) {
                    final String targetId = String.valueOf(scl.getLink()) + partialPath;
                    new Thread(){

                        @Override
                        public void run() {
                            String base = String.valueOf((String)scl.getPocs().getReference().get(0)) + "/";
                            sclnewList.getReference().add(hostingScl);
                            RequestIndication requestIndication = new RequestIndication();
                            requestIndication.setMethod("CREATE");
                            requestIndication.setRequestingEntity(decodedRequestingEntity);
                            requestIndication.setTargetID(targetId);
                            requestIndication.setRepresentation(resourceAnncRepresentation);
                            requestIndication.setBase(base);
                            LOGGER.info((Object)("Annoncement Request\n:" + requestIndication));
                            ResponseConfirm response = new RestClient().sendRequest(requestIndication);
                            LOGGER.info((Object)("Annoncement Response:\n" + response.toString()));
                        }
                    }.start();
                } else {
                    uniqueReferencesList.remove(uniqueReferencesList.indexOf(uniqueReferencesList.get(i)));
                }
                --i;
            }
            announceTo.setSclList(sclnewList);
            LOGGER.info((Object)("check3****************" + sclnewList));
        }
        return announceTo;
    }

    public void deAnnounce(AnnounceTo announceTo, String uri, String requestingEntity) {
        if (!announceTo.getSclList().getReference().isEmpty()) {
            String resourceId = uri.split("/")[uri.split("/").length - 1];
            String parent = uri.split("/" + resourceId)[0];
            String parentId = parent.split("/")[parent.split("/").length - 1];
            String partialPath = null;
            String resourceAnncId = String.valueOf(resourceId) + "Annc";
            if ("applications".equalsIgnoreCase(parentId)) {
                partialPath = "/scls/" + Constants.SCL_ID + "/applications" + "/" + resourceAnncId;
            }
            if ("containers".equalsIgnoreCase(parentId)) {
                partialPath = (String.valueOf(Constants.SCL_ID) + "/containers").equalsIgnoreCase(uri.split("/" + resourceId)[0]) ? "/scls/" + Constants.SCL_ID + "/containers" + "/" + resourceAnncId : "/scls/" + uri.split("/containers")[0] + "Annc" + "/containers" + "/" + resourceAnncId;
            }
            if ("accessRights".equalsIgnoreCase(parentId)) {
                partialPath = (String.valueOf(Constants.SCL_ID) + "/accessRights").equalsIgnoreCase(uri.split("/" + resourceId)[0]) ? "/scls/" + Constants.SCL_ID + "/accessRights" + "/" + resourceAnncId : "/scls/" + uri.split("/accessRights")[0] + "Annc" + "/accessRights" + "/" + resourceAnncId;
            }
            if ("groups".equalsIgnoreCase(parentId)) {
                partialPath = (String.valueOf(Constants.SCL_ID) + "/groups").equalsIgnoreCase(uri.split("/" + resourceId)[0]) ? "/scls/" + Constants.SCL_ID + "/groups/" + resourceAnncId : "/scls/" + uri.split("/groups")[0] + "Annc" + "/groups/" + resourceAnncId;
            }
            ArrayList uniqueReferencesList = new ArrayList(new HashSet(announceTo.getSclList().getReference()));
            final String decodedRequestingIndication = requestingEntity;
            int i = uniqueReferencesList.size() - 1;
            while (i >= 0) {
                String hostingScl = (String)uniqueReferencesList.get(i);
                String hostingSclURI = String.valueOf(Constants.SCL_ID) + "/scls" + "/" + hostingScl;
                EntityManager em = DBAccess.createEntityManager();
                em.getTransaction().begin();
                final Scl scl = DAOFactory.getSclDAO().find(hostingSclURI, em);
                em.close();
                if (scl != null) {
                    final String targetId = String.valueOf(scl.getLink()) + partialPath;
                    new Thread(){

                        @Override
                        public void run() {
                            String base = String.valueOf((String)scl.getPocs().getReference().get(0)) + "/";
                            RequestIndication requestIndication = new RequestIndication();
                            requestIndication.setMethod("DELETE");
                            requestIndication.setRequestingEntity(decodedRequestingIndication);
                            requestIndication.setTargetID(targetId);
                            requestIndication.setBase(base);
                            LOGGER.info((Object)("Annoncement Request:\n" + requestIndication));
                            ResponseConfirm response = new RestClient().sendRequest(requestIndication);
                            LOGGER.info((Object)("Annoucement Response:\n" + response));
                        }
                    }.start();
                }
                --i;
            }
        }
    }
}

