/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipu.sample;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.resource.AnyURIList;
import org.eclipse.om2m.commons.resource.Application;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.MemberType;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.core.service.SclService;
import org.eclipse.om2m.ipu.sample.GUI;
import org.eclipse.om2m.ipu.sample.Lamp;
import org.eclipse.om2m.ipu.sample.Switchs;

public class SampleMonitor {
    private static Log LOGGER = LogFactory.getLog(SampleMonitor.class);
    public static final String SCLID = System.getProperty("org.eclipse.om2m.sclBaseId", "");
    static String REQENTITY = System.getProperty("org.eclipse.om2m.adminRequestingEntity", "");
    public static final String METHOD_CREATE = "CREATE";
    public static final String METHOD_EXECUTE = "EXECUTE";
    public static final String DATA = "DATA";
    public static final String DESC = "DESCRIPTOR";
    static SclService SCL;
    static Map<String, Lamp> LAMPS;

    static {
        LAMPS = new HashMap<String, Lamp>();
    }

    public SampleMonitor(SclService scl) {
        SCL = scl;
    }

    public void start() {
        LOGGER.info((Object)"Lamps waiting for attachement..");
        int i = 0;
        while (i < 2) {
            String lampId = "LAMP_" + i;
            LAMPS.put(lampId, new Lamp());
            this.createLampResources(lampId, false, "lamps");
            ++i;
        }
        SampleMonitor.postGroups("lamps", "LAMP", "Home");
        GUI.init();
    }

    public static void stop() {
        GUI.stop();
    }

    public void createLampResources(String appId, boolean initValue, String aPoCPath) {
        ResponseConfirm response = SCL.doRequest(new RequestIndication(METHOD_CREATE, String.valueOf(SCLID) + "/applications", REQENTITY, (Resource)new Application(appId, aPoCPath)));
        if (response.getStatusCode().equals((Object)StatusCode.STATUS_CREATED)) {
            SCL.doRequest(new RequestIndication(METHOD_CREATE, String.valueOf(SCLID) + "/applications/" + appId + "/containers", REQENTITY, (Resource)new Container(DESC)));
            SCL.doRequest(new RequestIndication(METHOD_CREATE, String.valueOf(SCLID) + "/applications/" + appId + "/containers", REQENTITY, (Resource)new Container(DATA)));
            String content = Lamp.getDescriptorRep(SCLID, appId, DATA);
            String targetID = String.valueOf(SCLID) + "/applications/" + appId + "/containers/" + DESC + "/contentInstances";
            SCL.doRequest(new RequestIndication(METHOD_CREATE, targetID, REQENTITY, (Resource)new ContentInstance(content.getBytes())));
            content = Lamp.getStateRep(appId, initValue);
            targetID = String.valueOf(SCLID) + "/applications/" + appId + "/containers/" + DATA + "/contentInstances";
            SCL.doRequest(new RequestIndication(METHOD_CREATE, targetID, REQENTITY, (Resource)new ContentInstance(content.getBytes())));
        }
    }

    public static void createContentResource(String lampId, boolean value) {
        String content = Lamp.getStateRep(lampId, value);
        String targetID = String.valueOf(SCLID) + "/applications/" + lampId + "/containers/" + DATA + "/contentInstances";
        SCL.doRequest(new RequestIndication(METHOD_CREATE, targetID, REQENTITY, (Resource)new ContentInstance(content.getBytes())));
    }

    public static void setLampState(String appId, String value) {
        boolean newState;
        boolean currentState = LAMPS.get(appId).getState();
        if ("toggle".equalsIgnoreCase(value)) {
            newState = !currentState;
            GUI.setLabel(appId, newState);
            SampleMonitor.createContentResource(appId, newState);
        } else {
            newState = Boolean.parseBoolean(value);
            if (newState != currentState) {
                GUI.setLabel(appId, newState);
                SampleMonitor.createContentResource(appId, newState);
            }
        }
        LAMPS.get(appId).setState(newState);
    }

    public static boolean getLampValue(String appId) {
        return LAMPS.get(appId).getState();
    }

    public static void execute(String localTarget) {
        SCL.doRequest(new RequestIndication(METHOD_EXECUTE, String.valueOf(SCLID) + "/" + localTarget, REQENTITY, ""));
    }

    public static void postGroups(String aPoCPath, String type, String location) {
        Group groupON = new Group();
        groupON.setId("ON_ALL");
        groupON.setMemberType(MemberType.APPLICATION);
        Group groupOFF = new Group();
        groupOFF.setId("OFF_ALL");
        groupOFF.setMemberType(MemberType.APPLICATION);
        AnyURIList membersON = new AnyURIList();
        AnyURIList membersOFF = new AnyURIList();
        int i = 0;
        while (i < LAMPS.size()) {
            membersON.getReference().add(String.valueOf(SCLID) + "/applications/" + LAMPS.keySet().toArray()[i].toString() + "/" + aPoCPath + "/true");
            membersOFF.getReference().add(String.valueOf(SCLID) + "/applications/" + LAMPS.keySet().toArray()[i].toString() + "/" + aPoCPath + "/false");
            ++i;
        }
        groupON.setMembers(membersON);
        groupOFF.setMembers(membersOFF);
        SCL.doRequest(new RequestIndication(METHOD_CREATE, String.valueOf(SCLID) + "/groups", REQENTITY, (Resource)groupON));
        SCL.doRequest(new RequestIndication(METHOD_CREATE, String.valueOf(SCLID) + "/groups", REQENTITY, (Resource)groupOFF));
        ResponseConfirm response = SCL.doRequest(new RequestIndication(METHOD_CREATE, String.valueOf(SCLID) + "/applications", REQENTITY, (Resource)new Application("LAMP_ALL")));
        if (response.getStatusCode().equals((Object)StatusCode.STATUS_CREATED)) {
            SCL.doRequest(new RequestIndication(METHOD_CREATE, String.valueOf(SCLID) + "/applications/" + "LAMP_ALL" + "/containers", REQENTITY, (Resource)new Container(DESC)));
            String content = Switchs.getDescriptorRep(SCLID, "LAMP_ALL", type, location, DESC);
            String targetID = String.valueOf(SCLID) + "/applications/" + "LAMP_ALL" + "/containers/" + DESC + "/contentInstances";
            SCL.doRequest(new RequestIndication(METHOD_CREATE, targetID, REQENTITY, (Resource)new ContentInstance(content.getBytes())));
        }
    }
}

