/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

public class BoxedMutableByteSet
extends AbstractMutableSet<Byte>
implements MutableSet<Byte> {
    private final MutableByteSet delegate;

    public BoxedMutableByteSet(MutableByteSet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    public Byte getFirst() {
        throw new UnsupportedOperationException();
    }

    public Byte getLast() {
        throw new UnsupportedOperationException();
    }

    public void each(Procedure<? super Byte> procedure) {
        this.delegate.each(arg_0 -> procedure.value(arg_0));
    }

    @Override
    public boolean add(Byte item) {
        return this.delegate.add(item.byteValue());
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Byte && this.delegate.contains(((Byte)object).byteValue());
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Byte && this.delegate.remove(((Byte)object).byteValue());
    }

    public void clear() {
        this.delegate.clear();
    }

    public ParallelUnsortedSetIterable<Byte> asParallel(ExecutorService executorService, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    public Iterator<Byte> iterator() {
        return new BoxedPrimitiveByteSetIterator(this.delegate.byteIterator());
    }

    private static final class BoxedPrimitiveByteSetIterator
    implements Iterator<Byte> {
        private final MutableByteIterator delegate;

        private BoxedPrimitiveByteSetIterator(MutableByteIterator iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Byte next() {
            return this.delegate.next();
        }
    }
}

