/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists;

import ca.odell.glazedlists.util.concurrent.Lock;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlazedListsLockHelper {
    private static final Logger LOG = LoggerFactory.getLogger(GlazedListsLockHelper.class);

    private GlazedListsLockHelper() {
    }

    public static void acquireWriteLock(Lock writeLock) {
        long start = System.currentTimeMillis();
        long end = System.currentTimeMillis();
        while (end - start < 60000L) {
            try {
                boolean success = writeLock.tryLock();
                if (success) {
                    return;
                }
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                LOG.debug("thread interrupted while waiting for writeLock", (Throwable)e);
            }
            end = System.currentTimeMillis();
        }
        throw new IllegalStateException("Failed to acquire the write lock!");
    }

    public static void performWriteOperation(ReadWriteLock lock, Runnable writeRunnable) {
        Lock writeLock = lock.writeLock();
        try {
            GlazedListsLockHelper.acquireWriteLock(writeLock);
            writeRunnable.run();
        }
        finally {
            writeLock.unlock();
        }
    }

    public static void performWriteOperation(ReadWriteLock lock, Runnable writeRunnable, Runnable finallyRunnable) {
        Lock writeLock = lock.writeLock();
        try {
            GlazedListsLockHelper.acquireWriteLock(writeLock);
            writeRunnable.run();
        }
        finally {
            writeLock.unlock();
            finallyRunnable.run();
        }
    }

    public static <T> T performWriteOperation(ReadWriteLock lock, Supplier<T> writeSupplier) {
        Lock writeLock = lock.writeLock();
        try {
            GlazedListsLockHelper.acquireWriteLock(writeLock);
            T t = writeSupplier.get();
            return t;
        }
        finally {
            writeLock.unlock();
        }
    }
}

