/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.services;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.services.EContextService;

public class ContextContextService
implements EContextService {
    static final String LOCAL_CONTEXTS = "localContexts";
    static final String DEFERED_ACTIVATES = "localContexts.activates";
    static final String DEFERED_DEACTIVATES = "localContexts.deactivates";
    private IEclipseContext eclipseContext;
    private ContextManager contextManager;
    private boolean deferUpdates;
    private int cachingRef;

    public ContextContextService(IEclipseContext context) {
        this.eclipseContext = context;
        this.contextManager = (ContextManager)context.get(ContextManager.class);
    }

    @Override
    public void activateContext(String id) {
        if (this.deferUpdates) {
            this.deferActivateContext(id);
            return;
        }
        LinkedList<String> locals = (LinkedList<String>)this.eclipseContext.getLocal(LOCAL_CONTEXTS);
        if (locals == null) {
            locals = new LinkedList<String>();
            locals.add(id);
            this.eclipseContext.set(LOCAL_CONTEXTS, locals);
        } else {
            boolean contained = locals.contains(id);
            if (locals.add(id) && !contained) {
                this.eclipseContext.set(LOCAL_CONTEXTS, locals.clone());
            }
        }
    }

    @Override
    public void deferUpdates(boolean defer) {
        if (defer) {
            ++this.cachingRef;
            if (this.cachingRef == 1) {
                this.setEventCaching(true);
            }
        } else {
            --this.cachingRef;
            if (this.cachingRef == 0) {
                this.setEventCaching(false);
            }
        }
    }

    private void deferActivateContext(String id) {
        LinkedList<String> locals = (LinkedList<String>)this.eclipseContext.getLocal(DEFERED_ACTIVATES);
        if (locals == null) {
            locals = new LinkedList<String>();
            this.eclipseContext.set(DEFERED_ACTIVATES, locals);
        }
        locals.add(id);
    }

    private void setEventCaching(boolean cache) {
        LinkedList deactivates;
        LinkedList activates;
        if (cache) {
            this.deferUpdates = true;
            return;
        }
        this.deferUpdates = false;
        LinkedList locals = (LinkedList)this.eclipseContext.getLocal(LOCAL_CONTEXTS);
        if (locals == null) {
            locals = new LinkedList();
        }
        if ((activates = (LinkedList)this.eclipseContext.getLocal(DEFERED_ACTIVATES)) != null) {
            this.eclipseContext.remove(DEFERED_ACTIVATES);
            locals.addAll(activates);
        }
        if ((deactivates = (LinkedList)this.eclipseContext.getLocal(DEFERED_DEACTIVATES)) != null) {
            this.eclipseContext.remove(DEFERED_DEACTIVATES);
            for (Object id : deactivates) {
                locals.remove(id);
            }
        }
        this.eclipseContext.set(LOCAL_CONTEXTS, locals.clone());
    }

    @Override
    public void deactivateContext(String id) {
        boolean contained;
        if (this.deferUpdates) {
            this.deferDeactivateContext(id);
            return;
        }
        LinkedList locals = (LinkedList)this.eclipseContext.getLocal(LOCAL_CONTEXTS);
        if (locals != null && locals.remove(id) && !(contained = locals.contains(id))) {
            this.eclipseContext.set(LOCAL_CONTEXTS, locals.clone());
        }
    }

    private void deferDeactivateContext(String id) {
        LinkedList<String> locals = (LinkedList<String>)this.eclipseContext.getLocal(DEFERED_DEACTIVATES);
        if (locals == null) {
            locals = new LinkedList<String>();
            this.eclipseContext.set(DEFERED_DEACTIVATES, locals);
        }
        locals.add(id);
    }

    @Override
    public Collection<String> getActiveContextIds() {
        Set set = (Set)this.eclipseContext.get("activeContexts");
        if (set != null) {
            this.contextManager.setActiveContextIds(set);
        }
        return set;
    }

    @Override
    public Context getContext(String id) {
        return this.contextManager.getContext(id);
    }
}

