/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.dataset.valuegenerator;

import java.util.Random;
import org.eclipse.nebula.widgets.nattable.dataset.generator.IValueGenerator;

public class SentenceValueGenerator
implements IValueGenerator {
    private char[] uppercase = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private char[] lowercase = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private char[] midPunctuation = new char[]{' ', ',', '-'};
    private char[] endPunctuation = new char[]{'.', '!'};
    private int minLength;
    private int maxLength;

    public SentenceValueGenerator() {
        this(5, 20);
    }

    public SentenceValueGenerator(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public Object newValue(Random random) {
        if (random.nextBoolean()) {
            return "";
        }
        StringBuilder strBuilder = new StringBuilder();
        int remainingLength = this.minLength + random.nextInt(this.maxLength - this.minLength);
        boolean endsWithPunctuation = random.nextBoolean();
        if (endsWithPunctuation) {
            --remainingLength;
        }
        String word = this.getWord(remainingLength, random);
        strBuilder.append(word);
        remainingLength -= word.length();
        while (remainingLength > 1) {
            strBuilder.append(this.getChar(this.midPunctuation, random));
            word = this.getWord(--remainingLength, random);
            strBuilder.append(word);
            remainingLength -= word.length();
        }
        if (endsWithPunctuation) {
            strBuilder.append(this.getChar(this.endPunctuation, random));
        }
        return strBuilder.toString();
    }

    private String getWord(int maxWordLength, Random random) {
        StringBuilder wordBuilder = new StringBuilder();
        int wordLength = random.nextInt(maxWordLength);
        int i = 0;
        while (i < wordLength) {
            wordBuilder.append(this.getChar(random.nextBoolean() ? this.uppercase : this.lowercase, random));
            ++i;
        }
        return wordBuilder.toString();
    }

    private char getChar(char[] chars, Random random) {
        return chars[random.nextInt(chars.length)];
    }
}

