/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.DataCell;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;

public class AutomaticSpanningDataProvider
implements ISpanningDataProvider,
IPersistable {
    public static final String PERSISTENCE_KEY_AUTO_COLUMN_SPAN = ".autoColumnSpan";
    public static final String PERSISTENCE_KEY_AUTO_ROW_SPAN = ".autoRowSpan";
    public static final String PERSISTENCE_KEY_AUTO_SPAN_COLUMNS = ".autoSpanColumns";
    public static final String PERSISTENCE_KEY_AUTO_SPAN_ROWS = ".autoSpanRows";
    private final IDataProvider underlyingDataProvider;
    private boolean autoColumnSpan;
    private boolean autoRowSpan;
    private List<Integer> autoSpanColumns = new ArrayList<Integer>();
    private List<Integer> autoSpanRows = new ArrayList<Integer>();

    public AutomaticSpanningDataProvider(IDataProvider underlyingDataProvider, boolean autoColumnSpan, boolean autoRowSpan) {
        this.underlyingDataProvider = underlyingDataProvider;
        this.autoColumnSpan = autoColumnSpan;
        this.autoRowSpan = autoRowSpan;
    }

    @Override
    public Object getDataValue(int columnIndex, int rowIndex) {
        return this.underlyingDataProvider.getDataValue(columnIndex, rowIndex);
    }

    @Override
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        this.underlyingDataProvider.setDataValue(columnIndex, rowIndex, newValue);
    }

    @Override
    public int getColumnCount() {
        return this.underlyingDataProvider.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.underlyingDataProvider.getRowCount();
    }

    @Override
    public DataCell getCellByPosition(int columnPosition, int rowPosition) {
        int cellColumnPosition = this.isAutoSpanEnabledForColumn(columnPosition, rowPosition) ? this.getStartColumnPosition(columnPosition, rowPosition) : columnPosition;
        int cellRowPosition = this.isAutoSpanEnabledForRow(columnPosition, rowPosition) ? this.getStartRowPosition(columnPosition, rowPosition) : rowPosition;
        int columnSpan = this.isAutoSpanEnabledForColumn(columnPosition, rowPosition) ? this.getColumnSpan(cellColumnPosition, cellRowPosition) : 1;
        int rowSpan = this.isAutoSpanEnabledForRow(columnPosition, rowPosition) ? this.getRowSpan(cellColumnPosition, cellRowPosition) : 1;
        return new DataCell(cellColumnPosition, cellRowPosition, columnSpan, rowSpan);
    }

    protected boolean isAutoSpanEnabledForColumn(int columnPosition, int rowPosition) {
        return this.autoColumnSpan && this.isAutoSpanRow(rowPosition);
    }

    protected boolean isAutoSpanEnabledForRow(int columnPosition, int rowPosition) {
        return this.autoRowSpan && this.isAutoSpanColumn(columnPosition);
    }

    private boolean isAutoSpanColumn(int columnPosition) {
        return this.autoSpanColumns.isEmpty() || this.autoSpanColumns.contains(columnPosition);
    }

    private boolean isAutoSpanRow(int rowPosition) {
        return this.autoSpanRows.isEmpty() || this.autoSpanRows.contains(rowPosition);
    }

    public void addAutoSpanningColumnPositions(Integer ... columnPositions) {
        this.autoSpanColumns.addAll(Arrays.asList(columnPositions));
    }

    public void addAutoSpanningRowPositions(Integer ... rowPositions) {
        this.autoSpanRows.addAll(Arrays.asList(rowPositions));
    }

    public void removeAutoSpanningColumnPositions(Integer ... columnPositions) {
        this.autoSpanColumns.removeAll(Arrays.asList(columnPositions));
    }

    public void removeAutoSpanningRowPositions(Integer ... rowPositions) {
        this.autoSpanRows.removeAll(Arrays.asList(rowPositions));
    }

    public void clearAutoSpanningColumnPositions() {
        this.autoSpanColumns.clear();
    }

    public void clearAutoSpanningRowPositions() {
        this.autoSpanRows.clear();
    }

    protected int getStartColumnPosition(int columnPosition, int rowPosition) {
        int columnPos = columnPosition;
        while (columnPos >= 0) {
            Object before;
            Object current;
            if (columnPos <= 0 || !this.isAutoSpanColumn(columnPos) || !this.isAutoSpanColumn(columnPos - 1) || this.valuesNotEqual(current = this.getDataValue(columnPos, rowPosition), before = this.getDataValue(columnPos - 1, rowPosition))) break;
            --columnPos;
        }
        return columnPos;
    }

    protected int getStartRowPosition(int columnPosition, int rowPosition) {
        int rowPos = rowPosition;
        while (rowPos >= 0) {
            Object before;
            Object current;
            if (rowPos <= 0 || !this.isAutoSpanRow(rowPos) || !this.isAutoSpanRow(rowPos - 1) || this.valuesNotEqual(current = this.getDataValue(columnPosition, rowPos), before = this.getDataValue(columnPosition, rowPos - 1))) break;
            --rowPos;
        }
        return rowPos;
    }

    protected int getColumnSpan(int columnPosition, int rowPosition) {
        int span = 1;
        while (columnPosition < this.getColumnCount() - 1 && this.isAutoSpanColumn(columnPosition) && this.isAutoSpanColumn(columnPosition + 1) && !this.valuesNotEqual(this.getDataValue(columnPosition, rowPosition), this.getDataValue(columnPosition + 1, rowPosition))) {
            ++span;
            ++columnPosition;
        }
        return span;
    }

    protected int getRowSpan(int columnPosition, int rowPosition) {
        int span = 1;
        while (rowPosition < this.getRowCount() - 1 && this.isAutoSpanRow(rowPosition) && this.isAutoSpanRow(rowPosition + 1) && !this.valuesNotEqual(this.getDataValue(columnPosition, rowPosition), this.getDataValue(columnPosition, rowPosition + 1))) {
            ++span;
            ++rowPosition;
        }
        return span;
    }

    protected boolean valuesNotEqual(Object value1, Object value2) {
        if (value1 == value2) {
            return false;
        }
        return value1 == null && value2 != null || value1 != null && value2 == null || !value1.equals(value2);
    }

    public boolean isAutoColumnSpan() {
        return this.autoColumnSpan;
    }

    public void setAutoColumnSpan(boolean autoColumnSpan) {
        this.autoColumnSpan = autoColumnSpan;
    }

    public boolean isAutoRowSpan() {
        return this.autoRowSpan;
    }

    public void setAutoRowSpan(boolean autoRowSpan) {
        this.autoRowSpan = autoRowSpan;
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        StringBuilder strBuilder;
        properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_COLUMN_SPAN, Boolean.toString(this.autoColumnSpan));
        properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_ROW_SPAN, Boolean.toString(this.autoRowSpan));
        if (!this.autoSpanColumns.isEmpty()) {
            strBuilder = new StringBuilder();
            for (Integer index : this.autoSpanColumns) {
                strBuilder.append(index);
                strBuilder.append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_SPAN_COLUMNS, strBuilder.toString());
        }
        if (!this.autoSpanRows.isEmpty()) {
            strBuilder = new StringBuilder();
            for (Integer index : this.autoSpanRows) {
                strBuilder.append(index);
                strBuilder.append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_SPAN_ROWS, strBuilder.toString());
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String index;
        StringTokenizer tok;
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_COLUMN_SPAN);
        if (property != null) {
            this.autoColumnSpan = Boolean.valueOf(property);
        }
        if ((property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_ROW_SPAN)) != null) {
            this.autoRowSpan = Boolean.valueOf(property);
        }
        this.autoSpanColumns.clear();
        property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_SPAN_COLUMNS);
        if (property != null) {
            ArrayList<Integer> newAutoSpanColumns = new ArrayList<Integer>();
            tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                index = tok.nextToken();
                newAutoSpanColumns.add(Integer.valueOf(index));
            }
            this.autoSpanColumns.addAll(newAutoSpanColumns);
        }
        this.autoSpanRows.clear();
        property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_AUTO_SPAN_ROWS);
        if (property != null) {
            ArrayList<Integer> newAutoSpanRows = new ArrayList<Integer>();
            tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                index = tok.nextToken();
                newAutoSpanRows.add(Integer.valueOf(index));
            }
            this.autoSpanRows.addAll(newAutoSpanRows);
        }
    }
}

