/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.swt.graphics.Rectangle;

public abstract class ColumnVisualChangeEvent
implements IVisualChangeEvent {
    private ILayer layer;
    private Collection<Range> columnPositionRanges;
    private int[] columnIndexes;

    public ColumnVisualChangeEvent(ILayer layer, int columnPosition) {
        this(layer, new Range(columnPosition, columnPosition + 1));
    }

    public ColumnVisualChangeEvent(ILayer layer, Range ... columnPositionRanges) {
        this(layer, Arrays.asList(columnPositionRanges));
    }

    public ColumnVisualChangeEvent(ILayer layer, Collection<Range> columnPositionRanges) {
        this.layer = layer;
        this.columnPositionRanges = columnPositionRanges;
    }

    public ColumnVisualChangeEvent(ILayer layer, Collection<Range> columnPositionRanges, Collection<Integer> columnIndexes) {
        this.layer = layer;
        this.columnPositionRanges = columnPositionRanges;
        this.columnIndexes = columnIndexes.stream().mapToInt(Integer::intValue).toArray();
    }

    public ColumnVisualChangeEvent(ILayer layer, Collection<Range> columnPositionRanges, int ... columnIndexes) {
        this.layer = layer;
        this.columnPositionRanges = columnPositionRanges;
        this.columnIndexes = columnIndexes;
    }

    protected ColumnVisualChangeEvent(ColumnVisualChangeEvent event) {
        this.layer = event.layer;
        this.columnPositionRanges = event.columnPositionRanges;
        this.columnIndexes = event.columnIndexes;
    }

    @Override
    public ILayer getLayer() {
        return this.layer;
    }

    public Collection<Range> getColumnPositionRanges() {
        return this.columnPositionRanges != null ? this.columnPositionRanges : new ArrayList(0);
    }

    protected void setColumnPositionRanges(Collection<Range> columnPositionRanges) {
        this.columnPositionRanges = columnPositionRanges;
    }

    public int[] getColumnIndexes() {
        if (this.columnIndexes == null) {
            int[] positions = PositionUtil.getPositions(this.columnPositionRanges);
            this.columnIndexes = new int[positions.length];
            int i = 0;
            while (i < positions.length) {
                int pos = positions[i];
                this.columnIndexes[i] = this.layer.getColumnIndexByPosition(pos);
                ++i;
            }
        }
        return this.columnIndexes;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        if (this.columnPositionRanges != null) {
            this.columnPositionRanges = localLayer.underlyingToLocalColumnPositions(this.layer, this.columnPositionRanges);
        }
        this.layer = localLayer;
        return this.columnPositionRanges != null && !this.columnPositionRanges.isEmpty();
    }

    @Override
    public Collection<Rectangle> getChangedPositionRectangles() {
        if (this.columnPositionRanges == null) {
            return new ArrayList<Rectangle>(0);
        }
        int rowCount = this.layer.getRowCount();
        return this.columnPositionRanges.stream().map(range -> new Rectangle(range.start, 0, range.end - range.start, rowCount)).collect(Collectors.toList());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

