/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.hideshow.IColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.HideColumnByIndexCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllColumnsCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.AbstractIndexLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class ResizeColumnHideShowLayer
extends AbstractIndexLayerTransform
implements IColumnHideShowLayer {
    public static final String PERSISTENCE_KEY_HIDDEN_COLUMNS = ".hiddenColumns";
    protected MutableIntObjectMap<ColumnSizeInfo> hiddenColumns = IntObjectMaps.mutable.empty();
    private DataLayer bodyDataLayer;

    public ResizeColumnHideShowLayer(IUniqueIndexLayer underlyingLayer, DataLayer bodyDataLayer) {
        super(underlyingLayer);
        this.bodyDataLayer = bodyDataLayer;
        this.registerCommandHandler(new ColumnHideCommandHandler(this));
        this.registerCommandHandler(new MultiColumnHideCommandHandler(this));
        this.registerCommandHandler(new ShowAllColumnsCommandHandler(this));
        this.registerCommandHandler(new MultiColumnShowCommandHandler(this));
        this.registerCommandHandler(new ColumnShowCommandHandler(this));
        this.registerCommandHandler(new HideColumnByIndexCommandHandler(this));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        if (!this.hiddenColumns.isEmpty()) {
            StringBuilder strBuilder = new StringBuilder();
            for (IntObjectPair pair : this.hiddenColumns.keyValuesView()) {
                strBuilder.append(pair.getOne());
                strBuilder.append(':');
                strBuilder.append(pair.getTwo());
                strBuilder.append(',');
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMNS, strBuilder.toString());
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.hiddenColumns = IntObjectMaps.mutable.empty();
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMNS);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                this.hiddenColumns.put(Integer.parseInt(token.substring(0, separatorIndex)), (Object)ColumnSizeInfo.valueOf(token.substring(separatorIndex + 1)));
            }
        }
        super.loadState(prefix, properties);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack labels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.hiddenColumns.containsKey(this.getColumnIndexByPosition(columnPosition))) {
            labels.addLabel("SKIP_SEARCH_RESULT");
        }
        if (this.hiddenColumns.containsKey(this.getColumnIndexByPosition(columnPosition - 1))) {
            labels.addLabel("COLUMN_LEFT_HIDDEN");
        }
        if (this.hiddenColumns.containsKey(this.getColumnIndexByPosition(columnPosition + 1))) {
            labels.addLabel("COLUMN_RIGHT_HIDDEN");
        }
        return labels;
    }

    @Override
    public Collection<Integer> getHiddenColumnIndexes() {
        return ArrayUtil.asIntegerList(this.hiddenColumns.keySet().toSortedArray());
    }

    @Override
    public int[] getHiddenColumnIndexesArray() {
        return this.hiddenColumns.keySet().toSortedArray();
    }

    @Override
    public void hideColumnPositions(int ... columnPositions) {
        MutableIntObjectMap positionsToHide = IntObjectMaps.mutable.empty();
        boolean fix = this.bodyDataLayer.isFixColumnPercentageValuesOnResize();
        this.bodyDataLayer.setFixColumnPercentageValuesOnResize(false);
        int[] nArray = columnPositions;
        int n = columnPositions.length;
        int n2 = 0;
        while (n2 < n) {
            int columnPosition = nArray[n2];
            int columnIndex2 = this.getColumnIndexByPosition(columnPosition);
            if (!this.hiddenColumns.containsKey(columnIndex2)) {
                int configuredWidth = this.bodyDataLayer.getConfiguredColumnWidthByPosition(columnIndex2);
                int configuredMinWidth = this.bodyDataLayer.getConfiguredMinColumnWidthByPosition(columnIndex2);
                boolean configuredResizable = this.bodyDataLayer.isColumnPositionResizable(columnIndex2);
                boolean configuredPercentage = this.bodyDataLayer.isColumnPercentageSizing(columnIndex2);
                double configuredPercentageValue = this.bodyDataLayer.getConfiguredColumnWidthPercentageByPosition(columnIndex2);
                positionsToHide.put(columnIndex2, (Object)new ColumnSizeInfo(configuredWidth, configuredMinWidth, configuredResizable, configuredPercentage, configuredPercentageValue));
            }
            ++n2;
        }
        positionsToHide.keySet().forEach((IntProcedure & Serializable)columnIndex -> {
            if (!this.bodyDataLayer.isColumnPositionResizable(columnIndex)) {
                this.bodyDataLayer.setColumnPositionResizable(columnIndex, true);
            }
            if (this.bodyDataLayer.isMinColumnWidthConfigured()) {
                this.bodyDataLayer.setMinColumnWidth(columnIndex, 0);
            }
            if (((ColumnSizeInfo)mutableIntObjectMap.get((int)columnIndex)).configuredPercentage) {
                this.bodyDataLayer.setColumnWidthPercentageByPosition(columnIndex, 0.0);
            } else {
                this.bodyDataLayer.setColumnWidthByPosition(columnIndex, 0, false);
            }
            this.bodyDataLayer.setColumnPositionResizable(columnIndex, false);
        });
        this.hiddenColumns.putAll((IntObjectMap)positionsToHide);
        this.bodyDataLayer.setFixColumnPercentageValuesOnResize(fix);
        List<Range> ranges = PositionUtil.getRanges(positionsToHide.keySet().toSortedArray());
        for (Range range : ranges) {
            this.bodyDataLayer.fireLayerEvent(new ColumnResizeEvent((ILayer)this.bodyDataLayer, range));
        }
    }

    @Override
    public void hideColumnPositions(Collection<Integer> columnPositions) {
        this.hideColumnPositions(columnPositions.stream().mapToInt(Integer::intValue).toArray());
    }

    @Override
    public void hideColumnIndexes(int ... columnIndexes) {
        this.hideColumnPositions(Arrays.stream(columnIndexes).map(this::getColumnPositionByIndex).toArray());
    }

    @Override
    public void hideColumnIndexes(Collection<Integer> columnIndexes) {
        this.hideColumnIndexes(columnIndexes.stream().mapToInt(Integer::intValue).toArray());
    }

    @Override
    public void showColumnIndexes(int ... columnIndexes) {
        MutableIntList toProcess = IntLists.mutable.of(columnIndexes);
        toProcess.retainAll((IntIterable)this.hiddenColumns.keySet());
        boolean fix = this.bodyDataLayer.isFixColumnPercentageValuesOnResize();
        this.bodyDataLayer.setFixColumnPercentageValuesOnResize(false);
        MutableIntList processed = IntLists.mutable.empty();
        toProcess.forEach((IntProcedure & Serializable)index -> {
            ColumnSizeInfo info = (ColumnSizeInfo)this.hiddenColumns.remove(index);
            if (info != null) {
                processed.add(index);
                this.bodyDataLayer.setColumnPositionResizable(index, true);
                if (info.configuredPercentage && info.configuredPercentageValue >= 0.0) {
                    this.bodyDataLayer.setColumnWidthPercentageByPosition(index, info.configuredPercentageValue);
                } else if (!info.configuredPercentage && info.configuredSize >= 0) {
                    this.bodyDataLayer.setColumnWidthByPosition(index, info.configuredSize, false);
                } else {
                    this.bodyDataLayer.resetColumnWidth(index, false);
                }
                this.bodyDataLayer.setColumnPositionResizable(index, info.configuredResizable);
                if (info.configuredMinWidth < 0) {
                    this.bodyDataLayer.resetMinColumnWidth(index, false);
                } else {
                    this.bodyDataLayer.setMinColumnWidth(index, info.configuredMinWidth);
                }
            }
        });
        this.bodyDataLayer.setFixColumnPercentageValuesOnResize(fix);
        if (!processed.isEmpty()) {
            List<Range> ranges = PositionUtil.getRanges(processed.distinct().toSortedArray());
            for (Range range : ranges) {
                this.bodyDataLayer.fireLayerEvent(new ColumnResizeEvent((ILayer)this.bodyDataLayer, range));
            }
        }
    }

    @Override
    public void showColumnIndexes(Collection<Integer> columnIndexes) {
        this.showColumnIndexes(columnIndexes.stream().mapToInt(Integer::intValue).toArray());
    }

    @Override
    public void showColumnPosition(int columnPosition, boolean showToLeft, boolean showAll) {
        MutableIntList columnIndexes = IntLists.mutable.empty();
        if (showToLeft) {
            int leftColumnIndex = this.getColumnIndexByPosition(columnPosition - 1);
            if (showAll) {
                int move = 1;
                while (this.hiddenColumns.containsKey(leftColumnIndex)) {
                    columnIndexes.add(leftColumnIndex);
                    leftColumnIndex = this.getColumnIndexByPosition(columnPosition - ++move);
                }
            } else if (this.hiddenColumns.containsKey(leftColumnIndex)) {
                columnIndexes.add(leftColumnIndex);
            }
        } else {
            int rightColumnIndex = this.getColumnIndexByPosition(columnPosition + 1);
            if (showAll) {
                int move = 1;
                while (this.hiddenColumns.containsKey(rightColumnIndex)) {
                    columnIndexes.add(rightColumnIndex);
                    rightColumnIndex = this.getColumnIndexByPosition(columnPosition + ++move);
                }
            } else if (this.hiddenColumns.containsKey(rightColumnIndex)) {
                columnIndexes.add(rightColumnIndex);
            }
        }
        if (!columnIndexes.isEmpty()) {
            this.showColumnIndexes(columnIndexes.distinct().toSortedArray());
        }
    }

    @Override
    public void showAllColumns() {
        boolean fix = this.bodyDataLayer.isFixColumnPercentageValuesOnResize();
        this.bodyDataLayer.setFixColumnPercentageValuesOnResize(false);
        for (IntObjectPair pair : this.hiddenColumns.keyValuesView()) {
            int index = pair.getOne();
            ColumnSizeInfo info = (ColumnSizeInfo)pair.getTwo();
            this.bodyDataLayer.setColumnPositionResizable(index, true);
            if (info.configuredMinWidth < 0) {
                this.bodyDataLayer.resetMinColumnWidth(index, false);
            } else {
                this.bodyDataLayer.setMinColumnWidth(index, info.configuredMinWidth);
            }
            if (info.configuredPercentage && info.configuredPercentageValue >= 0.0) {
                this.bodyDataLayer.setColumnWidthPercentageByPosition(index, info.configuredPercentageValue);
            } else if (!info.configuredPercentage && info.configuredSize >= 0) {
                this.bodyDataLayer.setColumnWidthByPosition(index, info.configuredSize, false);
            } else {
                this.bodyDataLayer.resetColumnWidth(index, false);
            }
            this.bodyDataLayer.setColumnPositionResizable(index, info.configuredResizable);
        }
        List<Range> ranges = PositionUtil.getRanges(this.hiddenColumns.keySet().toSortedArray());
        this.hiddenColumns.clear();
        this.bodyDataLayer.setFixColumnPercentageValuesOnResize(fix);
        for (Range range : ranges) {
            this.bodyDataLayer.fireLayerEvent(new ColumnResizeEvent((ILayer)this.bodyDataLayer, range));
        }
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> result = super.getProvidedLabels();
        result.add("COLUMN_LEFT_HIDDEN");
        result.add("COLUMN_RIGHT_HIDDEN");
        return result;
    }

    protected static class ColumnSizeInfo {
        public final int configuredSize;
        public final int configuredMinWidth;
        public final boolean configuredResizable;
        public final boolean configuredPercentage;
        public final double configuredPercentageValue;

        public ColumnSizeInfo(int configuredSize, int configuredMinWidth, boolean configuredResizable, boolean configuredPercentage, double configuredPercentageValue) {
            this.configuredSize = configuredSize;
            this.configuredMinWidth = configuredMinWidth;
            this.configuredResizable = configuredResizable;
            this.configuredPercentage = configuredPercentage;
            this.configuredPercentageValue = configuredPercentageValue;
        }

        public static ColumnSizeInfo valueOf(String s) {
            String[] token = s.substring(1, s.length() - 1).split("\\|");
            Integer size = Integer.valueOf(token[0]);
            Integer minWidth = Integer.valueOf(token[1]);
            Boolean resizable = Boolean.valueOf(token[2]);
            Boolean percentage = Boolean.valueOf(token[3]);
            Double percentageValue = Double.valueOf(token[4]);
            return new ColumnSizeInfo(size, minWidth, resizable, percentage, percentageValue);
        }

        public String toString() {
            return "[" + this.configuredSize + "|" + this.configuredMinWidth + "|" + this.configuredResizable + "|" + this.configuredPercentage + "|" + this.configuredPercentageValue + "]";
        }
    }
}

