/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.v;

import org.eclipse.nebula.cwt.v.IControlPainter;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;

public class VControlPainter
implements IControlPainter {
    private static double getX(VControl control, double width) {
        double x = control.xAlign == 16384 ? (double)control.marginLeft : (control.xAlign == 131072 ? (double)control.bounds.width - width - (double)control.marginRight : ((double)control.bounds.width - width) / 2.0);
        return x += (double)control.bounds.x;
    }

    private static double getY(VControl control, double height) {
        double y = control.yAlign == 128 ? (double)control.marginTop : (control.yAlign == 1024 ? (double)control.bounds.height - height - (double)control.marginBottom : ((double)control.bounds.height - height) / 2.0);
        return y += (double)control.bounds.y;
    }

    private static void paintImage(VControl control, Event e) {
        Rectangle ibounds = control.image.getBounds();
        if (control.scaleImage) {
            Rectangle cbounds = control.getClientArea();
            e.gc.drawImage(control.image, 0, 0, ibounds.width, ibounds.height, cbounds.x, cbounds.y, cbounds.width, cbounds.height);
        } else {
            e.gc.drawImage(control.image, (int)VControlPainter.getX(control, ibounds.width), (int)VControlPainter.getY(control, ibounds.height));
        }
    }

    private static void paintImageAndText(VControl control, Event e) {
        e.gc.setTextAntialias(1);
        if (control.foreground != null && !control.foreground.isDisposed()) {
            e.gc.setForeground(control.foreground);
        }
        Rectangle ibounds = control.image.getBounds();
        Point tsize = e.gc.textExtent(control.text);
        int x = (int)VControlPainter.getX(control, ibounds.width + tsize.x);
        e.gc.drawImage(control.image, x, (int)VControlPainter.getY(control, ibounds.height));
        e.gc.drawText(control.text, x += ibounds.width + 3, (int)VControlPainter.getY(control, tsize.y), true);
    }

    private static void paintOval(VControl control, Event e, int x, int y) {
        if (control.fill != null && !control.fill.isDisposed()) {
            e.gc.setBackground(control.fill);
            e.gc.fillOval(x, y, control.points[0], control.points[1]);
        }
        e.gc.drawOval(x, y, control.points[0], control.points[1]);
    }

    private static void paintPoly(VControl control, Event e, int x, int y, int minX, int minY) {
        int[] data = new int[control.points.length];
        int i = 0;
        while (i < control.points.length) {
            data[i] = control.points[i] + x - minX - 1;
            i += 2;
        }
        i = 1;
        while (i < data.length) {
            data[i] = control.points[i] + y - minY;
            i += 2;
        }
        if (control.fill != null && !control.fill.isDisposed()) {
            e.gc.setBackground(control.fill);
            e.gc.fillPolygon(data);
        }
        e.gc.drawPolygon(data);
    }

    private static void paintPolygon(VControl control, Event e) {
        e.gc.setAntialias(1);
        if (control.foreground != null && !control.foreground.isDisposed()) {
            e.gc.setForeground(control.foreground);
        }
        int minX = control.points.length > 2 ? control.points[0] : 0;
        int maxX = control.points[0];
        int minY = control.points.length > 2 ? control.points[1] : 0;
        int maxY = control.points[1];
        int i = 2;
        while (i < control.points.length - 1) {
            minX = Math.min(minX, control.points[i]);
            maxX = Math.max(maxX, control.points[i]);
            minY = Math.min(minY, control.points[i + 1]);
            maxY = Math.max(maxY, control.points[i + 1]);
            ++i;
        }
        int x = (int)VControlPainter.getX(control, maxX - minX);
        int y = (int)VControlPainter.getY(control, maxY - minY);
        if (control.points.length > 2) {
            VControlPainter.paintPoly(control, e, x, y, minX, minY);
        } else {
            VControlPainter.paintOval(control, e, x, y);
        }
    }

    private static void paintPolygonAndText(VControl control, Event e) {
        e.gc.setAntialias(1);
        e.gc.setTextAntialias(1);
        if (control.foreground != null && !control.foreground.isDisposed()) {
            e.gc.setForeground(control.foreground);
        }
        int minX = control.points.length > 2 ? control.points[0] : 0;
        int maxX = control.points[0];
        int minY = control.points.length > 2 ? control.points[1] : 0;
        int maxY = control.points[1];
        int i = 2;
        while (i < control.points.length - 1) {
            minX = Math.min(minX, control.points[i]);
            maxX = Math.max(maxX, control.points[i]);
            minY = Math.min(minY, control.points[i + 1]);
            maxY = Math.max(maxY, control.points[i + 1]);
            ++i;
        }
        Point psize = new Point(maxX - minX, maxY - minY);
        Point tsize = e.gc.textExtent(control.text);
        int x = (int)VControlPainter.getX(control, psize.x + tsize.x);
        int y = (int)VControlPainter.getY(control, psize.y);
        if (control.points.length > 2) {
            VControlPainter.paintPoly(control, e, x, y, minX, minY);
        } else {
            VControlPainter.paintOval(control, e, x, y);
        }
        e.gc.drawText(control.text, x += psize.x + 3, (int)VControlPainter.getY(control, tsize.y), true);
    }

    private static void paintText(VControl control, Event e) {
        Font current = e.gc.getFont();
        e.gc.setTextAntialias(1);
        if (control.foreground != null && !control.foreground.isDisposed()) {
            e.gc.setForeground(control.foreground);
        }
        if (control.font != null && !control.font.isDisposed()) {
            e.gc.setFont(control.font);
        }
        Point size = e.gc.textExtent(control.text);
        e.gc.drawText(control.text, (int)VControlPainter.getX(control, size.x), (int)VControlPainter.getY(control, size.y), true);
        e.gc.setFont(current);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void paintBackground(VControl control, Event e) {
        int alpha = e.gc.getAlpha();
        if (!control.isEnabled()) {
            control.setAlpha(e.gc, 170);
        }
        if (control.background != null && !control.background.isDisposed()) {
            e.gc.setBackground(control.background);
            e.gc.fillRectangle(control.bounds);
        }
        e.gc.setAlpha(alpha);
    }

    @Override
    public void paintBorders(VControl control, Event e) {
        int alpha = e.gc.getAlpha();
        if (!control.isEnabled()) {
            control.setAlpha(e.gc, 170);
        }
        if (control.hasStyle(2048)) {
            Rectangle r = control.getBounds();
            e.gc.setForeground(control.getForeground());
            e.gc.drawRectangle(r.x, r.y, r.width - 1, r.height - 1);
        }
        e.gc.setAlpha(alpha);
    }

    @Override
    public void paintContent(VControl control, Event e) {
        int alpha = e.gc.getAlpha();
        Font current = e.gc.getFont();
        if (!control.isEnabled()) {
            control.setAlpha(e.gc, 170);
        }
        if (control.svg != null) {
            if (control.text != null) {
                VControlPainter.paintImageAndText(control, e);
            } else {
                control.svg.apply(e.gc, control.getClientArea());
            }
        } else if (control.image != null && !control.image.getDevice().isDisposed()) {
            if (control.text != null) {
                VControlPainter.paintImageAndText(control, e);
            } else {
                VControlPainter.paintImage(control, e);
            }
        } else if (control.points != null && control.points.length > 0) {
            if (control.text != null) {
                VControlPainter.paintPolygonAndText(control, e);
            } else {
                VControlPainter.paintPolygon(control, e);
            }
        } else if (control.text != null) {
            VControlPainter.paintText(control, e);
        }
        e.gc.setAlpha(alpha);
        e.gc.setFont(current);
    }
}

