/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter2;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class NatTableBorderOverlayPainter
implements IOverlayPainter2 {
    private final Color borderColor;
    private final boolean renderAllBorderLines;
    private final IConfigRegistry configRegistry;

    public NatTableBorderOverlayPainter() {
        this(GUIHelper.COLOR_GRAY);
    }

    public NatTableBorderOverlayPainter(IConfigRegistry configRegistry) {
        this(GUIHelper.COLOR_GRAY, configRegistry);
    }

    public NatTableBorderOverlayPainter(boolean renderAllBorderLines) {
        this(GUIHelper.COLOR_GRAY, renderAllBorderLines);
    }

    public NatTableBorderOverlayPainter(boolean renderAllBorderLines, IConfigRegistry configRegistry) {
        this(GUIHelper.COLOR_GRAY, renderAllBorderLines, configRegistry);
    }

    public NatTableBorderOverlayPainter(Color borderColor) {
        this(borderColor, false);
    }

    public NatTableBorderOverlayPainter(Color borderColor, IConfigRegistry configRegistry) {
        this(borderColor, false, configRegistry);
    }

    public NatTableBorderOverlayPainter(Color borderColor, boolean renderAllBorderLines) {
        this(borderColor, renderAllBorderLines, null);
    }

    public NatTableBorderOverlayPainter(Color borderColor, boolean renderAllBorderLines, IConfigRegistry configRegistry) {
        this.borderColor = borderColor;
        this.renderAllBorderLines = renderAllBorderLines;
        this.configRegistry = configRegistry;
    }

    @Override
    public void paintOverlay(GC gc, ILayer layer) {
        this.paintOverlay(layer, gc, 0, 0, new Rectangle(0, 0, layer.getWidth(), layer.getHeight()));
    }

    @Override
    public void paintOverlay(ILayer layer, GC gc, int xOffset, int yOffset, Rectangle rectangle) {
        Color beforeColor = gc.getForeground();
        gc.setForeground(this.getBorderColor());
        int x = rectangle.x;
        int y = rectangle.y;
        int width = rectangle.x + Math.min(rectangle.width, layer.getWidth() - rectangle.x);
        int height = rectangle.y + Math.min(rectangle.height, layer.getHeight() - rectangle.y);
        if (rectangle.x == 0) {
            gc.drawLine(x, y, x, height - 1);
        }
        if (rectangle.y == 0) {
            gc.drawLine(x, y, width - 1, y);
        }
        if (this.renderAllBorderLines) {
            if (width >= layer.getWidth()) {
                gc.drawLine(width - 1, y, width - 1, height - 1);
            }
            if (height >= layer.getHeight()) {
                gc.drawLine(x, height - 1, width - 1, height - 1);
            }
        }
        gc.setForeground(beforeColor);
    }

    public Color getBorderColor() {
        Color bColor;
        if (this.configRegistry != null && (bColor = this.configRegistry.getConfigAttribute(CellConfigAttributes.GRID_LINE_COLOR, DisplayMode.NORMAL, new String[0])) != null) {
            return bColor;
        }
        return this.borderColor;
    }
}

