/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.IColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllColumnsCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralChangeEventHelper;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class ColumnHideShowLayer
extends AbstractColumnHideShowLayer
implements IColumnHideShowLayer {
    public static final String PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES = ".hiddenColumnIndexes";
    private final Set<Integer> hiddenColumnIndexes = new TreeSet<Integer>();

    public ColumnHideShowLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
        this.registerCommandHandler(new MultiColumnHideCommandHandler(this));
        this.registerCommandHandler(new ColumnHideCommandHandler(this));
        this.registerCommandHandler(new ShowAllColumnsCommandHandler(this));
        this.registerCommandHandler(new MultiColumnShowCommandHandler(this));
        this.registerCommandHandler(new ColumnShowCommandHandler(this));
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        Collection<StructuralDiff> columnDiffs;
        IStructuralChangeEvent structuralChangeEvent;
        if (event instanceof IStructuralChangeEvent && (structuralChangeEvent = (IStructuralChangeEvent)event).isHorizontalStructureChanged() && (columnDiffs = structuralChangeEvent.getColumnDiffs()) != null && !columnDiffs.isEmpty() && !StructuralChangeEventHelper.isReorder(columnDiffs)) {
            StructuralChangeEventHelper.handleColumnDelete(columnDiffs, this.underlyingLayer, this.hiddenColumnIndexes, false);
            StructuralChangeEventHelper.handleColumnInsert(columnDiffs, this.underlyingLayer, this.hiddenColumnIndexes, false);
        }
        super.handleLayerEvent(event);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        if (this.hiddenColumnIndexes.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Integer index : this.hiddenColumnIndexes) {
                strBuilder.append(index);
                strBuilder.append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES, strBuilder.toString());
        } else {
            properties.remove(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES);
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.hiddenColumnIndexes.clear();
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken();
                this.hiddenColumnIndexes.add(Integer.valueOf(index));
            }
        }
        super.loadState(prefix, properties);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int rightColumnIndex;
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        int underlyingPosition = this.localToUnderlyingColumnPosition(columnPosition);
        int leftColumnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingPosition - 1);
        if (this.isColumnIndexHidden(leftColumnIndex)) {
            configLabels.addLabel("COLUMN_LEFT_HIDDEN");
        }
        if (this.isColumnIndexHidden(rightColumnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingPosition + 1))) {
            configLabels.addLabel("COLUMN_RIGHT_HIDDEN");
        }
        return configLabels;
    }

    @Override
    public boolean isColumnIndexHidden(int columnIndex) {
        return this.hiddenColumnIndexes.contains(columnIndex);
    }

    @Override
    public Collection<Integer> getHiddenColumnIndexes() {
        return this.hiddenColumnIndexes;
    }

    @Override
    public void hideColumnPositions(Integer ... columnPositions) {
        this.hideColumnPositions(Arrays.asList(columnPositions));
    }

    @Override
    public void hideColumnPositions(Collection<Integer> columnPositions) {
        HashSet<Integer> columnIndexes = new HashSet<Integer>();
        for (Integer columnPosition : columnPositions) {
            columnIndexes.add(this.getColumnIndexByPosition(columnPosition));
        }
        this.hiddenColumnIndexes.addAll(columnIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new HideColumnPositionsEvent((ILayer)this, columnPositions, (Collection<Integer>)columnIndexes));
    }

    @Override
    public void showColumnIndexes(Integer ... columnIndexes) {
        this.showColumnIndexes(Arrays.asList(columnIndexes));
    }

    @Override
    public void showColumnIndexes(Collection<Integer> columnIndexes) {
        ArrayList<Integer> toProcess = new ArrayList<Integer>(columnIndexes);
        toProcess.retainAll(this.hiddenColumnIndexes);
        this.hiddenColumnIndexes.removeAll(toProcess);
        this.invalidateCache();
        Collection<Integer> positions = this.getColumnPositionsByIndexes(toProcess);
        this.fireLayerEvent(new ShowColumnPositionsEvent(this, positions));
    }

    @Override
    public void showColumnPosition(int columnPosition, boolean showToLeft, boolean showAll) {
        HashSet<Integer> columnIndexes = new HashSet<Integer>();
        int underlyingPosition = this.localToUnderlyingColumnPosition(columnPosition);
        if (showToLeft) {
            int leftColumnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingPosition - 1);
            if (showAll) {
                int move = 1;
                while (this.isColumnIndexHidden(leftColumnIndex)) {
                    columnIndexes.add(leftColumnIndex);
                    leftColumnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingPosition - ++move);
                }
            } else if (this.isColumnIndexHidden(leftColumnIndex)) {
                columnIndexes.add(leftColumnIndex);
            }
        } else {
            int rightColumnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingPosition + 1);
            if (showAll) {
                int move = 1;
                while (this.isColumnIndexHidden(rightColumnIndex)) {
                    columnIndexes.add(rightColumnIndex);
                    rightColumnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingPosition + ++move);
                }
            } else if (this.isColumnIndexHidden(rightColumnIndex)) {
                columnIndexes.add(rightColumnIndex);
            }
        }
        if (!columnIndexes.isEmpty()) {
            this.showColumnIndexes(columnIndexes);
        }
    }

    @Override
    public void showAllColumns() {
        ArrayList<Integer> hiddenColumns = new ArrayList<Integer>(this.hiddenColumnIndexes);
        this.hiddenColumnIndexes.clear();
        this.invalidateCache();
        this.fireLayerEvent(new ShowColumnPositionsEvent(this, this.getColumnPositionsByIndexes(hiddenColumns)));
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> result = super.getProvidedLabels();
        result.add("COLUMN_LEFT_HIDDEN");
        result.add("COLUMN_RIGHT_HIDDEN");
        return result;
    }
}

