/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._103_Events;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.blink.BlinkConfigAttributes;
import org.eclipse.nebula.widgets.nattable.blink.BlinkLayer;
import org.eclipse.nebula.widgets.nattable.blink.BlinkingCellResolver;
import org.eclipse.nebula.widgets.nattable.blink.IBlinkingCellResolver;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyResolver;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.BlinkingRowDataFixture;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataListFixture;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultGridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class BlinkingGridExample
extends AbstractNatExample {
    private static final String BLINK_UP_CONFIG_LABEL = "blinkUpConfigLabel";
    private static final String BLINK_DOWN_CONFIG_LABEL = "blinkDownConfigLabel";
    private ListDataProvider<BlinkingRowDataFixture> bodyDataProvider;
    private ScheduledExecutorService scheduledThreadPool;
    final Random random = new Random();

    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(800, 400, new BlinkingGridExample());
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = RowDataListFixture.getPropertyNames();
        Map propertyToLabelMap = RowDataListFixture.getPropertyToLabelMap();
        ConfigRegistry configRegistry = new ConfigRegistry();
        LinkedList rowData = new LinkedList();
        EventList eventList = GlazedLists.eventList(rowData);
        ObservableElementList observableElementList = new ObservableElementList(eventList, GlazedLists.beanConnector(BlinkingRowDataFixture.class));
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        this.bodyDataProvider = new ListDataProvider((List)observableElementList, (IColumnAccessor)columnPropertyAccessor);
        DataLayer bodyLayer = new DataLayer(this.bodyDataProvider);
        GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)bodyLayer, (EventList)observableElementList);
        BlinkLayer blinkingLayer = new BlinkLayer((IUniqueIndexLayer)glazedListsEventLayer, this.bodyDataProvider, (IRowIdAccessor)new IRowIdAccessor<BlinkingRowDataFixture>(){

            public Serializable getRowId(BlinkingRowDataFixture rowObject) {
                return rowObject.getSecurity_description();
            }
        }, (IColumnPropertyResolver)columnPropertyAccessor, (IConfigRegistry)configRegistry);
        this.registerBlinkingConfigCells(configRegistry);
        this.insertRowData((PropertyChangeListener)glazedListsEventLayer, this.bodyDataProvider);
        DefaultColumnHeaderDataProvider defaultColumnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(this.bodyDataProvider);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)defaultColumnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DefaultGridLayer gridLayer = new DefaultGridLayer((IUniqueIndexLayer)blinkingLayer, (IUniqueIndexLayer)new DefaultColumnHeaderDataLayer((IDataProvider)defaultColumnHeaderDataProvider), (IUniqueIndexLayer)new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider), (IUniqueIndexLayer)new DataLayer((IDataProvider)cornerDataProvider));
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.configure();
        return natTable;
    }

    @Override
    public void onStart() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BlinkingGridExample.this.scheduledThreadPool = Executors.newScheduledThreadPool(1);
                BlinkingGridExample.this.scheduledThreadPool.scheduleAtFixedRate(new DataPumper((ListDataProvider<BlinkingRowDataFixture>)BlinkingGridExample.this.bodyDataProvider, 1, 3, 5), 500L, 5000L, TimeUnit.MILLISECONDS);
                BlinkingGridExample.this.scheduledThreadPool.scheduleAtFixedRate(new DataPumper((ListDataProvider<BlinkingRowDataFixture>)BlinkingGridExample.this.bodyDataProvider, 1), 750L, 5000L, TimeUnit.MILLISECONDS);
                BlinkingGridExample.this.scheduledThreadPool.scheduleAtFixedRate(new DataPumper((ListDataProvider<BlinkingRowDataFixture>)BlinkingGridExample.this.bodyDataProvider, 2, 8), 1000L, 5000L, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Override
    public void onStop() {
        this.scheduledThreadPool.shutdown();
    }

    private void registerBlinkingConfigCells(ConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(BlinkConfigAttributes.BLINK_RESOLVER, (Object)this.getBlinkResolver(), "NORMAL");
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_GREEN);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", BLINK_UP_CONFIG_LABEL);
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_RED);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", BLINK_DOWN_CONFIG_LABEL);
    }

    private IBlinkingCellResolver getBlinkResolver() {
        return new BlinkingCellResolver(){
            private String[] configLabels = new String[1];

            public String[] resolve(Object oldValue, Object newValue) {
                double old = (Double)oldValue;
                double latest = (Double)newValue;
                this.configLabels[0] = latest > old ? BlinkingGridExample.BLINK_UP_CONFIG_LABEL : BlinkingGridExample.BLINK_DOWN_CONFIG_LABEL;
                return this.configLabels;
            }
        };
    }

    private void insertRowData(PropertyChangeListener changeListener, ListDataProvider<BlinkingRowDataFixture> dataProvider) {
        List listFixture = BlinkingRowDataFixture.getList((PropertyChangeListener)changeListener);
        for (BlinkingRowDataFixture rowObject : listFixture) {
            dataProvider.getList().add(rowObject);
        }
    }

    class DataPumper
    implements Runnable {
        ListDataProvider<BlinkingRowDataFixture> dataProvider;
        private final int[] rowIndexes;

        DataPumper(ListDataProvider<BlinkingRowDataFixture> dataProvider, int ... rowIndexes) {
            this.dataProvider = dataProvider;
            this.rowIndexes = rowIndexes;
        }

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < DataPumper.this.rowIndexes.length) {
                        double nextPrice = ((DataPumper)DataPumper.this).BlinkingGridExample.this.random.nextInt(1000);
                        BlinkingRowDataFixture rowObject = (BlinkingRowDataFixture)DataPumper.this.dataProvider.getRowObject(DataPumper.this.rowIndexes[i]);
                        rowObject.setAsk_price(nextPrice);
                        ++i;
                    }
                }
            });
        }
    }
}

