/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.textile.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.builder.AbstractMarkupDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.EntityReferences;

public class TextileDocumentBuilder
extends AbstractMarkupDocumentBuilder {
    private static final Pattern PATTERN_MULTIPLE_NEWLINES = Pattern.compile("(\r\n|\r|\n){2,}");
    private final Map<String, String> entityToLiteral = new HashMap<String, String>();
    private boolean previousWasExtended;
    private boolean emitAttributes;

    public TextileDocumentBuilder(Writer out) {
        super(out);
        this.entityToLiteral.put("nbsp", " ");
        this.entityToLiteral.put("#160", " ");
        this.entityToLiteral.put("copy", "(c)");
        this.entityToLiteral.put("reg", "(r)");
        this.entityToLiteral.put("#8482", "(t)");
        this.emitAttributes = true;
        this.currentBlock = null;
    }

    protected AbstractMarkupDocumentBuilder.Block computeBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        switch (type) {
            case BULLETED_LIST: 
            case DEFINITION_LIST: 
            case NUMERIC_LIST: {
                DocumentBuilder.BlockType currentBlockType;
                if (this.currentBlock != null && ((currentBlockType = this.currentBlock.getBlockType()) == DocumentBuilder.BlockType.LIST_ITEM || currentBlockType == DocumentBuilder.BlockType.DEFINITION_ITEM || currentBlockType == DocumentBuilder.BlockType.DEFINITION_TERM)) {
                    return new AbstractMarkupDocumentBuilder.NewlineDelimitedBlock((AbstractMarkupDocumentBuilder)this, type, 1, 1);
                }
                return new AbstractMarkupDocumentBuilder.NewlineDelimitedBlock((AbstractMarkupDocumentBuilder)this, type, 2, 1);
            }
            case CODE: {
                return new ContentBlock(type, "bc. ", "", false, false, false, 2, 2);
            }
            case DEFINITION_ITEM: {
                return new DefinitionItemBlock();
            }
            case DEFINITION_TERM: {
                return new ContentBlock(type, "- ", "", false, true, true, 0, 0);
            }
            case LIST_ITEM: {
                char prefixChar = this.computeCurrentListType() == DocumentBuilder.BlockType.NUMERIC_LIST ? (char)'#' : '*';
                return new ContentBlock(type, this.computePrefix(prefixChar, this.computeListLevel()) + " ", "", false, true, true, 1, 1);
            }
            case DIV: {
                if (this.currentBlock == null) {
                    return new ParagraphBlock(type, "", false, false, true, 2, 2);
                }
                return new ParagraphBlock(type, "", true, false, true, 0, 0);
            }
            case FOOTNOTE: {
                return new ParagraphBlock(type, "fn1. ", false, false, true, 2, 2);
            }
            case INFORMATION: 
            case NOTE: 
            case PANEL: 
            case TIP: 
            case WARNING: {
                attributes.appendCssClass(type.name().toLowerCase());
            }
            case PARAGRAPH: {
                String attributesMarkup = this.computeAttributes(attributes);
                return new ParagraphBlock(type, (String)(attributesMarkup.length() > 0 || this.previousWasExtended ? "p" + attributesMarkup + ". " : attributesMarkup), false, false, true, 2, 2);
            }
            case PREFORMATTED: {
                return new ContentBlock(type, "pre" + this.computeAttributes(attributes) + ". ", "", false, false, false, 2, 2);
            }
            case QUOTE: {
                return new ContentBlock(type, "bq" + this.computeAttributes(attributes) + ". ", "", false, false, true, 2, 2);
            }
            case TABLE: {
                return new AbstractMarkupDocumentBuilder.SuffixBlock((AbstractMarkupDocumentBuilder)this, type, "\n");
            }
            case TABLE_CELL_HEADER: 
            case TABLE_CELL_NORMAL: {
                return new TableCellBlock(type);
            }
            case TABLE_ROW: {
                return new AbstractMarkupDocumentBuilder.SuffixBlock((AbstractMarkupDocumentBuilder)this, type, "|\n");
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Unexpected block type: " + type);
        return new ContentBlock(type, "", "", false, false, true, 0, 0);
    }

    protected AbstractMarkupDocumentBuilder.Block computeSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        ContentBlock block;
        String appendStyle = null;
        switch (type) {
            case UNDERLINED: {
                appendStyle = "text-decoration:underline;";
                break;
            }
            case MONOSPACE: {
                appendStyle = "font-family:monospace;";
            }
        }
        if (appendStyle != null) {
            attributes = new Attributes(attributes.getId(), attributes.getCssClass(), attributes.getCssStyle(), attributes.getLanguage());
            attributes.appendCssStyle(appendStyle);
        }
        String spanAttributes = this.computeAttributes(attributes);
        switch (type) {
            case BOLD: {
                block = new ContentBlock("**" + spanAttributes, "**", true, false, 0, 0);
                break;
            }
            case CITATION: {
                block = new ContentBlock("??" + spanAttributes, "??", true, false, 0, 0);
                break;
            }
            case DELETED: {
                block = new ContentBlock("-" + spanAttributes, "-", true, false, 0, 0);
                break;
            }
            case MARK: 
            case EMPHASIS: {
                block = new ContentBlock("_" + spanAttributes, "_", true, false, 0, 0);
                break;
            }
            case INSERTED: {
                block = new ContentBlock("+" + spanAttributes, "+", true, false, 0, 0);
                break;
            }
            case CODE: {
                block = new ContentBlock("@" + spanAttributes, "@", true, false, 0, 0);
                break;
            }
            case ITALIC: {
                block = new ContentBlock("__" + spanAttributes, "__", true, false, 0, 0);
                break;
            }
            case LINK: {
                if (attributes instanceof LinkAttributes) {
                    block = new LinkBlock((LinkAttributes)attributes);
                    break;
                }
                block = new SpanBlock(spanAttributes, true, false);
                break;
            }
            case MONOSPACE: {
                block = new SpanBlock(spanAttributes, true, false);
                break;
            }
            case STRONG: {
                block = new ContentBlock("*" + spanAttributes, "*", true, false, 0, 0);
                break;
            }
            case SUPERSCRIPT: {
                block = new ContentBlock("^" + spanAttributes, "^", true, false, 0, 0);
                break;
            }
            case SUBSCRIPT: {
                block = new ContentBlock("~" + spanAttributes, "~", true, false, 0, 0);
                break;
            }
            default: {
                block = spanAttributes.length() == 0 ? new SpanBlock("", true, false) : new SpanBlock(spanAttributes, true, false);
            }
        }
        return block;
    }

    private String computeAttributes(Attributes attributes) {
        Object attributeMarkup = "";
        if (this.emitAttributes) {
            Object classId = "";
            if (attributes.getCssClass() != null) {
                classId = attributes.getCssClass();
            }
            if (attributes.getId() != null) {
                classId = (String)classId + "#" + attributes.getId();
            }
            if (((String)classId).length() > 0) {
                attributeMarkup = (String)attributeMarkup + "(" + (String)classId + ")";
            }
            if (attributes.getCssStyle() != null) {
                attributeMarkup = (String)attributeMarkup + "{" + attributes.getCssStyle() + "}";
            }
        }
        return attributeMarkup;
    }

    protected ContentBlock computeHeading(int level, Attributes attributes) {
        return new ContentBlock("h" + level + this.computeAttributes(attributes) + ". ", "", false, false, 2, 2);
    }

    public void characters(String text) {
        this.assertOpenBlock();
        try {
            block7: for (int x = 0; x < text.length(); ++x) {
                char c = text.charAt(x);
                switch (c) {
                    case '\u00a0': {
                        this.currentBlock.write(32);
                        continue block7;
                    }
                    case '\u00a9': {
                        this.currentBlock.write("(c)");
                        continue block7;
                    }
                    case '\u00ae': {
                        this.currentBlock.write("(r)");
                        continue block7;
                    }
                    default: {
                        this.currentBlock.write((int)c);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void entityReference(String entity) {
        this.assertOpenBlock();
        Object literal = this.entityToLiteral.get(entity);
        if (literal == null && (literal = EntityReferences.instance().equivalentString(entity)) == null) {
            literal = "&" + entity + ";";
        }
        try {
            this.currentBlock.write((String)literal);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void image(Attributes attributes, String url) {
        if (url != null) {
            this.assertOpenBlock();
            try {
                this.currentBlock.write(33);
                this.writeAttributes(attributes);
                this.currentBlock.write(url);
                this.currentBlock.write(33);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(34);
            this.writeAttributes(attributes);
            this.currentBlock.write(text);
            this.currentBlock.write(34);
            this.currentBlock.write(58);
            if (hrefOrHashName != null) {
                this.currentBlock.write(hrefOrHashName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(33);
            this.writeAttributes(imageAttributes);
            this.currentBlock.write(imageUrl);
            this.currentBlock.write(33);
            this.currentBlock.write(58);
            this.currentBlock.write(href);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void acronym(String text, String definition) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(text);
            this.currentBlock.write(40);
            this.currentBlock.write(definition);
            this.currentBlock.write(41);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void lineBreak() {
        this.assertOpenBlock();
        try {
            if (this.currentBlock instanceof TextileBlock) {
                ((TextileBlock)this.currentBlock).lineBreak();
            } else {
                this.currentBlock.write(10);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeAttributes(Attributes attributes) {
        if (!this.emitAttributes) {
            return;
        }
        try {
            this.currentBlock.write(this.computeAttributes(attributes));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmitAttributes() {
        return this.emitAttributes;
    }

    public void setEmitAttributes(boolean emitAttributes) {
        this.emitAttributes = emitAttributes;
    }

    protected AbstractMarkupDocumentBuilder.Block createImplicitParagraphBlock() {
        return new TextileImplicitParagraphBlock();
    }

    private boolean consecutiveNewline(char lastChar, char nextChar) {
        return (nextChar == '\n' || nextChar == '\r') && lastChar == '\n' || nextChar == '\r' && lastChar == '\r';
    }

    public class DefinitionItemBlock
    extends ContentBlock {
        public DefinitionItemBlock() {
            super(DocumentBuilder.BlockType.DEFINITION_ITEM, " := ", "", false, true, true, 0, 1);
        }

        @Override
        public void lineBreak() throws IOException {
            TextileDocumentBuilder.this.emitContent(10);
            this.suffix = " =:\n";
        }
    }

    private class TableCellBlock
    extends ContentBlock {
        public TableCellBlock(DocumentBuilder.BlockType blockType) {
            super(blockType, blockType == DocumentBuilder.BlockType.TABLE_CELL_NORMAL ? "|" : "|_.", "", false, true, true, 0, 0);
        }

        @Override
        protected void emitContent(String content, boolean extended) throws IOException {
            if (content.length() == 0) {
                content = " ";
            }
            content = content.replaceAll("(\\r|\\n)+", " ");
            super.emitContent(content, extended);
        }
    }

    private class LinkBlock
    extends ContentBlock {
        private final LinkAttributes attributes;

        private LinkBlock(LinkAttributes attributes) {
            super(null, "", "", true, true, true, 0, 0);
            this.attributes = attributes;
        }

        @Override
        protected void emitContent(String content, boolean extended) throws IOException {
            if (content.matches("!.*?!")) {
                TextileDocumentBuilder.this.emitContent(content);
            } else {
                TextileDocumentBuilder.this.emitContent(34);
                TextileDocumentBuilder.this.emitContent(content);
                TextileDocumentBuilder.this.emitContent(34);
            }
            TextileDocumentBuilder.this.emitContent(58);
            TextileDocumentBuilder.this.emitContent(this.attributes.getHref());
        }
    }

    private class SpanBlock
    extends ContentBlock {
        public SpanBlock(String spanAttributes, boolean requireAdjacentWhitespace, boolean emitWhenEmpty) {
            super(null, "%" + spanAttributes, "%", requireAdjacentWhitespace, emitWhenEmpty, true, 0, 0);
        }

        @Override
        protected void emitContent(String content, boolean extended) throws IOException {
            boolean nestedSpan = this.computeNestedSpan();
            if (!nestedSpan) {
                String prefix = extended ? this.prefix.replace(".", "..") : this.prefix;
                TextileDocumentBuilder.this.emitContent(prefix);
            }
            TextileDocumentBuilder.this.emitContent(content);
            if (!nestedSpan) {
                Object suffix = extended ? this.suffix + "\n" : this.suffix;
                TextileDocumentBuilder.this.emitContent((String)suffix);
            }
        }

        private boolean computeNestedSpan() {
            for (AbstractMarkupDocumentBuilder.Block block = this.getPreviousBlock(); block != null; block = block.getPreviousBlock()) {
                if (!(block instanceof SpanBlock)) continue;
                return true;
            }
            return false;
        }
    }

    private final class TextileImplicitParagraphBlock
    extends ParagraphBlock {
        TextileImplicitParagraphBlock() {
            super(DocumentBuilder.BlockType.PARAGRAPH, TextileDocumentBuilder.this.previousWasExtended ? "p. " : "", false, false, true, 2, 2);
        }

        protected boolean isImplicitBlock() {
            return true;
        }
    }

    private class ParagraphBlock
    extends ContentBlock {
        ParagraphBlock(DocumentBuilder.BlockType blockType, String prefix, boolean requireAdjacentSeparator, boolean emitWhenEmpty, boolean normalizingWhitespace, int leadingNewlines, int trailingNewlines) {
            super(blockType, prefix, "", requireAdjacentSeparator, emitWhenEmpty, normalizingWhitespace, leadingNewlines, trailingNewlines);
        }

        @Override
        public void lineBreak() throws IOException {
            char lastChar = TextileDocumentBuilder.this.getLastChar();
            if (TextileDocumentBuilder.this.consecutiveNewline(lastChar, '\n')) {
                return;
            }
            TextileDocumentBuilder.this.emitContent(10);
        }
    }

    private class ContentBlock
    extends AbstractMarkupDocumentBuilder.NewlineDelimitedBlock
    implements TextileBlock {
        protected final String prefix;
        protected String suffix;
        protected final boolean requireAdjacentSeparator;
        protected final boolean emitWhenEmpty;
        private final boolean normalizingWhitespace;

        ContentBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix, boolean requireAdjacentSeparator, boolean emitWhenEmpty, boolean normalizingWhitespace, int leadingNewlines, int trailingNewlines) {
            super((AbstractMarkupDocumentBuilder)TextileDocumentBuilder.this, blockType, leadingNewlines, trailingNewlines);
            this.prefix = prefix;
            this.suffix = suffix;
            this.requireAdjacentSeparator = requireAdjacentSeparator;
            this.emitWhenEmpty = emitWhenEmpty;
            this.normalizingWhitespace = normalizingWhitespace;
        }

        ContentBlock(String prefix, String suffix, boolean requireAdjacentWhitespace, boolean emitWhenEmpty, int leadingNewlines, int trailingNewlines) {
            this(null, prefix, suffix, requireAdjacentWhitespace, emitWhenEmpty, true, leadingNewlines, trailingNewlines);
        }

        @Override
        public void lineBreak() throws IOException {
            this.write(10);
        }

        public void write(int c) throws IOException {
            if (this.normalizingWhitespace && (c = this.normalizeWhitespace(c)) == 32 && TextileDocumentBuilder.this.getLastChar() == ' ') {
                return;
            }
            TextileDocumentBuilder.this.emitContent(c);
        }

        public void write(String s) throws IOException {
            for (int x = 0; x < s.length(); ++x) {
                this.write(s.charAt(x));
            }
        }

        public void open() throws IOException {
            super.open();
            TextileDocumentBuilder.this.pushWriter(new StringWriter());
            if (this.requireAdjacentSeparator) {
                TextileDocumentBuilder.this.clearRequireAdjacentSeparator();
            }
        }

        public void close() throws IOException {
            Writer thisContent = TextileDocumentBuilder.this.popWriter();
            String content = thisContent.toString();
            boolean extendedBlock = this.isExtended(content);
            if (content.length() > 0 || this.emitWhenEmpty) {
                if (this.requireAdjacentSeparator) {
                    TextileDocumentBuilder.this.requireAdjacentSeparator();
                }
                this.emitContent(content, extendedBlock);
                if (this.requireAdjacentSeparator) {
                    TextileDocumentBuilder.this.requireAdjacentSeparator();
                }
            }
            super.close();
            if (this.getBlockType() != null) {
                TextileDocumentBuilder.this.previousWasExtended = extendedBlock;
            }
        }

        protected void emitContent(String content, boolean extended) throws IOException {
            String prefix = extended ? this.prefix.replace(".", "..") : this.prefix;
            Object suffix = extended ? this.suffix + "\n" : this.suffix;
            TextileDocumentBuilder.this.emitContent(prefix);
            TextileDocumentBuilder.this.emitContent(content);
            this.emitSuffix((String)suffix);
        }

        private void emitSuffix(String suffix) throws IOException {
            if (suffix.equals("\n")) {
                char lastChar = TextileDocumentBuilder.this.getLastChar();
                if (lastChar != '\n' && lastChar != '\u0000') {
                    TextileDocumentBuilder.this.emitContent(suffix);
                }
            } else {
                TextileDocumentBuilder.this.emitContent(suffix);
            }
        }

        private boolean isExtended(String content) {
            if (this.getBlockType() != null) {
                switch (this.getBlockType()) {
                    case CODE: 
                    case PREFORMATTED: 
                    case QUOTE: {
                        return PATTERN_MULTIPLE_NEWLINES.matcher(content).find();
                    }
                }
            }
            return false;
        }

        protected int normalizeWhitespace(int c) {
            return TextileDocumentBuilder.this.normalizeWhitespace(c);
        }
    }

    private static interface TextileBlock {
        public void lineBreak() throws IOException;
    }
}

