/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.creole.internal.token;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.creole.CreoleLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class LinkReplacementToken
extends PatternBasedElement {
    private static final Pattern replacementPattern = Pattern.compile("\\W");

    protected String getPattern(int groupOffset) {
        return "(~)?(\\[\\[([^\\]|]+)(?:[|]([^\\]]*))?\\]\\])";
    }

    protected int getPatternGroupCount() {
        return 4;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new LinkProcessor();
    }

    private static class LinkProcessor
    extends PatternBasedElementProcessor {
        private LinkProcessor() {
        }

        public void emit() {
            String escaped = this.group(1);
            if (escaped != null) {
                String escapedText = this.group(2);
                this.builder.characters(escapedText);
            } else {
                boolean looksLikeEmail;
                String link = this.group(3);
                String text = this.group(4);
                if (text == null || text.trim().length() == 0) {
                    text = link;
                }
                boolean bl = looksLikeEmail = link.indexOf(64) != -1;
                if (link.indexOf(47) != -1 || link.indexOf(35) != -1 || looksLikeEmail) {
                    if (looksLikeEmail) {
                        text = text.replaceFirst("\\s*mailto:", "");
                    }
                    this.builder.link(link, text);
                } else {
                    String target = replacementPattern.matcher(link).replaceAll("_");
                    CreoleLanguage creoleLanguage = (CreoleLanguage)this.markupLanguage;
                    boolean exists = creoleLanguage.computeInternalLinkExists(target);
                    String internalHref = creoleLanguage.toInternalHref(target);
                    if (!exists) {
                        this.builder.characters(text);
                        this.builder.link(internalHref, "?");
                    } else {
                        this.builder.link(internalHref, text);
                    }
                }
            }
        }
    }
}

