/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.findReferences;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.findReferences.TargetURIs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetURISet
extends AbstractSet<URI>
implements TargetURIs {
    private final Set<URI> uris = Sets.newLinkedHashSet();
    private final Multimap<URI, URI> index = HashMultimap.create((int)4, (int)4);
    private Map<TargetURIs.Key<? extends Object>, Object> userData;

    protected TargetURISet() {
    }

    @Override
    public Iterator<URI> iterator() {
        return Iterators.unmodifiableIterator(this.uris.iterator());
    }

    @Override
    public <T> T getUserData(TargetURIs.Key<T> key) {
        if (this.userData == null) {
            return null;
        }
        Object result = this.userData.get(key);
        if (result == null) {
            return null;
        }
        Class<T> type = key.getType();
        return type.cast(result);
    }

    @Override
    public <T> void putUserData(TargetURIs.Key<T> key, T data) {
        if (this.userData == null) {
            this.userData = Maps.newHashMap();
        }
        this.userData.put(key, data);
    }

    @Override
    public void addURI(URI uri) {
        if (this.uris.add(uri)) {
            this.index.put((Object)uri.trimFragment(), (Object)uri);
        }
    }

    @Override
    public void addAllURIs(Iterable<URI> uris) {
        for (URI uri : uris) {
            this.addURI(uri);
        }
    }

    @Override
    public Collection<URI> getTargetResourceURIs() {
        return Collections.unmodifiableCollection(this.index.keySet());
    }

    @Override
    public Collection<URI> getEObjectURIs(URI resourceURI) {
        return Collections.unmodifiableCollection(this.index.get((Object)resourceURI));
    }

    @Override
    public boolean contains(URI uri) {
        return this.uris.contains(uri);
    }

    @Override
    public boolean containsResource(URI resourceURI) {
        return this.index.containsKey((Object)resourceURI);
    }

    @Override
    public boolean isEmpty() {
        return this.uris.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.uris.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.uris.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.uris.toArray(a);
    }

    @Override
    public boolean add(URI e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.uris.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends URI> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        return this.uris.equals(o);
    }

    @Override
    public int hashCode() {
        return this.uris.hashCode();
    }

    @Override
    public int size() {
        return this.uris.size();
    }

    @Override
    public Set<URI> asSet() {
        return this;
    }
}

