/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.smoketest.internal;

import com.google.common.annotations.Beta;
import java.lang.annotation.Annotation;
import org.eclipse.xtext.junit4.IInjectorProvider;
import org.eclipse.xtext.junit4.IRegistryConfigurator;
import org.eclipse.xtext.junit4.XtextRunner;
import org.eclipse.xtext.junit4.smoketest.IgnoredBySmokeTest;
import org.eclipse.xtext.junit4.smoketest.ScenarioProcessor;
import org.eclipse.xtext.junit4.smoketest.internal.InjectorCache;
import org.eclipse.xtext.junit4.smoketest.internal.TestDataCarrier;
import org.eclipse.xtext.junit4.smoketest.internal.WrappingInjectorProvider;
import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractScenarioRunner
extends XtextRunner {
    private WrappingInjectorProvider injectorProvider = null;
    private final Class<? extends ScenarioProcessor> processorClass;

    public AbstractScenarioRunner(Class<?> klass, Class<? extends ScenarioProcessor> processorClass) throws InitializationError {
        super(klass);
        this.processorClass = processorClass;
    }

    protected Annotation[] getRunnerAnnotations() {
        return new Annotation[0];
    }

    protected String getProcessorName() {
        return this.processorClass.getSimpleName();
    }

    protected Class<? extends ScenarioProcessor> getProcessorClass() {
        return this.processorClass;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (this.isIgnored(method)) {
            notifier.fireTestIgnored(description);
        } else {
            this.runLeaf(this.methodBlock(method), description, notifier);
        }
    }

    protected boolean isIgnored(FrameworkMethod method) {
        if (method.getAnnotation(Ignore.class) != null) {
            return true;
        }
        return method.getAnnotation(IgnoredBySmokeTest.class) != null;
    }

    @Override
    protected Statement methodBlock(final FrameworkMethod method) {
        WrappingInjectorProvider injectorProvider = this.getOrCreateInjectorProvider();
        final IRegistryConfigurator registryConfigurator = injectorProvider;
        registryConfigurator.setupRegistry();
        final Statement methodBlock = this.superMethodBlock(method);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    try {
                        methodBlock.evaluate();
                        throw new AssumptionViolatedException("Method " + method.getName() + " did parse any input");
                    }
                    catch (Throwable throwable) {
                        registryConfigurator.restoreRegistry();
                        throw throwable;
                    }
                }
                catch (TestDataCarrier testData) {
                    AbstractScenarioRunner.this.process(testData.getData());
                    return;
                }
            }
        };
    }

    protected void process(String data) throws Exception {
        IInjectorProvider delegate = this.getOrCreateInjectorProvider().getDelegate();
        if (delegate instanceof IRegistryConfigurator) {
            IRegistryConfigurator registryConfigurator = (IRegistryConfigurator)((Object)delegate);
            registryConfigurator.setupRegistry();
            try {
                ScenarioProcessor processor = (ScenarioProcessor)delegate.getInjector().getInstance(this.processorClass);
                String preProcessed = processor.preProcess(data);
                if (preProcessed == null) {
                    throw new AssumptionViolatedException("Input is filtered by the pre processing step: " + data);
                }
                this.doProcess(preProcessed, processor);
            }
            finally {
                registryConfigurator.restoreRegistry();
            }
        }
    }

    protected abstract void doProcess(String var1, ScenarioProcessor var2) throws Exception;

    protected <T> T get(Class<T> service) {
        return (T)this.getOrCreateInjectorProvider().getDelegate().getInjector().getInstance(service);
    }

    @Override
    protected WrappingInjectorProvider getOrCreateInjectorProvider() {
        if (this.injectorProvider == null) {
            this.injectorProvider = InjectorCache.wrap(super.getOrCreateInjectorProvider());
            return this.injectorProvider;
        }
        return this.injectorProvider;
    }
}

