/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtend.lib.annotations.ToStringConfiguration;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Beta
public class ToStringProcessor
extends AbstractClassProcessor {
    public void doTransform(MutableClassDeclaration it, final @Extension TransformationContext context) {
        boolean _tripleNotEquals;
        Type _findTypeGlobally = context.findTypeGlobally(Data.class);
        AnnotationReference _findAnnotation = it.findAnnotation(_findTypeGlobally);
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        Util util = new Util(context);
        Type _findTypeGlobally_1 = context.findTypeGlobally(ToString.class);
        AnnotationReference annotation = it.findAnnotation(_findTypeGlobally_1);
        ToStringConfiguration configuration = new ToStringConfiguration(annotation);
        boolean _hasToString = util.hasToString((ClassDeclaration)it);
        if (_hasToString) {
            context.addWarning((Element)annotation, "toString is already defined, this annotation has no effect.");
        } else {
            TypeReference _object;
            boolean _notEquals;
            TypeReference _extendedClass = it.getExtendedClass();
            boolean bl2 = _notEquals = !Objects.equal((Object)_extendedClass, (Object)(_object = context.getObject()));
            if (_notEquals) {
                util.addReflectiveToString(it, configuration);
            } else {
                Iterable _declaredFields = it.getDeclaredFields();
                Functions.Function1<MutableFieldDeclaration, Boolean> _function = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

                    public Boolean apply(MutableFieldDeclaration it) {
                        boolean _isTransient;
                        boolean _not_1;
                        boolean _isStatic;
                        boolean _not;
                        boolean _and = false;
                        boolean _and_1 = false;
                        boolean _isThePrimaryGeneratedJavaElement = context.isThePrimaryGeneratedJavaElement((Element)it);
                        _and_1 = !_isThePrimaryGeneratedJavaElement ? false : (_not = !(_isStatic = it.isStatic()));
                        _and = !_and_1 ? false : (_not_1 = !(_isTransient = it.isTransient()));
                        return _and;
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)_declaredFields, (Functions.Function1)_function);
                util.addToString(it, _filter, configuration);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        public boolean hasToString(ClassDeclaration it) {
            MethodDeclaration _findDeclaredMethod = it.findDeclaredMethod("toString", new TypeReference[0]);
            return _findDeclaredMethod != null;
        }

        public ToStringConfiguration getToStringConfig(ClassDeclaration it) {
            ToStringConfiguration _xblockexpression = null;
            Type _findTypeGlobally = this.context.findTypeGlobally(ToString.class);
            AnnotationReference anno = it.findAnnotation(_findTypeGlobally);
            ToStringConfiguration _xifexpression = null;
            boolean _tripleEquals = anno == null;
            _xifexpression = _tripleEquals ? null : new ToStringConfiguration(anno);
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public void addReflectiveToString(final MutableClassDeclaration cls, final ToStringConfiguration config) {
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    Element _primarySourceElement = Util.this.context.getPrimarySourceElement((Element)cls);
                    Util.this.context.setPrimarySourceElement((MutableElement)it, _primarySourceElement);
                    TypeReference _string = Util.this.context.getString();
                    it.setReturnType(_string);
                    AnnotationReference _newAnnotationReference = Util.this.context.newAnnotationReference(Override.class);
                    it.addAnnotation(_newAnnotationReference);
                    AnnotationReference _newAnnotationReference_1 = Util.this.context.newAnnotationReference(Pure.class);
                    it.addAnnotation(_newAnnotationReference_1);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"String result = new ");
                            _builder.append(ToStringBuilder.class, "");
                            _builder.append((Object)"(this)");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".addAllFields()");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            boolean _isSkipNulls = config.isSkipNulls();
                            if (_isSkipNulls) {
                                _builder.append((Object)".skipNulls()");
                            }
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            boolean _isSingleLine = config.isSingleLine();
                            if (_isSingleLine) {
                                _builder.append((Object)".singleLine()");
                            }
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            boolean _isHideFieldNames = config.isHideFieldNames();
                            if (_isHideFieldNames) {
                                _builder.append((Object)".hideFieldNames()");
                            }
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".toString();");
                            _builder.newLine();
                            _builder.append((Object)"return result;");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                }
            };
            cls.addMethod("toString", (Procedures.Procedure1)_function);
        }

        public void addToString(final MutableClassDeclaration cls, final Iterable<? extends FieldDeclaration> fields, final ToStringConfiguration config) {
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    Element _primarySourceElement = Util.this.context.getPrimarySourceElement((Element)cls);
                    Util.this.context.setPrimarySourceElement((MutableElement)it, _primarySourceElement);
                    TypeReference _string = Util.this.context.getString();
                    it.setReturnType(_string);
                    AnnotationReference _newAnnotationReference = Util.this.context.newAnnotationReference(Override.class);
                    it.addAnnotation(_newAnnotationReference);
                    AnnotationReference _newAnnotationReference_1 = Util.this.context.newAnnotationReference(Pure.class);
                    it.addAnnotation(_newAnnotationReference_1);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append(ToStringBuilder.class, "");
                            _builder.append((Object)" b = new ");
                            _builder.append(ToStringBuilder.class, "");
                            _builder.append((Object)"(this);");
                            _builder.newLineIfNotEmpty();
                            boolean _isSkipNulls = config.isSkipNulls();
                            if (_isSkipNulls) {
                                _builder.append((Object)"b.skipNulls();");
                            }
                            _builder.newLineIfNotEmpty();
                            boolean _isSingleLine = config.isSingleLine();
                            if (_isSingleLine) {
                                _builder.append((Object)"b.singleLine();");
                            }
                            _builder.newLineIfNotEmpty();
                            boolean _isHideFieldNames = config.isHideFieldNames();
                            if (_isHideFieldNames) {
                                _builder.append((Object)"b.hideFieldNames();");
                            }
                            _builder.newLineIfNotEmpty();
                            for (FieldDeclaration field : fields) {
                                _builder.append((Object)"b.add(\"");
                                String _simpleName = field.getSimpleName();
                                _builder.append((Object)_simpleName, "");
                                _builder.append((Object)"\", this.");
                                String _simpleName_1 = field.getSimpleName();
                                _builder.append((Object)_simpleName_1, "");
                                _builder.append((Object)");");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"return b.toString();");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                }
            };
            cls.addMethod("toString", (Procedures.Procedure1)_function);
        }
    }
}

