/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.project;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.xtext.ui.wizard.IProjectCreator;
import org.eclipse.xtext.ui.wizard.IProjectInfo;
import org.eclipse.xtext.ui.wizard.XtextNewProjectWizard;
import org.eclipse.xtext.xtext.ui.Activator;
import org.eclipse.xtext.xtext.ui.wizard.project.Messages;
import org.eclipse.xtext.xtext.ui.wizard.project.WizardContribution;
import org.eclipse.xtext.xtext.ui.wizard.project.WizardNewXtextProjectCreationPage;
import org.eclipse.xtext.xtext.ui.wizard.project.XtextProjectInfo;

public class NewXtextProjectWizard
extends XtextNewProjectWizard {
    private WizardNewXtextProjectCreationPage mainPage;

    @Inject
    public NewXtextProjectWizard(IProjectCreator projectCreator) {
        super(projectCreator);
        this.setWindowTitle(Messages.NewXtextProjectWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(Activator.getImageDescriptor("icons/wizban/newxprj_wiz.gif"));
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewXtextProjectCreationPage("mainPage", this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    protected IProjectInfo getProjectInfo() {
        XtextProjectInfo projectInfo = this.createProjectInfo();
        projectInfo.setCreateTestProject(true);
        projectInfo.setCreateFeatureProject(this.mainPage.isCreateFeatureProject());
        projectInfo.setFileExtension(this.mainPage.getFileExtensions());
        projectInfo.setLanguageName(this.mainPage.getLanguageName());
        projectInfo.setProjectName(this.mainPage.getProjectName());
        projectInfo.setWorkingSets(this.mainPage.getSelectedWorkingSets());
        Map<String, WizardContribution> contributions = WizardContribution.getFromRegistry();
        projectInfo.setWizardContribution(contributions.get(this.mainPage.getGeneratorConfig()));
        projectInfo.setProjectsRootLocation(this.mainPage.getLocationPath());
        projectInfo.setWorkbench(this.getWorkbench());
        projectInfo.setCreateEclipseRuntimeLaunchConfig(!this.existsEclipseRuntimeLaunchConfig());
        String encoding = null;
        try {
            encoding = ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
        }
        catch (CoreException e) {
            encoding = System.getProperty("file.encoding");
        }
        projectInfo.setEncoding(encoding);
        return projectInfo;
    }

    private boolean existsEclipseRuntimeLaunchConfig() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            try {
                if (p.isAccessible() && p.getFile(".launch/Launch Runtime Eclipse.launch").exists()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return false;
    }

    protected XtextProjectInfo createProjectInfo() {
        return new XtextProjectInfo();
    }
}

