/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.IRefactoringDocument;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.imports.ImportedTypesCollector;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.imports.StaticallyImportedMemberProvider;
import org.eclipse.xtext.xbase.imports.TypeUsages;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.JvmModelReferenceUpdater;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XtypePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseReferenceUpdater
extends JvmModelReferenceUpdater {
    @Inject
    private IValueConverterService valueConverterService;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private RewritableImportSection.Factory importSectionFactory;
    @Inject
    private ReplaceConverter replaceConverter;
    @Inject
    private ImportedTypesCollector importedTypesCollector;
    @Inject
    private StaticallyImportedMemberProvider staticallyImportedMemberProvider;

    @Override
    protected void createReferenceUpdate(EObject referringElement, URI referringResourceURI, EReference reference, int indexInList, EObject newTargetElement, IRefactoringUpdateAcceptor updateAcceptor) {
        if (referringElement instanceof XImportDeclaration) {
            XImportDeclaration importDeclaration = (XImportDeclaration)referringElement;
            JvmDeclaredType importedType = importDeclaration.getImportedType();
            boolean isStatic = importDeclaration.isStatic();
            boolean isExtension = importDeclaration.isExtension();
            String memberName = importDeclaration.getMemberName();
            if (newTargetElement instanceof JvmDeclaredType) {
                JvmDeclaredType type = (JvmDeclaredType)newTargetElement;
                ImportAwareUpdateAcceptor importAwareUpdateAcceptor = (ImportAwareUpdateAcceptor)updateAcceptor;
                importAwareUpdateAcceptor.removeImport(type, isStatic, isExtension, memberName);
                importAwareUpdateAcceptor.acceptImport(type, isStatic, isExtension, memberName);
                return;
            }
            if (newTargetElement instanceof JvmFeature) {
                JvmFeature feature = (JvmFeature)newTargetElement;
                String featureName = feature.getSimpleName();
                if (featureName.equals(memberName)) {
                    return;
                }
                ImportAwareUpdateAcceptor importAwareUpdateAcceptor = (ImportAwareUpdateAcceptor)updateAcceptor;
                if (!importAwareUpdateAcceptor.isUsed(importedType, isStatic, isExtension, memberName)) {
                    importAwareUpdateAcceptor.removeImport(importedType, isStatic, isExtension, memberName);
                }
                if (importAwareUpdateAcceptor.isConflicted(importedType, isStatic, isExtension, featureName)) {
                    JvmDeclaredType parentType = importedType;
                    while (parentType != null && !importAwareUpdateAcceptor.getImportSection().hasImportedType(parentType) && !importAwareUpdateAcceptor.acceptImport(parentType, false, false, null)) {
                        parentType = parentType.getDeclaringType();
                    }
                } else {
                    importAwareUpdateAcceptor.acceptImport(importedType, isStatic, isExtension, featureName);
                }
                return;
            }
        }
        if (referringElement instanceof XAbstractFeatureCall && newTargetElement instanceof JvmDeclaredType) {
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)referringElement;
            JvmIdentifiableElement feature = featureCall.getFeature();
            if (this.isStaticExtensionFeatureCall(referringElement, reference, (EObject)feature)) {
                return;
            }
            if (this.isStaticFeatureCall(referringElement, reference, (EObject)feature)) {
                return;
            }
        }
        if (!(referringElement instanceof XFeatureCall) || !(newTargetElement instanceof JvmConstructor)) {
            super.createReferenceUpdate(referringElement, referringResourceURI, reference, indexInList, newTargetElement, updateAcceptor);
        }
    }

    protected String resolveNameConflict(EObject referringElement, EReference reference, EObject newTargetElement, IRefactoringUpdateAcceptor updateAcceptor) {
        if (EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_IDENTIFIABLE_ELEMENT, (EClass)reference.getEReferenceType())) {
            JvmDeclaredType declaringType;
            JvmFeature feature;
            JvmType type;
            if (newTargetElement instanceof JvmType && this.canLinkJvmType(referringElement, type = (JvmType)newTargetElement)) {
                return this.toString(this.qualifiedNameProvider.getFullyQualifiedName((EObject)type));
            }
            if (newTargetElement instanceof JvmFeature && (feature = (JvmFeature)newTargetElement).isStatic() && !this.isStaticExtensionFeatureCall(referringElement, reference, newTargetElement) && this.canLinkJvmType(referringElement, (JvmType)(declaringType = feature.getDeclaringType()))) {
                JvmDeclaredType parentType = declaringType;
                LinkedList<String> segments = new LinkedList<String>();
                segments.add(feature.getSimpleName());
                segments.add(0, parentType.getSimpleName());
                while (!this.hasImportedType(updateAcceptor, parentType)) {
                    if ((parentType = parentType.getDeclaringType()) == null) {
                        return this.toString(this.qualifiedNameProvider.getFullyQualifiedName((EObject)feature));
                    }
                    segments.add(0, parentType.getSimpleName());
                }
                return this.toString(QualifiedName.create(segments));
            }
        }
        return super.resolveNameConflict(referringElement, reference, newTargetElement, updateAcceptor);
    }

    protected String toString(QualifiedName qualifiedName) {
        String value = this.qualifiedNameConverter.toString(qualifiedName);
        try {
            return this.valueConverterService.toString((Object)value, "QualifiedName");
        }
        catch (ValueConverterException e) {
            return null;
        }
    }

    protected boolean canLinkJvmType(EObject referringElement, JvmType type) {
        if (type == null) {
            return false;
        }
        QualifiedName qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)type);
        if (qualifiedName == null) {
            return false;
        }
        IScope scope = this.getLinkingScopeProvider().getScope(referringElement, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
        return scope.getSingleElement(qualifiedName) != null;
    }

    protected boolean hasImportedType(IRefactoringUpdateAcceptor updateAcceptor, JvmDeclaredType declaringType) {
        if (updateAcceptor instanceof ImportAwareUpdateAcceptor) {
            ImportAwareUpdateAcceptor importAwareUpdateAcceptor = (ImportAwareUpdateAcceptor)updateAcceptor;
            return importAwareUpdateAcceptor.getImportSection().hasImportedType(declaringType);
        }
        return false;
    }

    protected void processReferringResource(Resource referringResource, Iterable<IReferenceDescription> referenceDescriptions, ElementRenameArguments elementRenameArguments, IRefactoringUpdateAcceptor updateAcceptor) {
        ImportAwareUpdateAcceptor importAwareUpdateAcceptor = this.createUpdateAcceptor(referringResource, updateAcceptor);
        Iterable<IReferenceDescription> importTypeReferences = this.getImportTypeReferences(referenceDescriptions);
        super.processReferringResource(referringResource, importTypeReferences, elementRenameArguments, (IRefactoringUpdateAcceptor)importAwareUpdateAcceptor);
        importAwareUpdateAcceptor.getImportSection().update();
        Iterable<IReferenceDescription> notImportTypeReferences = this.getNotImportTypeReferences(referenceDescriptions);
        super.processReferringResource(referringResource, notImportTypeReferences, elementRenameArguments, (IRefactoringUpdateAcceptor)importAwareUpdateAcceptor);
        List importChanges = importAwareUpdateAcceptor.getImportSection().rewrite();
        TextEdit importChangeEdit = this.replaceConverter.convertToTextEdit(importChanges);
        if (importChangeEdit != null) {
            updateAcceptor.accept(referringResource.getURI(), importChangeEdit);
        }
    }

    protected Iterable<IReferenceDescription> getImportTypeReferences(Iterable<IReferenceDescription> referenceDescriptions) {
        return IterableExtensions.filter(referenceDescriptions, (Functions.Function1)new Functions.Function1<IReferenceDescription, Boolean>(){

            public Boolean apply(IReferenceDescription p) {
                return XbaseReferenceUpdater.this.isImportTypeReference(p);
            }
        });
    }

    protected Iterable<IReferenceDescription> getNotImportTypeReferences(Iterable<IReferenceDescription> referenceDescriptions) {
        return IterableExtensions.filter(referenceDescriptions, (Functions.Function1)new Functions.Function1<IReferenceDescription, Boolean>(){

            public Boolean apply(IReferenceDescription p) {
                return !XbaseReferenceUpdater.this.isImportTypeReference(p);
            }
        });
    }

    protected ImportAwareUpdateAcceptor createUpdateAcceptor(Resource referringResource, IRefactoringUpdateAcceptor updateAcceptor) {
        return new ImportAwareUpdateAcceptor((XtextResource)referringResource, updateAcceptor);
    }

    protected boolean isImportTypeReference(IReferenceDescription input) {
        return input.getEReference() == XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE;
    }

    protected void createTextChange(ITextRegion referenceTextRegion, String newReferenceText, EObject referringElement, EObject newTargetElement, EReference reference, URI referringResourceURI, IRefactoringUpdateAcceptor updateAcceptor) {
        ImportAwareUpdateAcceptor importAwareUpdateAcceptor;
        JvmType newTargetType;
        Pair<JvmDeclaredType, QualifiedName> importedTypeAndRelativeName;
        if (newReferenceText != null && updateAcceptor instanceof ImportAwareUpdateAcceptor && this.isReferenceToJvmType(newTargetElement, reference) && (importedTypeAndRelativeName = this.getImportedTypeAndRelativeName(newTargetType = (JvmType)newTargetElement, (importAwareUpdateAcceptor = (ImportAwareUpdateAcceptor)updateAcceptor).getImportSection())) != null) {
            JvmDeclaredType importedType = (JvmDeclaredType)importedTypeAndRelativeName.getFirst();
            QualifiedName importRelativeName = (QualifiedName)importedTypeAndRelativeName.getSecond();
            importAwareUpdateAcceptor.removeImport(importedType, false, false, null);
            if (this.isReferencedByQualifiedName(referringElement, newTargetType, importRelativeName)) {
                QualifiedName newTypeQualifiedName = this.qualifiedNameProvider.getFullyQualifiedName(newTargetElement);
                newReferenceText = this.getLinkText(newTypeQualifiedName, newReferenceText);
            } else {
                if (!Strings.isEmpty((String)importedType.getPackageName())) {
                    importAwareUpdateAcceptor.acceptImport(importedType, false, false, null);
                }
                newReferenceText = this.getLinkText(importRelativeName, newReferenceText);
            }
        }
        super.createTextChange(referenceTextRegion, newReferenceText, referringElement, newTargetElement, reference, referringResourceURI, updateAcceptor);
    }

    protected boolean isReferenceToJvmType(EObject newTargetElement, EReference reference) {
        return newTargetElement instanceof JvmType && EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_TYPE, (EClass)reference.getEReferenceType());
    }

    protected boolean isReferencedByQualifiedName(EObject referringElement, JvmType newTargetType, QualifiedName importRelativeName) {
        IScope scope = this.getLinkingScopeProvider().getScope(referringElement, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
        IEObjectDescription singleElement = scope.getSingleElement(importRelativeName);
        if (singleElement == null) {
            return false;
        }
        EObject resolvedSingleElement = EcoreUtil.resolve((EObject)singleElement.getEObjectOrProxy(), (EObject)referringElement);
        return resolvedSingleElement != EcoreUtil2.getContainerOfType((EObject)newTargetType, JvmDeclaredType.class);
    }

    protected boolean isStaticFeatureCall(EObject referringElement, EReference reference, EObject newTargetElement) {
        return referringElement instanceof XFeatureCall && reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE && newTargetElement instanceof JvmFeature && ((JvmFeature)newTargetElement).isStatic();
    }

    protected boolean isStaticExtensionFeatureCall(EObject referringElement, EReference reference, EObject newTargetElement) {
        return referringElement instanceof XMemberFeatureCall && reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE && newTargetElement instanceof JvmFeature && ((JvmFeature)newTargetElement).isStatic() && !((XMemberFeatureCall)referringElement).isStaticWithDeclaringType();
    }

    protected Pair<JvmDeclaredType, QualifiedName> getImportedTypeAndRelativeName(JvmType newTargetType, RewritableImportSection section) {
        if (!(newTargetType instanceof JvmDeclaredType)) {
            return null;
        }
        JvmDeclaredType importedType = (JvmDeclaredType)newTargetType;
        StringBuffer relativeName = new StringBuffer(importedType.getSimpleName());
        while (importedType.getDeclaringType() != null && !section.hasImportedType(importedType)) {
            importedType = importedType.getDeclaringType();
            relativeName.insert(0, ".");
            relativeName.insert(0, importedType.getSimpleName());
        }
        return Tuples.create((Object)importedType, (Object)this.qualifiedNameConverter.toQualifiedName(relativeName.toString()));
    }

    protected String getLinkText(QualifiedName importRelativeName, String newReferenceText) {
        if (newReferenceText.endsWith("::")) {
            return String.valueOf(importRelativeName.toString("::")) + "::";
        }
        return importRelativeName.toString(".");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ImportAwareUpdateAcceptor
    implements IRefactoringUpdateAcceptor {
        private TypeUsages typeUsages;
        private final XtextResource resource;
        private final IRefactoringUpdateAcceptor delegate;
        private final RewritableImportSection importSection;

        public ImportAwareUpdateAcceptor(XtextResource resource, IRefactoringUpdateAcceptor delegate) {
            this.resource = resource;
            this.delegate = delegate;
            this.importSection = XbaseReferenceUpdater.this.importSectionFactory.parse(resource);
        }

        public void accept(URI resourceURI, TextEdit textEdit) {
            this.delegate.accept(resourceURI, textEdit);
        }

        public void accept(URI resourceURI, Change change) {
            this.delegate.accept(resourceURI, change);
        }

        public StatusWrapper getRefactoringStatus() {
            return this.delegate.getRefactoringStatus();
        }

        public IRefactoringDocument getDocument(URI resourceURI) {
            return this.delegate.getDocument(resourceURI);
        }

        public Change createCompositeChange(String name, IProgressMonitor monitor) {
            return this.delegate.createCompositeChange(name, monitor);
        }

        public boolean acceptImport(JvmDeclaredType type, boolean isStatic, boolean isExtension, String memberName) {
            if (isExtension) {
                return this.importSection.addStaticExtensionImport(type, memberName);
            }
            if (isStatic) {
                return this.importSection.addStaticImport(type, memberName);
            }
            return this.importSection.addImport(type);
        }

        public boolean removeImport(JvmDeclaredType type, boolean isStatic, boolean isExtension, String memberName) {
            if (isExtension) {
                return this.importSection.removeStaticExtensionImport(type, memberName);
            }
            if (isStatic) {
                return this.importSection.removeStaticImport(type, memberName);
            }
            return this.importSection.removeImport(type);
        }

        public boolean isUsed(JvmDeclaredType type, boolean isStatic, boolean isExtension, String memberName) {
            if (!isStatic) {
                return false;
            }
            Iterator allFeatures = XbaseReferenceUpdater.this.staticallyImportedMemberProvider.getAllFeatures((Resource)this.resource, type, isStatic, isExtension, memberName).iterator();
            if (!allFeatures.hasNext()) {
                return false;
            }
            TypeUsages typeUsages = this.getTypeUsages();
            while (allFeatures.hasNext()) {
                JvmFeature feature = (JvmFeature)allFeatures.next();
                if (!typeUsages.getStaticImports().contains(feature) && !typeUsages.getExtensionImports().contains(feature)) continue;
                return true;
            }
            return false;
        }

        public boolean isConflicted(JvmDeclaredType type, boolean isStatic, boolean isExtension, String memberName) {
            if (!isStatic || memberName == null) {
                return false;
            }
            if (this.importSection.hasStaticImport(memberName, isExtension)) {
                return true;
            }
            TypeUsages typeUsages = this.getTypeUsages();
            if (isExtension && !this.contains(type, memberName, typeUsages.getStaticImports())) {
                return false;
            }
            return this.isConflicted(type, memberName, typeUsages.getStaticImports());
        }

        protected boolean isConflicted(JvmDeclaredType type, String memberName, Set<JvmMember> importedMembers) {
            for (JvmMember importedMember : importedMembers) {
                if (importedMember.getDeclaringType() == type || !memberName.equals(importedMember.getSimpleName())) continue;
                return true;
            }
            return false;
        }

        protected boolean contains(JvmDeclaredType type, String memberName, Set<JvmMember> importedMembers) {
            for (JvmMember staticImport : importedMembers) {
                if (staticImport.getDeclaringType() != type || !memberName.equals(staticImport.getSimpleName())) continue;
                return true;
            }
            return false;
        }

        public RewritableImportSection getImportSection() {
            return this.importSection;
        }

        public TypeUsages getTypeUsages() {
            if (this.typeUsages == null) {
                this.typeUsages = XbaseReferenceUpdater.this.importedTypesCollector.collectTypeUsages(this.resource);
            }
            return this.typeUsages;
        }
    }
}

