/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.refactoring;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.linking.LinkingScopeProviderBinding;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.DefaultReferenceUpdater;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringCrossReferenceSerializer;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;

public class JvmModelReferenceUpdater
extends DefaultReferenceUpdater {
    @Inject
    private IJvmModelAssociations jvmModelAssociations;
    @Inject
    @LinkingScopeProviderBinding
    private IScopeProvider linkingScopeProvider;

    protected void createReferenceUpdate(EObject referringElement, URI referringResourceURI, EReference reference, int indexInList, EObject newTargetElement, IRefactoringUpdateAcceptor updateAcceptor) {
        if (!this.isInferredJvmModelElement(referringElement)) {
            super.createReferenceUpdate(referringElement, referringResourceURI, reference, indexInList, newTargetElement, updateAcceptor);
        }
    }

    protected boolean isInferredJvmModelElement(EObject element) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)element);
        return !Iterables.isEmpty((Iterable)this.jvmModelAssociations.getSourceElements(rootContainer));
    }

    protected ReferenceSyntax getReferenceSyntax(EObject referringElement, EReference reference, int indexInList) {
        if (reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE) {
            if (referringElement instanceof XAssignment) {
                return ReferenceSyntax.SET_BY_ASSIGNMENT;
            }
            List nodes = NodeModelUtils.findNodesForFeature((EObject)referringElement, (EStructuralFeature)reference);
            int index = Math.max(indexInList, 0);
            if (nodes.size() < index) {
                return null;
            }
            INode oldNode = (INode)nodes.get(index);
            String referenceText = oldNode.getText().trim();
            return this.getReferenceSyntax(referenceText);
        }
        return null;
    }

    protected ReferenceSyntax getReferenceSyntax(String referenceText) {
        if (referenceText.startsWith("get") && referenceText.length() > 3) {
            return ReferenceSyntax.EXPLICIT_GET;
        }
        if (referenceText.startsWith("set") && referenceText.length() > 3) {
            return ReferenceSyntax.EXPLICIT_SET;
        }
        if (referenceText.startsWith("is") && referenceText.length() > 2) {
            return ReferenceSyntax.EXPLICIT_IS;
        }
        return ReferenceSyntax.OTHER;
    }

    protected RefactoringCrossReferenceSerializer.RefTextEvaluator getRefTextEvaluator(final EObject referringElement, URI referringResourceURI, final EReference reference, int indexInList, EObject newTargetElement) {
        final ReferenceSyntax oldReferenceSyntax = this.getReferenceSyntax(referringElement, reference, indexInList);
        if (oldReferenceSyntax == null) {
            return super.getRefTextEvaluator(referringElement, referringResourceURI, reference, indexInList, newTargetElement);
        }
        return new RefactoringCrossReferenceSerializer.RefTextEvaluator(){

            public boolean isValid(IEObjectDescription newTarget) {
                IIdentifiableElementDescription casted;
                IScope scope = JvmModelReferenceUpdater.this.linkingScopeProvider.getScope(referringElement, reference);
                IEObjectDescription element = scope.getSingleElement(newTarget.getName());
                if (!(!(element instanceof IIdentifiableElementDescription) || (casted = (IIdentifiableElementDescription)element).isVisible() && casted.isValidStaticState())) {
                    return false;
                }
                return element != null && element.getEObjectURI() != null && element.getEObjectURI().equals(newTarget.getEObjectURI());
            }

            public boolean isBetterThan(String newText, String currentText) {
                ReferenceSyntax newSyntax = JvmModelReferenceUpdater.this.getReferenceSyntax(newText);
                ReferenceSyntax currentSyntax = JvmModelReferenceUpdater.this.getReferenceSyntax(currentText);
                if (newSyntax == oldReferenceSyntax && currentSyntax != oldReferenceSyntax) {
                    return true;
                }
                if (newSyntax != oldReferenceSyntax && currentSyntax == oldReferenceSyntax) {
                    return false;
                }
                return newText.length() < currentText.length();
            }
        };
    }

    protected IScopeProvider getLinkingScopeProvider() {
        return this.linkingScopeProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ReferenceSyntax {
        EXPLICIT_GET,
        EXPLICIT_SET,
        EXPLICIT_IS,
        SET_BY_ASSIGNMENT,
        OTHER;

    }
}

